/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl;

import java.util.ArrayList;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPushException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfigManager;
import net.thevpc.nuts.NutsRepositoryNotFoundException;
import net.thevpc.nuts.NutsSearchId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSpeedQualifier;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.event.DefaultNutsContentEvent;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsSearchIdByDescriptor;
import net.thevpc.nuts.runtime.standalone.id.util.NutsIdUtils;
import net.thevpc.nuts.runtime.standalone.repository.NutsRepositoryHelper;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryExt;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;
import net.thevpc.nuts.spi.NutsPushRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class NutsRepositoryMirroringHelper {
    private final NutsRepository repo;
    protected NutsRepositoryFolderHelper cache;

    public NutsRepositoryMirroringHelper(NutsRepository repo, NutsRepositoryFolderHelper cache) {
        this.repo = repo;
        this.cache = cache;
    }

    protected NutsIterator<NutsId> searchVersionsImpl_appendMirrors(NutsIterator<NutsId> namedNutIdIterator, NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        if (!session.isTransitive()) {
            return namedNutIdIterator;
        }
        ArrayList list = new ArrayList();
        list.add(namedNutIdIterator);
        if (this.repo.config().setSession(session).isSupportedMirroring()) {
            for (NutsRepository repo : this.repo.config().setSession(session).getMirrors()) {
                NutsSpeedQualifier sup = NutsSpeedQualifier.UNAVAILABLE;
                try {
                    sup = NutsRepositoryHelper.getSupportSpeedLevel(repo, NutsRepositorySupportedAction.SEARCH, id, fetchMode, session.isTransitive(), session);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (sup == NutsSpeedQualifier.UNAVAILABLE) continue;
                NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(repo);
                list.add(IteratorBuilder.of(repoSPI.searchVersions().setId(id).setFilter(idFilter).setSession(session).setFetchMode(fetchMode).getResult(), session).named("searchInMirror(" + repo.getName() + ")").safeIgnore().build());
            }
        }
        return IteratorUtils.concat(list);
    }

    protected NutsContent fetchContent(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsSession session) {
        NutsPath cacheContent = this.cache.getLongIdLocalFile(id, session);
        NutsRepositoryConfigManager rconfig = this.repo.config().setSession(session);
        if (session.isTransitive() && rconfig.isSupportedMirroring()) {
            for (NutsRepository mirror : rconfig.setSession(session).getMirrors()) {
                try {
                    NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(mirror);
                    NutsContent c = repoSPI.fetchContent().setId(id).setDescriptor(descriptor).setLocalPath(cacheContent.toString()).setSession(session).setFetchMode(fetchMode).getResult();
                    if (c != null) {
                        if (localPath == null) {
                            return c;
                        }
                        NutsCp.of((NutsSession)session).from(c.getFile()).to(localPath).addOptions(new NutsPathOption[]{NutsPathOption.SAFE}).run();
                        return c;
                    }
                }
                catch (NutsNotFoundException nutsNotFoundException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public NutsWorkspace getWorkspace() {
        return this.repo.getWorkspace();
    }

    protected String getIdFilename(NutsId id, NutsSession session) {
        return NutsRepositoryExt.of(this.repo).getIdFilename(id, session);
    }

    protected NutsDescriptor fetchDescriptorImplInMirrors(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        String idFilename = this.getIdFilename(id, session);
        NutsPath versionFolder = this.cache.getLongIdLocalFolder(id, session);
        NutsRepositoryConfigManager rconf = this.repo.config().setSession(session);
        if (session.isTransitive() && rconf.isSupportedMirroring()) {
            for (NutsRepository remote : rconf.getMirrors()) {
                NutsDescriptor nutsDescriptor = null;
                try {
                    NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(remote);
                    nutsDescriptor = repoSPI.fetchDescriptor().setId(id).setSession(session).setFetchMode(fetchMode).getResult();
                }
                catch (Exception repoSPI) {
                    // empty catch block
                }
                if (nutsDescriptor == null) continue;
                NutsPath goodFile = null;
                goodFile = versionFolder.resolve(idFilename);
                nutsDescriptor.formatter().setSession(session).print(goodFile);
                return nutsDescriptor;
            }
        }
        return null;
    }

    public NutsIterator<NutsId> search(NutsIterator<NutsId> li, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        NutsRepositoryConfigManager rconfig = this.repo.config().setSession(session);
        if (!session.isTransitive() || !rconfig.isSupportedMirroring()) {
            return li;
        }
        ArrayList all = new ArrayList();
        all.add(li);
        for (NutsRepository remote : rconfig.setSession(session).getMirrors()) {
            NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(remote);
            all.add(IteratorUtils.safeIgnore(repoSPI.search().setFilter(filter).setSession(session).setFetchMode(fetchMode).getResult(), session));
        }
        return IteratorUtils.concat(all);
    }

    public void push(NutsPushRepositoryCommand cmd) {
        NutsSession session = cmd.getSession();
        NutsWorkspaceUtils.checkSession(this.getWorkspace(), session);
        NutsId id = cmd.getId();
        String repository = cmd.getRepository();
        NutsSession nonTransitiveSession = session.copy().setTransitive(Boolean.valueOf(false));
        NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(this.repo);
        NutsDescriptor desc = repoSPI.fetchDescriptor().setId(id).setSession(nonTransitiveSession).setFetchMode(NutsFetchMode.LOCAL).getResult();
        NutsContent local = repoSPI.fetchContent().setId(id).setSession(nonTransitiveSession).setFetchMode(NutsFetchMode.LOCAL).getResult();
        if (local == null) {
            throw new NutsNotFoundException(session, id);
        }
        if (!this.repo.config().setSession(session).isSupportedMirroring()) {
            throw new NutsPushException(session, id, NutsMessage.cstyle((String)"unable to push %s. no repository found.", (Object[])new Object[]{id == null ? "<null>" : id}));
        }
        NutsRepository repo = this.repo;
        if (NutsBlankable.isBlank((String)repository)) {
            ArrayList<NutsRepository> all = new ArrayList<NutsRepository>();
            for (NutsRepository remote : repo.config().setSession(session).getMirrors()) {
                NutsSpeedQualifier lvl = NutsRepositoryHelper.getSupportSpeedLevel(remote, NutsRepositorySupportedAction.DEPLOY, id, NutsFetchMode.LOCAL, false, session);
                if (lvl == NutsSpeedQualifier.UNAVAILABLE) continue;
                all.add(remote);
            }
            if (all.isEmpty()) {
                throw new NutsPushException(session, id, NutsMessage.cstyle((String)"unable to push %s. no repository found.", (Object[])new Object[]{id == null ? "<null>" : id}));
            }
            if (all.size() > 1) {
                throw new NutsPushException(session, id, NutsMessage.cstyle((String)"unable to perform push for %s. at least two Repositories (%s) provides the same nuts %s", (Object[])new Object[]{id, all.stream().map(NutsRepository::getName).collect(Collectors.joining(",")), id}));
            }
            repo = (NutsRepository)all.get(0);
        } else {
            repo = this.repo.config().setSession(session.copy().setTransitive(Boolean.valueOf(false))).getMirror(repository);
        }
        if (repo == null) {
            throw new NutsRepositoryNotFoundException(session, repository);
        }
        NutsId effId = NutsIdUtils.createContentFaceId(id.builder().setProperties("").build(), desc, session);
        NutsDeployRepositoryCommand dep = repoSPI.deploy().setId(effId).setContent(local.getFile()).setDescriptor(desc).setSession(session).run();
        NutsRepositoryHelper.of(repo).events().fireOnPush(new DefaultNutsContentEvent(local.getPath(), (NutsRepositoryCommand)dep, session, repo));
    }

    public NutsId searchLatestVersion(NutsId bestId, NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        NutsRepositoryConfigManager rconfig = this.repo.config().setSession(session);
        if (session.isTransitive() && rconfig.isSupportedMirroring()) {
            for (NutsRepository remote : rconfig.setSession(session).getMirrors()) {
                NutsDescriptor nutsDescriptor = null;
                try {
                    NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(remote);
                    nutsDescriptor = repoSPI.fetchDescriptor().setId(id).setSession(session).setFetchMode(fetchMode).getResult();
                }
                catch (Exception repoSPI) {
                    // empty catch block
                }
                if (nutsDescriptor == null || filter != null && !filter.acceptSearchId((NutsSearchId)new NutsSearchIdByDescriptor(nutsDescriptor), session)) continue;
                NutsWorkspaceExt dws = NutsWorkspaceExt.of(this.getWorkspace());
                NutsId id2 = dws.resolveEffectiveId(nutsDescriptor, session).builder().setFaceDescriptor().build();
                NutsPath localNutFile = this.cache.getLongIdLocalFile(id2, session);
                nutsDescriptor.formatter().setSession(session).print(localNutFile);
                if (bestId != null && id2.getVersion().compareTo(bestId.getVersion()) <= 0) continue;
                bestId = id2;
            }
        }
        return bestId;
    }
}

