/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import net.thevpc.nuts.NutsAlreadyDeployedException;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDefaultStreamMetadata;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsDigest;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdFilters;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsLocks;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStreamMetadata;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.event.DefaultNutsContentEvent;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultWriteTypeProcessor;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamMetadataAwareImpl;
import net.thevpc.nuts.runtime.standalone.io.util.NutsStreamOrPath;
import net.thevpc.nuts.runtime.standalone.repository.NutsIdPathIterator;
import net.thevpc.nuts.runtime.standalone.repository.NutsIdPathIteratorBase;
import net.thevpc.nuts.runtime.standalone.repository.NutsRepositoryHelper;
import net.thevpc.nuts.runtime.standalone.repository.cmd.fetch.DefaultNutsFetchContentRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.undeploy.DefaultNutsRepositoryUndeployCommand;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryExt0;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.CharacterizedExecFile;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNutsArtifactPathExecutable;
import net.thevpc.nuts.runtime.standalone.xtra.digest.NutsDigestUtils;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositorySPI;
import net.thevpc.nuts.spi.NutsRepositoryUndeployCommand;

public class NutsRepositoryFolderHelper {
    private final NutsRepository repo;
    private final NutsSession ws;
    private final NutsPath rootPath;
    private final boolean cacheFolder;
    private NutsLogger LOG;
    private boolean readEnabled = true;
    private boolean writeEnabled = true;
    private final String kind;
    private final NutsObjectElement extraInfoElements;

    public NutsRepositoryFolderHelper(NutsRepository repo, NutsSession ws, NutsPath rootPath, boolean cacheFolder, String kind, NutsObjectElement extraInfoElements) {
        this.repo = repo;
        this.kind = kind;
        this.ws = ws;
        this.extraInfoElements = extraInfoElements;
        if (ws == null && repo == null) {
            throw new IllegalArgumentException("both workspace and repository are null");
        }
        this.rootPath = rootPath;
        this.cacheFolder = cacheFolder;
    }

    public boolean isReadEnabled() {
        return this.readEnabled;
    }

    public void setReadEnabled(boolean readEnabled) {
        this.readEnabled = readEnabled;
    }

    public boolean isWriteEnabled() {
        return this.writeEnabled;
    }

    public void setWriteEnabled(boolean writeEnabled) {
        this.writeEnabled = writeEnabled;
    }

    public NutsPath getLongIdLocalFolder(NutsId id, NutsSession session) {
        NutsWorkspaceUtils.of(session).checkNutsId(id);
        if (this.repo == null) {
            return this.getStoreLocation().resolve(session.locations().setSession(session).getDefaultIdBasedir(id));
        }
        return this.getStoreLocation().resolve(NutsRepositoryExt0.of(this.repo).getIdBasedir(id, session));
    }

    public NutsPath getLongIdLocalFile(NutsId id, NutsSession session) {
        if (this.repo == null) {
            return this.getLongIdLocalFolder(id, session).resolve(session.locations().setSession(session).getDefaultIdFilename(id));
        }
        return this.getLongIdLocalFolder(id, session).resolve(NutsRepositoryExt0.of(this.repo).getIdFilename(id, session));
    }

    public NutsPath getShortIdLocalFolder(NutsId id, NutsSession session) {
        NutsWorkspaceUtils.of(session).checkShortId(id);
        if (this.repo == null) {
            return this.getStoreLocation().resolve(session.locations().getDefaultIdBasedir(id.builder().setVersion("").build()));
        }
        return this.getStoreLocation().resolve(NutsRepositoryExt0.of(this.repo).getIdBasedir(id.builder().setVersion("").build(), session));
    }

    public NutsContent fetchContentImpl(NutsId id, String localPath, NutsSession session) {
        NutsPath cacheContent = this.getLongIdLocalFile(id.builder().setFaceContent().build(), session);
        if (cacheContent != null && this.pathExists(cacheContent, session)) {
            return new NutsDefaultContent(cacheContent, this.cacheFolder, false);
        }
        return null;
    }

    public NutsWorkspace getWorkspace() {
        return this.ws.getWorkspace();
    }

    public NutsSession getSession() {
        return this.ws;
    }

    protected String getIdFilename(NutsId id, NutsSession session) {
        if (this.repo == null) {
            return session.locations().getDefaultIdFilename(id);
        }
        return NutsRepositoryExt0.of(this.repo).getIdFilename(id, session);
    }

    public NutsPath getGoodPath(NutsId id, NutsSession session) {
        String idFilename = this.getIdFilename(id, session);
        NutsPath versionFolder = this.getLongIdLocalFolder(id, session);
        return versionFolder.resolve(idFilename);
    }

    public NutsDescriptor fetchDescriptorImpl(NutsId id, NutsSession session) {
        if (!this.isReadEnabled()) {
            return null;
        }
        String idFilename = this.getIdFilename(id.builder().setFaceDescriptor().build(), session);
        NutsPath goodFile = null;
        NutsPath versionFolder = this.getLongIdLocalFolder(id, session);
        goodFile = versionFolder.resolve(idFilename);
        if (this.pathExists(goodFile, session)) {
            return NutsDescriptorParser.of((NutsSession)session).parse(goodFile);
        }
        return null;
    }

    protected NutsDescriptor loadMatchingDescriptor(NutsPath file, NutsId id, NutsSession session) {
        if (this.pathExists(file, session)) {
            NutsDescriptor d;
            NutsDescriptor nutsDescriptor = d = file.isRegularFile() ? NutsDescriptorParser.of((NutsSession)session).parse(file) : null;
            if (d != null) {
                String de;
                String platform;
                String dist;
                Map query = id.getProperties();
                String os = (String)query.get("os");
                String arch = (String)query.get("arch");
                if (CoreFilterUtils.matchesEnv(arch, os, dist = (String)query.get("osdist"), platform = (String)query.get("platform"), de = (String)query.get("desktop"), d.getCondition(), session)) {
                    return d;
                }
            }
        }
        return null;
    }

    public NutsPath getRelativeLocalGroupAndArtifactFile(NutsId id, NutsSession session) {
        NutsWorkspaceUtils.of(session).checkShortId(id);
        NutsPath groupFolder = NutsPath.of((String)id.getGroupId().replace('.', File.separatorChar), (NutsSession)session);
        return groupFolder.resolve(id.getArtifactId());
    }

    public NutsPath getLocalGroupAndArtifactFile(NutsId id, NutsSession session) {
        NutsWorkspaceUtils.of(session).checkShortId(id);
        NutsPath groupFolder = this.getStoreLocation().resolve(id.getGroupId().replace('.', File.separatorChar));
        return groupFolder.resolve(id.getArtifactId());
    }

    public NutsIterator<NutsId> searchVersions(NutsId id, NutsIdFilter filter, boolean deep, NutsSession session) {
        if (!this.isReadEnabled()) {
            return null;
        }
        if (id.getVersion().isSingleValue()) {
            return IteratorBuilder.ofSupplier(() -> {
                NutsId id1 = id.builder().setFaceDescriptor().build();
                NutsPath localFile = this.getLongIdLocalFile(id1, session);
                if (localFile != null && localFile.isRegularFile()) {
                    return Collections.singletonList(id.builder().setRepository(this.repo == null ? null : this.repo.getName()).build()).iterator();
                }
                return IteratorBuilder.emptyIterator();
            }, e -> e.ofObject().set("type", "searchSingleVersion").set("repository", this.repo == null ? null : this.repo.getName()).set("id", id.toString()).set("root", this.getStoreLocation().toString()).addAll(this.extraInfoElements).build(), session).build();
        }
        NutsIdFilter filter2 = (NutsIdFilter)NutsIdFilters.of((NutsSession)session).all(new NutsFilter[]{filter, NutsIdFilters.of((NutsSession)session).byName(new String[]{id.getShortName()})});
        return this.findInFolder(this.getRelativeLocalGroupAndArtifactFile(id, session), filter2, deep ? Integer.MAX_VALUE : 1, session);
    }

    public NutsIterator<NutsId> searchImpl(NutsIdFilter filter, NutsSession session) {
        if (!this.isReadEnabled()) {
            return null;
        }
        return this.findInFolder(null, filter, Integer.MAX_VALUE, session);
    }

    public NutsIterator<NutsId> findInFolder(NutsPath folder, NutsIdFilter filter, int maxDepth, NutsSession session) {
        if (!this.isReadEnabled()) {
            return null;
        }
        return new NutsIdPathIterator(this.repo, this.rootPath, folder, filter, session, new NutsIdPathIteratorBase(){

            @Override
            public void undeploy(NutsId id, NutsSession session) throws NutsExecutionException {
                if (NutsRepositoryFolderHelper.this.repo == null) {
                    NutsRepositoryFolderHelper.this.undeploy(((NutsRepositoryUndeployCommand)new DefaultNutsRepositoryUndeployCommand(session.getWorkspace()).setFetchMode(NutsFetchMode.LOCAL)).setId(id).setSession(session));
                } else {
                    NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(NutsRepositoryFolderHelper.this.repo);
                    repoSPI.undeploy().setId(id).setSession(session).run();
                }
            }

            @Override
            public boolean isDescFile(NutsPath pathname) {
                return pathname.getName().endsWith(".nuts");
            }

            @Override
            public NutsDescriptor parseDescriptor(NutsPath pathname, InputStream in, NutsFetchMode fetchMode, NutsRepository repository, NutsSession session, NutsPath rootURL) throws IOException {
                if (NutsRepositoryFolderHelper.this.cacheFolder && CoreIOUtils.isObsoletePath(session, pathname)) {
                    return null;
                }
                return NutsDescriptorParser.of((NutsSession)session).parse(pathname);
            }
        }, maxDepth, this.kind, this.extraInfoElements);
    }

    public NutsPath getStoreLocation() {
        return this.rootPath;
    }

    public NutsId searchLatestVersion(NutsId id, NutsIdFilter filter, NutsSession session) {
        NutsPath[] versionFolders;
        if (!this.isReadEnabled()) {
            return null;
        }
        NutsId bestId = null;
        NutsPath file = this.getLocalGroupAndArtifactFile(id, session);
        if (file.exists() && (versionFolders = (NutsPath[])file.list().filter(NutsPath::isDirectory, "idDirectory").toArray(NutsPath[]::new)) != null) {
            for (NutsPath versionFolder : versionFolders) {
                if (this.pathExists(versionFolder, session)) {
                    NutsId id2 = id.builder().setVersion(versionFolder.getName()).build();
                    if (bestId != null && id2.getVersion().compareTo(bestId.getVersion()) <= 0 || filter != null && !filter.acceptId(id2, session)) continue;
                    bestId = id2;
                    continue;
                }
                versionFolder.deleteTree();
            }
        }
        return bestId;
    }

    public NutsDescriptor deploy(NutsDeployRepositoryCommand deployment, NutsConfirmationMode writeType) {
        NutsId id;
        NutsSession session = deployment.getSession();
        if (!this.isWriteEnabled()) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"read-only repository", (Object[])new Object[0]));
        }
        if (deployment.getContent() == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid deployment; missing content for %s", (Object[])new Object[]{deployment.getId()}));
        }
        NutsDescriptor descriptor = deployment.getDescriptor();
        NutsStreamOrPath inputSource = NutsStreamOrPath.ofAnyInputOrNull(deployment.getContent(), session).toMultiRead(session).setKindType("package content");
        if (descriptor == null) {
            try (CharacterizedExecFile c = DefaultNutsArtifactPathExecutable.characterizeForExec(inputSource, session, null);){
                if (c.descriptor == null) {
                    throw new NutsNotFoundException(session, null, NutsMessage.cstyle((String)"unable to resolve a valid descriptor for %s", (Object[])new Object[]{deployment.getContent()}), null);
                }
                descriptor = c.descriptor;
            }
        }
        if ((id = deployment.getId()) == null) {
            id = descriptor.getId();
        }
        NutsWorkspaceUtils.of(session).checkNutsId(id);
        if (this.isDeployed(id, descriptor, session)) {
            NutsId finalId = id;
            if (!DefaultWriteTypeProcessor.of(writeType, session).ask("override deployment for %s?", id).withLog(this._LOG(session), "nuts deployment overridden {0}", id).onError(() -> new NutsAlreadyDeployedException(session, finalId)).process()) {
                return descriptor;
            }
        }
        switch (writeType) {
            case ERROR: 
            case ASK: {
                writeType = NutsConfirmationMode.NO;
            }
        }
        this.deployDescriptor(id, descriptor, writeType, session);
        NutsPath pckFile = this.deployContent(id, inputSource, descriptor, writeType, session);
        if (this.repo != null) {
            NutsRepositoryHelper.of(this.repo).events().fireOnDeploy(new DefaultNutsContentEvent(pckFile, (NutsRepositoryCommand)deployment, session, this.repo));
        }
        return descriptor.builder().setId(id.getLongId()).build();
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsFetchContentRepositoryCommand.class, (NutsSession)session);
        }
        return this.LOG;
    }

    public NutsPath deployDescriptor(NutsId id, NutsDescriptor desc, NutsConfirmationMode writeType, NutsSession session) {
        if (!this.isWriteEnabled()) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"read only repository", (Object[])new Object[0]));
        }
        NutsWorkspaceUtils.of(session).checkNutsId(id);
        NutsPath descFile = this.getLongIdLocalFile(id.builder().setFaceDescriptor().build(), session);
        if (descFile.exists() && !DefaultWriteTypeProcessor.of(writeType, session).ask("override descriptor file for %s?", id).withLog(this._LOG(session), "nuts descriptor file overridden {0}", id).onError(() -> new NutsAlreadyDeployedException(session, id)).process()) {
            return descFile;
        }
        return (NutsPath)NutsLocks.of((NutsSession)session).setSource((Object)descFile).call(() -> {
            desc.formatter().setSession(session).setNtf(false).print(descFile);
            byte[] bytes = NutsDigest.of((NutsSession)session).sha1().setSource(desc).computeString().getBytes();
            NutsCp.of((NutsSession)session).from((InputStream)InputStreamMetadataAwareImpl.of(new ByteArrayInputStream(bytes), (NutsStreamMetadata)new NutsDefaultStreamMetadata(NutsMessage.cstyle((String)"sha1://%s", (Object[])new Object[]{desc.getId()}), (long)bytes.length, "text/sha-1", "descriptor hash", session))).to(descFile.resolveSibling(descFile.getName() + ".sha1")).addOptions(new NutsPathOption[]{NutsPathOption.SAFE}).run();
            return descFile;
        });
    }

    public boolean isDeployed(NutsId id, NutsDescriptor descriptor, NutsSession session) {
        NutsPath pckFile = this.getLongIdLocalFile(id.builder().setFaceContent().setPackaging(descriptor.getPackaging()).build(), session);
        if (!pckFile.exists() || this.cacheFolder && CoreIOUtils.isObsoletePath(session, pckFile)) {
            return false;
        }
        NutsPath descFile = this.getLongIdLocalFile(id.builder().setFaceDescriptor().build(), session);
        return descFile.exists() && (!this.cacheFolder || !CoreIOUtils.isObsoletePath(session, descFile));
    }

    public NutsPath deployContent(NutsId id, NutsStreamOrPath content, NutsDescriptor descriptor, NutsConfirmationMode writeType, NutsSession session) {
        if (!this.isWriteEnabled()) {
            return null;
        }
        NutsWorkspaceUtils.of(session).checkNutsId(id);
        NutsPath pckFile = this.getLongIdLocalFile(id.builder().setFaceContent().setPackaging(descriptor.getPackaging()).build(), session);
        if (pckFile.exists() && !DefaultWriteTypeProcessor.of(writeType, session).ask("override content file for %s?", id).withLog(this._LOG(session), "nuts content file overridden {0}", id).onError(() -> new NutsAlreadyDeployedException(session, id)).process()) {
            return pckFile;
        }
        return (NutsPath)NutsLocks.of((NutsSession)session).setSource((Object)pckFile).call(() -> {
            (content.isPath() ? NutsCp.of((NutsSession)session).from(content.getPath()) : NutsCp.of((NutsSession)session).from(content.getInputStream())).to(pckFile).addOptions(new NutsPathOption[]{NutsPathOption.SAFE}).run();
            NutsCp.of((NutsSession)session).from(CoreIOUtils.createBytesStream(NutsDigestUtils.evalSHA1Hex(pckFile, session).getBytes(), NutsMessage.cstyle((String)"sha1://%s", (Object[])new Object[]{id}), "text/sha-1", null, session)).to(pckFile.resolveSibling(pckFile.getName() + ".sha1")).addOptions(new NutsPathOption[]{NutsPathOption.SAFE}).run();
            return pckFile;
        });
    }

    public boolean undeploy(NutsRepositoryUndeployCommand command) {
        if (!this.isWriteEnabled()) {
            return false;
        }
        NutsPath localFolder = this.getLongIdLocalFile(command.getId().builder().setFaceContent().build(), command.getSession());
        if (localFolder != null && localFolder.exists() && ((Boolean)NutsLocks.of((NutsSession)command.getSession()).setSource((Object)localFolder).call(() -> {
            localFolder.deleteTree();
            return false;
        })).booleanValue() && this.repo != null) {
            NutsRepositoryHelper.of(this.repo).events().fireOnUndeploy(new DefaultNutsContentEvent(localFolder, (NutsRepositoryCommand)command, command.getSession(), this.repo));
            return true;
        }
        return true;
    }

    public void reindexFolder(NutsSession session) {
        this.reindexFolder(this.getStoreLocation(), session);
    }

    private boolean reindexFolder(NutsPath path, final NutsSession session) {
        if (!this.isWriteEnabled()) {
            return false;
        }
        try {
            Files.walkFileTree(path.toFile(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    File folder = dir.toFile();
                    File[] children = folder.listFiles();
                    TreeSet<String> files = new TreeSet<String>();
                    TreeSet<String> folders = new TreeSet<String>();
                    if (children != null) {
                        for (File child : children) {
                            if (child.getName().startsWith(".")) continue;
                            if (child.isDirectory()) {
                                folders.add(child.getName());
                                continue;
                            }
                            if (!child.isFile()) continue;
                            files.add(child.getName());
                        }
                    }
                    try (PrintStream p = new PrintStream(new File(folder, ".files"));){
                        p.println("#version=" + NutsRepositoryFolderHelper.this.ws.getWorkspace().getApiVersion());
                        for (String file : folders) {
                            p.println(file + "/");
                        }
                        for (String file : files) {
                            p.println(file);
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new NutsIOException(session, (Throwable)e);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
        return true;
    }

    private boolean pathExists(NutsPath p, NutsSession session) {
        return p.exists() && (!this.cacheFolder || !CoreIOUtils.isObsoletePath(session, p));
    }
}

