/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchModeNotSupportedException;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsLocks;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSpeedQualifier;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.cmd.updatestats.AbstractNutsUpdateRepositoryStatisticsCommand;
import net.thevpc.nuts.runtime.standalone.repository.impl.AbstractNutsRepositoryBase;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryMirroringHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.util.CommonRootsByIdHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.util.CommonRootsByPathHelper;
import net.thevpc.nuts.runtime.standalone.util.SuccessFailResult;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.xtra.glob.GlobUtils;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;
import net.thevpc.nuts.spi.NutsPushRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositoryUndeployCommand;
import net.thevpc.nuts.spi.NutsUpdateRepositoryStatisticsCommand;

public class NutsCachedRepository
extends AbstractNutsRepositoryBase {
    protected final NutsRepositoryFolderHelper lib;
    protected final NutsRepositoryFolderHelper cache;
    private final NutsRepositoryMirroringHelper mirroring;
    public NutsLogger LOG;

    public NutsCachedRepository(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parent, NutsSpeedQualifier speed, boolean supportedMirroring, String repositoryType) {
        super(options, session, parent, speed, supportedMirroring, repositoryType);
        this.cache = new NutsRepositoryFolderHelper(this, session, this.config().setSession(session).getStoreLocation(NutsStoreLocation.CACHE), true, "cache", NutsElements.of((NutsSession)session).ofObject().set("repoKind", "cache").build());
        this.lib = new NutsRepositoryFolderHelper(this, session, this.config().setSession(session).getStoreLocation(NutsStoreLocation.LIB), false, "lib", NutsElements.of((NutsSession)session).ofObject().set("repoKind", "lib").build());
        this.mirroring = new NutsRepositoryMirroringHelper(this, this.cache);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(NutsCachedRepository.class, (NutsSession)session);
        }
        return this.LOG;
    }

    @Override
    public void pushImpl(NutsPushRepositoryCommand command) {
        this.mirroring.push(command);
    }

    @Override
    public NutsDescriptor deployImpl(NutsDeployRepositoryCommand command) {
        return this.lib.deploy(command, command.getSession().getConfirm());
    }

    @Override
    public final void undeployImpl(NutsRepositoryUndeployCommand options) {
        this.lib.undeploy(options);
    }

    @Override
    public NutsDescriptor fetchDescriptorImpl(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            NutsDescriptor cacheDesc;
            NutsDescriptor libDesc = this.lib.fetchDescriptorImpl(id, session);
            if (libDesc != null) {
                return libDesc;
            }
            if (this.cache.isReadEnabled() && (cacheDesc = this.cache.fetchDescriptorImpl(id, session)) != null) {
                return cacheDesc;
            }
        }
        RuntimeException mirrorsEx = null;
        SuccessFailResult res = (SuccessFailResult)NutsLocks.of((NutsSession)session).setSource((Object)id.builder().setFaceDescriptor().build()).call(() -> {
            try {
                NutsDescriptor success = this.fetchDescriptorCore(id, fetchMode, session);
                if (success != null) {
                    if (this.cache.isWriteEnabled()) {
                        NutsId id0 = NutsWorkspaceExt.of(this.getWorkspace()).resolveEffectiveId(success, session);
                        if (!id0.getLongName().equals(success.getId().getLongName())) {
                            success = success.builder().setId(id0).build();
                        }
                        this.cache.deployDescriptor(success.getId(), success, NutsConfirmationMode.YES, session.copy().setConfirm(NutsConfirmationMode.YES));
                    }
                    return SuccessFailResult.success(success);
                }
                return SuccessFailResult.fail(new NutsNotFoundException(session, id));
            }
            catch (RuntimeException ex) {
                return SuccessFailResult.fail(ex);
            }
        });
        if (res.getSuccess() != null) {
            return (NutsDescriptor)res.getSuccess();
        }
        NutsDescriptor m = null;
        try {
            m = this.mirroring.fetchDescriptorImplInMirrors(id, fetchMode, session);
        }
        catch (RuntimeException ex) {
            mirrorsEx = ex;
        }
        if (m != null) {
            return m;
        }
        if (res.getFail() != null) {
            throw (RuntimeException)res.getFail();
        }
        if (mirrorsEx != null) {
            throw mirrorsEx;
        }
        return m;
    }

    @Override
    public final NutsIterator<NutsId> searchVersionsImpl(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        ArrayList all = new ArrayList();
        if (fetchMode != NutsFetchMode.REMOTE) {
            all.add(IteratorBuilder.of(this.lib.searchVersions(id, idFilter, true, session), session).named("searchVersionInLib(" + this.getName() + ")").build());
        }
        if (fetchMode != NutsFetchMode.REMOTE) {
            try {
                if (this.cache.isReadEnabled()) {
                    all.add(IteratorBuilder.of(this.cache.searchVersions(id, idFilter, true, session), session).named("searchVersionInCache(" + this.getName() + ")").build());
                }
            }
            catch (NutsNotFoundException nutsNotFoundException) {
                // empty catch block
            }
        }
        try {
            NutsIterator<NutsId> p = null;
            p = this.searchVersionsCore(id, idFilter, fetchMode, session);
            if (p != null) {
                all.add(IteratorBuilder.of(p, session).named("searchVersionInCore(" + this.getName() + ")").build());
            }
        }
        catch (NutsNotFoundException p) {
        }
        catch (Exception ex) {
            this._LOGOP(session).level(Level.SEVERE).error((Throwable)ex).log(NutsMessage.jstyle((String)"search versions error : {0}", (Object[])new Object[]{ex}));
        }
        Object namedNutIdIterator = IteratorBuilder.ofConcat(all, session).distinct(NutsFunction.of(NutsId::getLongName, (String)"getLongName")).build();
        if (namedNutIdIterator == null) {
            namedNutIdIterator = IteratorBuilder.emptyIterator();
        }
        return IteratorBuilder.of(this.mirroring.searchVersionsImpl_appendMirrors((NutsIterator<NutsId>)namedNutIdIterator, id, idFilter, fetchMode, session), session).named("searchVersion(" + this.getName() + ")").build();
    }

    @Override
    public final NutsContent fetchContentImpl(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsSession session) {
        NutsContent c;
        if (fetchMode != NutsFetchMode.REMOTE && (c = this.lib.fetchContentImpl(id, localPath, session)) != null) {
            return c;
        }
        if (this.cache.isReadEnabled() && session.isCached() && (c = this.cache.fetchContentImpl(id, localPath, session)) != null) {
            return c;
        }
        RuntimeException mirrorsEx = null;
        NutsContent c2 = null;
        SuccessFailResult res = (SuccessFailResult)NutsLocks.of((NutsSession)session).setSource((Object)id.builder().setFaceContent().build()).call(() -> {
            if (this.cache.isWriteEnabled()) {
                NutsPath cachePath = this.cache.getLongIdLocalFile(id, session);
                NutsContent c2 = this.fetchContentCore(id, descriptor, cachePath.toString(), fetchMode, session);
                if (c2 != null) {
                    String localPath2 = localPath;
                    if (localPath2 != null) {
                        NutsCp.of((NutsSession)session).from(cachePath).to(localPath2).run();
                    } else {
                        localPath2 = cachePath.toString();
                    }
                    return SuccessFailResult.success(new NutsDefaultContent(NutsPath.of((String)localPath2, (NutsSession)session), true, false));
                }
                return SuccessFailResult.fail(new NutsNotFoundException(session, id));
            }
            NutsContent c2 = null;
            RuntimeException impl2Ex = null;
            try {
                c2 = this.fetchContentCore(id, descriptor, localPath, fetchMode, session);
            }
            catch (RuntimeException ex) {
                impl2Ex = ex;
            }
            if (c2 != null) {
                return SuccessFailResult.success(c2);
            }
            if (impl2Ex != null) {
                return SuccessFailResult.fail(impl2Ex);
            }
            return SuccessFailResult.fail(new NutsNotFoundException(session, id));
        });
        if (res.getSuccess() != null) {
            return (NutsContent)res.getSuccess();
        }
        try {
            c2 = this.mirroring.fetchContent(id, descriptor, localPath, fetchMode, session);
        }
        catch (RuntimeException ex) {
            mirrorsEx = ex;
        }
        if (c2 != null) {
            return c2;
        }
        if (res.getFail() != null) {
            if (res.getFail() instanceof NutsNotFoundException) {
                throw (RuntimeException)res.getFail();
            }
            throw new NutsNotFoundException(session, id, res.getFail());
        }
        if (mirrorsEx != null) {
            if (mirrorsEx instanceof NutsNotFoundException) {
                throw mirrorsEx;
            }
            throw new NutsNotFoundException(session, id, (Throwable)mirrorsEx);
        }
        throw new NutsNotFoundException(session, id);
    }

    @Override
    public final NutsIterator<NutsId> searchImpl(NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        List<NutsPath> basePaths = CommonRootsByPathHelper.resolveRootPaths(filter, session);
        List<NutsId> baseIds = CommonRootsByIdHelper.resolveRootPaths(filter, session);
        ArrayList li = new ArrayList();
        for (NutsPath basePath : basePaths) {
            if (fetchMode != NutsFetchMode.REMOTE) {
                if (basePath.getName().equals("*")) {
                    li.add(this.lib.findInFolder(basePath.getParent(), filter, Integer.MAX_VALUE, session));
                } else {
                    li.add(this.lib.findInFolder(basePath, filter, 2, session));
                }
            }
            if (!this.cache.isReadEnabled() || !session.isCached()) continue;
            if (basePath.getName().equals("*")) {
                li.add(this.cache.findInFolder(basePath.getParent(), filter, Integer.MAX_VALUE, session));
                continue;
            }
            li.add(this.cache.findInFolder(basePath, filter, 2, session));
        }
        NutsIterator<NutsId> p = null;
        try {
            p = this.searchCore(filter, basePaths.toArray(new NutsPath[0]), baseIds.toArray(new NutsId[0]), fetchMode, session);
        }
        catch (NutsNotFoundException basePath) {
        }
        catch (Exception ex) {
            this._LOGOP(session).level(Level.SEVERE).error((Throwable)ex).log(NutsMessage.jstyle((String)"search latest versions error : {0}", (Object[])new Object[]{ex}));
        }
        if (p != null) {
            li.add(p);
        }
        return this.mirroring.search(IteratorBuilder.ofConcat(li, session).distinct(NutsFunction.of(NutsId::getLongName, (String)"getLongName")).build(), filter, fetchMode, session);
    }

    protected boolean isAllowedOverrideNut(NutsId id) {
        return true;
    }

    public NutsIterator<NutsId> searchVersionsCore(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        return null;
    }

    public NutsId searchLatestVersionCore(NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        return null;
    }

    public NutsDescriptor fetchDescriptorCore(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        return null;
    }

    public NutsContent fetchContentCore(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsSession session) {
        return null;
    }

    public NutsIterator<NutsId> searchCore(NutsIdFilter filter, NutsPath[] basePaths, NutsId[] baseIds, NutsFetchMode fetchMode, NutsSession session) {
        return null;
    }

    public void updateStatistics2(NutsSession session) {
    }

    @Override
    public boolean acceptAction(NutsId id, NutsRepositorySupportedAction supportedAction, NutsFetchMode mode, NutsSession session) {
        String groups = this.config().setSession(session).getGroups();
        if (NutsBlankable.isBlank((String)groups)) {
            return true;
        }
        return GlobUtils.ofExact(groups).matcher(id.getGroupId()).matches();
    }

    @Override
    public final NutsId searchLatestVersion(NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        if (id.getVersion().isBlank() && filter == null) {
            NutsId bestId = this.lib.searchLatestVersion(id, filter, session);
            NutsId c1 = null;
            if (this.cache.isReadEnabled()) {
                c1 = this.cache.searchLatestVersion(id, filter, session);
                if (bestId == null || c1 != null && c1.getVersion().compareTo(bestId.getVersion()) > 0) {
                    bestId = c1;
                }
            }
            try {
                c1 = this.searchLatestVersionCore(id, filter, fetchMode, session);
                if (bestId == null || c1 != null && c1.getVersion().compareTo(bestId.getVersion()) > 0) {
                    bestId = c1;
                }
            }
            catch (NutsFetchModeNotSupportedException | NutsNotFoundException throwable) {
            }
            catch (Exception ex) {
                this._LOGOP(session).level(Level.SEVERE).error((Throwable)ex).log(NutsMessage.jstyle((String)"search latest versions error : {0}", (Object[])new Object[]{ex}));
            }
            return this.mirroring.searchLatestVersion(bestId, id, filter, fetchMode, session);
        }
        return super.searchLatestVersion(id, filter, fetchMode, session);
    }

    @Override
    public final NutsUpdateRepositoryStatisticsCommand updateStatistics() {
        return new AbstractNutsUpdateRepositoryStatisticsCommand(this){

            @Override
            public NutsUpdateRepositoryStatisticsCommand run() {
                NutsCachedRepository.this.lib.reindexFolder(this.getSession());
                if (NutsCachedRepository.this.cache.isWriteEnabled()) {
                    NutsCachedRepository.this.cache.reindexFolder(this.getSession());
                }
                NutsCachedRepository.this.updateStatistics2(this.getSession());
                return this;
            }
        };
    }

    public boolean isAcceptFetchMode(NutsFetchMode mode, NutsSession session) {
        return true;
    }

    public boolean isRemote() {
        return true;
    }
}

