/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl;

import java.util.LinkedHashMap;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIndexStore;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSpeedQualifier;
import net.thevpc.nuts.runtime.standalone.log.NutsLogUtils;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.cmd.deploy.DefaultNutsDeployRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.fetch.DefaultNutsFetchContentRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.fetch.DefaultNutsFetchDescriptorRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.push.DefaultNutsPushRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.search.DefaultNutsSearchRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.search.DefaultNutsSearchVersionsRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.undeploy.DefaultNutsRepositoryUndeployCommand;
import net.thevpc.nuts.runtime.standalone.repository.cmd.updatestats.AbstractNutsUpdateRepositoryStatisticsCommand;
import net.thevpc.nuts.runtime.standalone.repository.config.DefaultNutsRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.repository.impl.AbstractNutsRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.xtra.glob.GlobUtils;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;
import net.thevpc.nuts.spi.NutsFetchContentRepositoryCommand;
import net.thevpc.nuts.spi.NutsFetchDescriptorRepositoryCommand;
import net.thevpc.nuts.spi.NutsPushRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import net.thevpc.nuts.spi.NutsRepositoryUndeployCommand;
import net.thevpc.nuts.spi.NutsSearchRepositoryCommand;
import net.thevpc.nuts.spi.NutsSearchVersionsRepositoryCommand;
import net.thevpc.nuts.spi.NutsUpdateRepositoryStatisticsCommand;

public abstract class AbstractNutsRepositoryBase
extends AbstractNutsRepository
implements NutsRepositoryExt {
    private static final long serialVersionUID = 1L;
    protected NutsIndexStore nutsIndexStore;
    private final NutsLogger LOG;

    public AbstractNutsRepositoryBase(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository, NutsSpeedQualifier speed, boolean supportedMirroring, String repositoryType) {
        this.initSession = session;
        this.LOG = NutsLogger.of(AbstractNutsRepositoryBase.class, (NutsSession)session);
        this.init(options, session, parentRepository, speed, supportedMirroring, repositoryType);
    }

    @Override
    public NutsIndexStore getIndexStore() {
        return this.nutsIndexStore;
    }

    protected void init(NutsAddRepositoryOptions options, NutsSession initSession, NutsRepository parent, NutsSpeedQualifier speed, boolean supportedMirroring, String repositoryType) {
        this.workspace = initSession.getWorkspace();
        this.parentRepository = parent;
        this.configModel = new DefaultNutsRepositoryConfigModel(this, options, initSession, speed, supportedMirroring, repositoryType);
        this.nutsIndexStore = initSession.config().getIndexStoreClientFactory().createIndexStore((NutsRepository)this);
        this.setEnabled(options.isEnabled());
    }

    @Override
    public boolean acceptAction(NutsId id, NutsRepositorySupportedAction supportedAction, NutsFetchMode mode, NutsSession session) {
        String groups = this.config().getGroups();
        if (NutsBlankable.isBlank((String)groups)) {
            return true;
        }
        return GlobUtils.ofExact(groups).matcher(id.getGroupId()).matches();
    }

    @Override
    public String toString() {
        NutsRepositoryConfigManagerExt c = NutsRepositoryConfigManagerExt.of(this.config());
        String name = this.getName();
        String storePath = null;
        NutsRepositoryLocation loc = c.getModel().getLocation();
        String impl = this.getClass().getSimpleName();
        if (c != null) {
            storePath = c.getModel().getStoreLocation().toAbsolute().toString();
        }
        LinkedHashMap<String, String> a = new LinkedHashMap<String, String>();
        if (name != null) {
            a.put("name", name);
        }
        a.put("impl", impl);
        if (storePath != null) {
            a.put("store", storePath);
        }
        if (loc != null) {
            a.put("location", loc.toString());
        }
        return a.toString();
    }

    @Override
    public void checkAllowedFetch(NutsId id, NutsSession session) {
    }

    public NutsFetchDescriptorRepositoryCommand fetchDescriptor() {
        return new DefaultNutsFetchDescriptorRepositoryCommand(this);
    }

    @Override
    public NutsId searchLatestVersion(NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        NutsIterator allVersions = this.searchVersions().setSession(session).setId(id).setFilter(filter).setFetchMode(fetchMode).getResult();
        NutsId a = null;
        while (allVersions.hasNext()) {
            NutsId next = (NutsId)allVersions.next();
            if (a != null && next.getVersion().compareTo(a.getVersion()) <= 0) continue;
            a = next;
        }
        return a;
    }

    protected void traceMessage(NutsSession session, NutsFetchMode fetchMode, Level lvl, NutsId id, NutsLogVerb tracePhase, String title, long startTime, NutsMessage extraMessage) {
        NutsLogUtils.traceMessage(this.LOG, lvl, this.getName(), session, fetchMode, id, tracePhase, title, startTime, extraMessage);
    }

    public NutsDeployRepositoryCommand deploy() {
        return new DefaultNutsDeployRepositoryCommand(this);
    }

    public NutsPushRepositoryCommand push() {
        return new DefaultNutsPushRepositoryCommand(this);
    }

    public NutsSearchRepositoryCommand search() {
        return new DefaultNutsSearchRepositoryCommand(this);
    }

    public NutsFetchContentRepositoryCommand fetchContent() {
        return new DefaultNutsFetchContentRepositoryCommand(this);
    }

    public NutsSearchVersionsRepositoryCommand searchVersions() {
        return new DefaultNutsSearchVersionsRepositoryCommand(this);
    }

    public NutsRepositoryUndeployCommand undeploy() {
        return new DefaultNutsRepositoryUndeployCommand(this);
    }

    protected String getIdComponentExtension(String packaging, NutsSession session) {
        return session.locations().getDefaultIdContentExtension(packaging);
    }

    @Override
    protected String getIdExtension(NutsId id, NutsSession session) {
        return session.locations().getDefaultIdExtension(id);
    }

    @Override
    public NutsPath getIdBasedir(NutsId id, NutsSession session) {
        return session.locations().setSession(session).getDefaultIdBasedir(id);
    }

    protected NutsPath getIdRemotePath(NutsId id, NutsSession session) {
        return this.config().setSession(session).getLocationPath().resolve(this.getIdRelativePath(id, session));
    }

    protected NutsPath getIdRelativePath(NutsId id, NutsSession session) {
        return this.getIdBasedir(id, session).resolve(this.getIdFilename(id, session));
    }

    public NutsUpdateRepositoryStatisticsCommand updateStatistics() {
        return new AbstractNutsUpdateRepositoryStatisticsCommand(this){

            @Override
            public NutsUpdateRepositoryStatisticsCommand run() {
                return this;
            }
        };
    }
}

