/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMapListener;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfigManager;
import net.thevpc.nuts.NutsRepositoryListener;
import net.thevpc.nuts.NutsRepositorySecurityManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.repository.config.DefaultNutsRepoConfigManager;
import net.thevpc.nuts.runtime.standalone.repository.config.NutsRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.security.DefaultNutsRepositorySecurityManager;
import net.thevpc.nuts.runtime.standalone.security.DefaultNutsRepositorySecurityModel;
import net.thevpc.nuts.runtime.standalone.util.NutsCachedValue;
import net.thevpc.nuts.runtime.standalone.util.collections.DefaultObservableMap;
import net.thevpc.nuts.runtime.standalone.util.collections.ObservableMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public abstract class AbstractNutsRepository
implements NutsRepository,
NutsRepositorySPI {
    private static final long serialVersionUID = 1L;
    private final List<NutsRepositoryListener> repositoryListeners = new ArrayList<NutsRepositoryListener>();
    protected Map<String, String> extensions = new HashMap<String, String>();
    protected NutsRepository parentRepository;
    protected NutsWorkspace workspace;
    protected DefaultNutsRepositorySecurityModel securityModel;
    protected NutsRepositoryConfigModel configModel;
    protected ObservableMap<String, Object> userProperties;
    protected boolean enabled = true;
    protected NutsSession initSession;
    protected NutsCachedValue<Boolean> available = new NutsCachedValue<Boolean>(this::isAvailableImpl, 0L);
    protected NutsCachedValue<Boolean> supportedDeploy = new NutsCachedValue<Boolean>(this::isSupportedDeployImpl, 0L);

    public AbstractNutsRepository() {
        this.userProperties = new DefaultObservableMap<String, Object>();
        this.securityModel = new DefaultNutsRepositorySecurityModel(this);
    }

    public boolean isAvailable(NutsSession session) {
        return this.isAvailable(false, session);
    }

    public boolean isAvailable(boolean force, NutsSession session) {
        if (force) {
            return this.available.update(session);
        }
        return this.available.getValue(session);
    }

    public boolean isSupportedDeploy(NutsSession session) {
        return this.isSupportedDeploy(false, session);
    }

    public boolean isSupportedDeploy(boolean force, NutsSession session) {
        if (force) {
            return this.supportedDeploy.update(session);
        }
        return this.supportedDeploy.getValue(session);
    }

    protected boolean isSupportedDeployImpl(NutsSession session) {
        return true;
    }

    protected boolean isAvailableImpl(NutsSession session) {
        return true;
    }

    public String getRepositoryType() {
        return this.config().getType();
    }

    public String getUuid() {
        return this.configModel.getUuid();
    }

    public String getName() {
        return this.configModel.getName();
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public NutsRepository getParentRepository() {
        return this.parentRepository;
    }

    public NutsRepositoryConfigManager config() {
        return new DefaultNutsRepoConfigManager(this.configModel);
    }

    public NutsRepositorySecurityManager security() {
        return new DefaultNutsRepositorySecurityManager(this.securityModel);
    }

    public NutsRepository removeRepositoryListener(NutsRepositoryListener listener) {
        this.repositoryListeners.add(listener);
        return this;
    }

    public NutsRepository addRepositoryListener(NutsRepositoryListener listener) {
        if (listener != null) {
            this.repositoryListeners.add(listener);
        }
        return this;
    }

    public NutsRepositoryListener[] getRepositoryListeners() {
        return this.repositoryListeners.toArray(new NutsRepositoryListener[0]);
    }

    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    public NutsRepository addUserPropertyListener(NutsMapListener<String, Object> listener) {
        this.userProperties.addListener(listener);
        return this;
    }

    public NutsRepository removeUserPropertyListener(NutsMapListener<String, Object> listener) {
        this.userProperties.removeListener(listener);
        return this;
    }

    public NutsMapListener<String, Object>[] getUserPropertyListeners() {
        return this.userProperties.getListeners();
    }

    public boolean isEnabled() {
        return this.enabled && this.config().isEnabled();
    }

    public NutsRepository setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String toString() {
        NutsRepositoryConfigManagerExt cc = NutsRepositoryConfigManagerExt.of(this.config());
        NutsRepositoryConfigManager c = this.config();
        String name = this.getName();
        String storePath = null;
        NutsRepositoryLocation loc = cc.getModel().getLocation();
        String impl = this.getClass().getSimpleName();
        if (c != null) {
            NutsPath storeLocation = cc.getModel().getStoreLocation();
            storePath = storeLocation == null ? null : storeLocation.toAbsolute().toString();
        }
        LinkedHashMap<String, String> a = new LinkedHashMap<String, String>();
        if (name != null) {
            a.put("name", name);
        }
        if (impl != null) {
            a.put("impl", impl);
        }
        if (storePath != null) {
            a.put("store", storePath);
        }
        if (loc != null) {
            a.put("location", loc.toString());
        }
        return a.toString();
    }

    protected String getIdExtension(NutsId id, NutsSession session) {
        return session.locations().getDefaultIdExtension(id);
    }

    public NutsPath getIdBasedir(NutsId id, NutsSession session) {
        return session.locations().getDefaultIdBasedir(id);
    }

    public String getIdFilename(NutsId id, NutsSession session) {
        String c;
        String classifier = "";
        String ext = this.getIdExtension(id, session);
        if (!(ext.equals(".nuts") || ext.equals(".pom") || NutsBlankable.isBlank((String)(c = id.getClassifier())))) {
            classifier = "-" + c;
        }
        return id.getArtifactId() + "-" + id.getVersion().getValue() + classifier + ext;
    }
}

