/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.filter;

import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsRepositoryFilters;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.repository.filter.DefaultNutsRepositoryFilter;
import net.thevpc.nuts.runtime.standalone.repository.filter.NutsRepositoryFilterAnd;
import net.thevpc.nuts.runtime.standalone.repository.filter.NutsRepositoryFilterFalse;
import net.thevpc.nuts.runtime.standalone.repository.filter.NutsRepositoryFilterNone;
import net.thevpc.nuts.runtime.standalone.repository.filter.NutsRepositoryFilterOr;
import net.thevpc.nuts.runtime.standalone.repository.filter.NutsRepositoryFilterParser;
import net.thevpc.nuts.runtime.standalone.repository.filter.NutsRepositoryFilterTrue;
import net.thevpc.nuts.runtime.standalone.util.filters.InternalNutsTypedFilters;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class InternalNutsRepositoryFilters
extends InternalNutsTypedFilters<NutsRepositoryFilter>
implements NutsRepositoryFilters {
    public InternalNutsRepositoryFilters(NutsSession session) {
        super(session, NutsRepositoryFilter.class);
    }

    public NutsRepositoryFilter always() {
        this.checkSession();
        return new NutsRepositoryFilterTrue(this.getSession());
    }

    public NutsRepositoryFilter never() {
        this.checkSession();
        return new NutsRepositoryFilterFalse(this.getSession());
    }

    public NutsRepositoryFilter not(NutsFilter other) {
        this.checkSession();
        return new NutsRepositoryFilterNone(this.getSession(), (NutsRepositoryFilter)other);
    }

    public NutsRepositoryFilter installedRepo() {
        this.checkSession();
        return new DefaultNutsRepositoryFilter(this.getSession(), Arrays.asList("<main>"));
    }

    public NutsRepositoryFilter byName(String[] names) {
        this.checkSession();
        if (names == null || names.length == 0) {
            return this.always();
        }
        return new DefaultNutsRepositoryFilter(this.getSession(), Arrays.asList(names));
    }

    public NutsRepositoryFilter byUuid(String ... uuids) {
        this.checkSession();
        if (uuids == null || uuids.length == 0) {
            return this.always();
        }
        return new DefaultNutsRepositoryFilter(this.getSession(), Arrays.asList(uuids));
    }

    public NutsRepositoryFilter as(NutsFilter a) {
        if (a instanceof NutsRepositoryFilter) {
            return (NutsRepositoryFilter)a;
        }
        return null;
    }

    public NutsRepositoryFilter from(NutsFilter a) {
        this.checkSession();
        if (a == null) {
            return null;
        }
        NutsRepositoryFilter t = this.as(a);
        if (t == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"not a RepositoryFilter", (Object[])new Object[0]));
        }
        return t;
    }

    public NutsRepositoryFilter all(NutsFilter ... others) {
        this.checkSession();
        List<NutsRepositoryFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsRepositoryFilter)all.get(0);
        }
        return new NutsRepositoryFilterAnd(this.getSession(), all.toArray(new NutsRepositoryFilter[0]));
    }

    public NutsRepositoryFilter any(NutsFilter ... others) {
        this.checkSession();
        List<NutsRepositoryFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsRepositoryFilter)all.get(0);
        }
        return new NutsRepositoryFilterOr(this.getSession(), all.toArray(new NutsRepositoryFilter[0]));
    }

    public NutsRepositoryFilter none(NutsFilter ... others) {
        this.checkSession();
        List<NutsRepositoryFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NutsRepositoryFilterNone(this.getSession(), all.toArray(new NutsRepositoryFilter[0]));
    }

    public NutsRepositoryFilter parse(String expression) {
        this.checkSession();
        return (NutsRepositoryFilter)new NutsRepositoryFilterParser(expression, this.getSession()).parse();
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

