/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.repository.filter.AbstractRepositoryFilter;
import net.thevpc.nuts.runtime.standalone.xtra.glob.GlobUtils;
import net.thevpc.nuts.spi.NutsRepositoryDB;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import net.thevpc.nuts.spi.NutsRepositorySelectorList;

public class DefaultNutsRepositoryFilter
extends AbstractRepositoryFilter {
    private final Set<String> exactRepos = new HashSet<String>();
    private final Set<Pattern> wildcardRepos = new HashSet<Pattern>();

    public DefaultNutsRepositoryFilter(NutsSession session, Collection<String> exactRepos) {
        super(session, NutsFilterOp.CUSTOM);
        String[] names;
        NutsRepositorySelectorList li = new NutsRepositorySelectorList();
        NutsRepositoryDB db = NutsRepositoryDB.of((NutsSession)session);
        for (String exactRepo : exactRepos) {
            li = li.merge(NutsRepositorySelectorList.of((String)exactRepo, (NutsRepositoryDB)db, (NutsSession)session));
        }
        NutsRepositoryLocation[] input = (NutsRepositoryLocation[])Arrays.stream(session.repos().getRepositories()).map(x -> x.config().getLocation().setName(x.getName())).toArray(NutsRepositoryLocation[]::new);
        for (String repo : names = (String[])Arrays.stream(li.resolve(input, db)).map(NutsRepositoryLocation::getName).toArray(String[]::new)) {
            if (NutsBlankable.isBlank((String)repo)) continue;
            if (repo.indexOf(42) > 0) {
                this.wildcardRepos.add(GlobUtils.ofExact(repo));
                continue;
            }
            if (repo.length() > 2 && repo.startsWith("/") && repo.endsWith("/")) {
                this.wildcardRepos.add(Pattern.compile(repo.substring(1, repo.length() - 1)));
                continue;
            }
            this.exactRepos.add(repo);
        }
    }

    public boolean acceptRepository(NutsRepository repository) {
        if (this.exactRepos.isEmpty() && this.wildcardRepos.isEmpty()) {
            return true;
        }
        if (this.exactRepos.contains(repository.getUuid()) || this.exactRepos.contains(repository.getName())) {
            return true;
        }
        for (Pattern wildcardRepo : this.wildcardRepos) {
            if (!wildcardRepo.matcher(repository.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public NutsRepositoryFilter simplify() {
        if (this.exactRepos.isEmpty() && this.wildcardRepos.isEmpty()) {
            return (NutsRepositoryFilter)this.getSession().repos().filter().always();
        }
        return this;
    }

    public String toString() {
        return "DefaultNutsRepositoryFilter{repos=" + this.exactRepos + " ; " + this.wildcardRepos + '}';
    }

    public int hashCode() {
        int hash = this.getClass().getName().hashCode();
        hash = 41 * hash + Objects.hashCode(this.exactRepos);
        hash = 41 * hash + Objects.hashCode(this.wildcardRepos);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNutsRepositoryFilter other = (DefaultNutsRepositoryFilter)obj;
        if (!Objects.equals(this.exactRepos, other.exactRepos)) {
            return false;
        }
        return Objects.equals(this.wildcardRepos, other.wildcardRepos);
    }
}

