/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.config;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsBootManager;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInvalidRepositoryException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsRepositoryModel;
import net.thevpc.nuts.NutsRepositoryNotFoundException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceConfigManager;
import net.thevpc.nuts.NutsWorkspaceEnvManager;
import net.thevpc.nuts.runtime.standalone.event.DefaultNutsWorkspaceEvent;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.repository.NutsRepositoryRegistryHelper;
import net.thevpc.nuts.runtime.standalone.repository.NutsRepositorySelectorHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsSimpleRepositoryWrapper;
import net.thevpc.nuts.runtime.standalone.repository.util.NutsRepositoryUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.spi.NutsRepositoryDB;
import net.thevpc.nuts.spi.NutsRepositoryFactoryComponent;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import net.thevpc.nuts.spi.NutsRepositorySPI;
import net.thevpc.nuts.spi.NutsRepositorySelectorList;

public class DefaultNutsRepositoryModel {
    private final NutsRepositoryRegistryHelper repositoryRegistryHelper;
    private final NutsWorkspace workspace;
    public NutsLogger LOG;

    public DefaultNutsRepositoryModel(NutsWorkspace workspace) {
        this.workspace = workspace;
        this.repositoryRegistryHelper = new NutsRepositoryRegistryHelper(workspace);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsRepositoryModel.class, (NutsSession)session);
        }
        return this.LOG;
    }

    public NutsRepository[] getRepositories(NutsSession session) {
        return this.repositoryRegistryHelper.getRepositories();
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public NutsRepository findRepositoryById(String repositoryNameOrId, NutsSession session) {
        NutsRepository y = this.repositoryRegistryHelper.findRepositoryById(repositoryNameOrId);
        if (y != null) {
            return y;
        }
        if (session.isTransitive()) {
            for (NutsRepository child : this.repositoryRegistryHelper.getRepositories()) {
                NutsRepository m = child.config().setSession(session.copy().setTransitive(Boolean.valueOf(true))).findMirrorById(repositoryNameOrId);
                if (m == null) continue;
                if (y == null) {
                    y = m;
                    continue;
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"ambiguous repository name %s found two Ids %s and %s", (Object[])new Object[]{repositoryNameOrId, y.getUuid(), m.getUuid()}));
            }
        }
        return y;
    }

    public NutsRepository findRepositoryByName(String repositoryNameOrId, NutsSession session) {
        NutsRepository y = this.repositoryRegistryHelper.findRepositoryByName(repositoryNameOrId);
        if (y != null) {
            return y;
        }
        if (session.isTransitive()) {
            for (NutsRepository child : this.repositoryRegistryHelper.getRepositories()) {
                NutsRepository m = child.config().setSession(session.copy().setTransitive(Boolean.valueOf(true))).findMirrorByName(repositoryNameOrId);
                if (m == null) continue;
                if (y == null) {
                    y = m;
                    continue;
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"ambiguous repository name %s found two Ids %s and %s", (Object[])new Object[]{repositoryNameOrId, y.getUuid(), m.getUuid()}));
            }
        }
        return y;
    }

    public NutsRepository findRepository(String repositoryNameOrId, NutsSession session) {
        NutsRepository y = this.repositoryRegistryHelper.findRepository(repositoryNameOrId);
        if (y != null) {
            return y;
        }
        if (session.isTransitive()) {
            for (NutsRepository child : this.repositoryRegistryHelper.getRepositories()) {
                NutsRepository m = child.config().setSession(session.copy().setTransitive(Boolean.valueOf(true))).findMirror(repositoryNameOrId);
                if (m == null) continue;
                if (y == null) {
                    y = m;
                    continue;
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"ambiguous repository name %s found two Ids %s and %s", (Object[])new Object[]{repositoryNameOrId, y.getUuid(), m.getUuid()}));
            }
        }
        return y;
    }

    public NutsRepository getRepository(String repositoryIdOrName, NutsSession session) throws NutsRepositoryNotFoundException {
        NutsWorkspaceUtils.checkSession(this.getWorkspace(), session);
        if ("<main>".equals(repositoryIdOrName)) {
            return NutsWorkspaceExt.of(this.getWorkspace()).getInstalledRepository();
        }
        NutsRepository r = this.findRepository(repositoryIdOrName, session);
        if (r != null) {
            return r;
        }
        throw new NutsRepositoryNotFoundException(session, repositoryIdOrName);
    }

    public void removeRepository(String repositoryId, NutsSession session) {
        session.security().setSession(session).checkAllowed("remove-repo", "remove-repository");
        NutsRepository repository = this.repositoryRegistryHelper.removeRepository(repositoryId);
        if (repository != null) {
            session.config().save();
            NutsWorkspaceConfigManagerExt config = NutsWorkspaceConfigManagerExt.of(session.config());
            config.getModel().fireConfigurationChanged("config-main", session, ConfigEventType.MAIN);
            NutsWorkspaceUtils.of(session).events().fireOnRemoveRepository(new DefaultNutsWorkspaceEvent(session, repository, "repository", repository, null));
        }
    }

    public void removeAllRepositories(NutsSession session) {
        for (NutsRepository repository : this.repositoryRegistryHelper.getRepositories()) {
            this.removeRepository(repository.getUuid(), session);
        }
    }

    protected void addRepository(NutsRepository repo, NutsSession session, boolean temp) {
        this.repositoryRegistryHelper.addRepository(repo, session);
        session.config().save();
        if (!temp) {
            NutsWorkspaceConfigManagerExt config = NutsWorkspaceConfigManagerExt.of(session.config());
            config.getModel().fireConfigurationChanged("config-main", session, ConfigEventType.MAIN);
            if (repo != null) {
                NutsWorkspaceUtils.of(session).events().fireOnAddRepository(new DefaultNutsWorkspaceEvent(session, repo, "repository", null, repo));
            }
        }
    }

    public NutsRepository addRepository(NutsAddRepositoryOptions options, NutsSession session) {
        NutsRepository r = this.createRepository(options, null, session);
        this.addRepository(r, session, options.isTemporary());
        return r;
    }

    public NutsRepository createRepository(NutsAddRepositoryOptions options, NutsRepository parentRepository, NutsSession session) {
        return this.createRepository(options, null, parentRepository, session);
    }

    public NutsRepository createRepository(NutsAddRepositoryOptions options, Path rootFolder, NutsRepository parentRepository, NutsSession session) {
        NutsRepositoryModel repoModel = options.getRepositoryModel();
        if (rootFolder == null) {
            Object cc;
            if (parentRepository == null) {
                cc = NutsWorkspaceConfigManagerExt.of(session.config());
                rootFolder = options.isTemporary() ? cc.getModel().getTempRepositoriesRoot(session).toFile() : cc.getModel().getRepositoriesRoot(session).toFile();
            } else {
                cc = NutsRepositoryConfigManagerExt.of(parentRepository.config());
                rootFolder = (options.isTemporary() ? cc.getModel().getTempMirrorsRoot(session) : cc.getModel().getMirrorsRoot(session)).toFile();
            }
        }
        if (repoModel != null) {
            NutsRepositoryConfig config = new NutsRepositoryConfig();
            String name = repoModel.getName();
            String uuid = repoModel.getUuid();
            if (NutsBlankable.isBlank((String)name)) {
                name = "custom";
            }
            if (NutsBlankable.isBlank((String)uuid)) {
                uuid = UUID.randomUUID().toString();
            }
            config.setName(name);
            config.setLocation(NutsRepositoryLocation.of((String)"custom@"));
            config.setUuid(uuid);
            config.setStoreLocationStrategy(repoModel.getStoreLocationStrategy());
            NutsAddRepositoryOptions options2 = new NutsAddRepositoryOptions();
            options2.setName(config.getName());
            options2.setConfig(config);
            options2.setDeployWeight(options.getDeployWeight());
            options2.setTemporary(true);
            options2.setEnabled(options.isEnabled());
            options2.setLocation(CoreIOUtils.resolveRepositoryPath(options2, rootFolder, session));
            return new NutsSimpleRepositoryWrapper(options2, session, null, repoModel);
        }
        options = options.copy();
        try {
            NutsRepository r;
            NutsRepositoryFactoryComponent factory_;
            boolean temporary = options.isTemporary();
            NutsRepositoryConfig conf = options.getConfig();
            if (temporary) {
                options.setLocation(CoreIOUtils.resolveRepositoryPath(options, rootFolder, session));
                options.setEnabled(true);
            } else if (conf == null) {
                options.setLocation(CoreIOUtils.resolveRepositoryPath(options, rootFolder, session));
                conf = this.loadRepository(NutsPath.of((String)options.getLocation(), (NutsSession)session).resolve("nuts-repository.json"), options.getName(), session);
                if (conf == null) {
                    if (options.isFailSafe()) {
                        return null;
                    }
                    throw new NutsInvalidRepositoryException(session, options.getLocation(), NutsMessage.cstyle((String)"invalid repository location ", (Object[])new Object[]{options.getLocation()}));
                }
                options.setConfig(conf);
                if (options.isEnabled()) {
                    options.setEnabled(session.boot().getBootOptions().getRepositories() == null || NutsRepositorySelectorList.ofAll((String[])session.boot().getBootOptions().getRepositories(), (NutsRepositoryDB)NutsRepositoryDB.of((NutsSession)session), (NutsSession)session).acceptExisting(conf.getLocation().setName(options.getName())));
                }
            } else {
                options.setConfig(conf);
                if (options.isEnabled()) {
                    options.setEnabled(session.boot().getBootOptions().getRepositories() == null || NutsRepositorySelectorList.ofAll((String[])session.boot().getBootOptions().getRepositories(), (NutsRepositoryDB)NutsRepositoryDB.of((NutsSession)session), (NutsSession)session).acceptExisting(conf.getLocation().setName(options.getName())));
                }
                options.setLocation(CoreIOUtils.resolveRepositoryPath(options, rootFolder, session));
            }
            if (NutsBlankable.isBlank((String)conf.getName())) {
                conf.setName(options.getName());
            }
            if (NutsBlankable.isBlank((NutsBlankable)conf.getLocation()) && !NutsBlankable.isBlank((String)options.getLocation()) && NutsPath.of((String)options.getLocation(), (NutsSession)session).isFile()) {
                conf.setLocation(NutsRepositoryLocation.of((String)options.getLocation()));
            }
            if ((factory_ = (NutsRepositoryFactoryComponent)session.extensions().setSession(session).createSupported(NutsRepositoryFactoryComponent.class, false, (Object)conf)) != null && (r = factory_.create(options, session, parentRepository)) != null) {
                return r;
            }
            String repoType = NutsRepositoryUtils.getRepoType(conf);
            if (options.isTemporary()) {
                if (NutsBlankable.isBlank((String)repoType)) {
                    throw new NutsInvalidRepositoryException(session, options.getName(), NutsMessage.cstyle((String)"unable to detect valid type for temporary repository", (Object[])new Object[0]));
                }
                throw new NutsInvalidRepositoryException(session, options.getName(), NutsMessage.cstyle((String)"invalid repository type %s", (Object[])new Object[]{repoType}));
            }
            if (NutsBlankable.isBlank((String)repoType)) {
                throw new NutsInvalidRepositoryException(session, options.getName(), NutsMessage.cstyle((String)"unable to detect valid type for repository %s", (Object[])new Object[]{options.getName()}));
            }
            throw new NutsInvalidRepositoryException(session, options.getName(), NutsMessage.cstyle((String)"invalid repository type %s", (Object[])new Object[]{repoType}));
        }
        catch (RuntimeException ex) {
            if (options.isFailSafe()) {
                return null;
            }
            throw ex;
        }
    }

    public NutsRepository addRepository(String repositoryNamedUrl, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.getWorkspace(), session);
        NutsRepositoryLocation r = null;
        try {
            r = NutsRepositoryLocation.of((String)repositoryNamedUrl, (NutsRepositoryDB)NutsRepositoryDB.of((NutsSession)session), (NutsSession)session);
        }
        catch (Exception ex) {
            throw new NutsInvalidRepositoryException(session, repositoryNamedUrl, NutsMessage.cstyle((String)"invalid repository definition", (Object[])new Object[0]));
        }
        NutsAddRepositoryOptions options = NutsRepositorySelectorHelper.createRepositoryOptions(r, true, session);
        return this.addRepository(options, session);
    }

    public NutsRepositoryConfig loadRepository(NutsPath file, String name, NutsSession session) {
        NutsRepositoryConfig conf = null;
        if (file.isRegularFile() && file.getPermissions().contains(NutsPathPermission.CAN_READ)) {
            byte[] bytes = file.readAllBytes();
            try {
                int buildNumber;
                NutsElements elem = NutsElements.of((NutsSession)session);
                Map a_config0 = (Map)elem.json().parse(bytes, Map.class);
                String version = (String)a_config0.get("configVersion");
                if (version == null) {
                    version = session.getWorkspace().getApiVersion().toString();
                }
                if ((buildNumber = CoreNutsUtils.getApiVersionOrdinalNumber(version)) < 506) {
                    // empty if block
                }
                conf = (NutsRepositoryConfig)elem.json().parse(file, NutsRepositoryConfig.class);
            }
            catch (RuntimeException ex) {
                if (session.boot().getBootOptions().isRecover()) {
                    this.onLoadRepositoryError(file, name, null, ex, session);
                }
                throw ex;
            }
        }
        return conf;
    }

    public NutsRepositorySPI toRepositorySPI(NutsRepository repo) {
        return (NutsRepositorySPI)repo;
    }

    private void onLoadRepositoryError(NutsPath file, String name, String uuid, Throwable ex, NutsSession session) {
        NutsWorkspaceConfigManager wconfig = session.config().setSession(session);
        NutsBootManager wboot = session.boot().setSession(session);
        NutsWorkspaceEnvManager wenv = session.env().setSession(session);
        if (wconfig.isReadOnly()) {
            throw new NutsIOException(session, NutsMessage.cstyle((String)"error loading repository %s", (Object[])new Object[]{file}), ex);
        }
        String fileName = "nuts-repository" + (name == null ? "" : "-" + name) + (uuid == null ? "" : "-" + uuid) + "-" + Instant.now().toString();
        this.LOG.with().session(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"erroneous repository config file. Unable to load file {0} : {1}", (Object[])new Object[]{file, ex}));
        NutsPath logError = session.locations().getStoreLocation(this.getWorkspace().getApiId(), NutsStoreLocation.LOG).resolve("invalid-config");
        try {
            logError.mkParentDirs();
        }
        catch (Exception ex1) {
            throw new NutsIOException(session, NutsMessage.cstyle((String)"unable to log repository error while loading config file %s : %s", (Object[])new Object[]{file, ex1}), ex);
        }
        NutsPath newfile = logError.resolve(fileName + ".json");
        this.LOG.with().session(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"erroneous repository config file will be replaced by a fresh one. Old config is copied to {0}", (Object[])new Object[]{newfile}));
        try {
            Files.move(file.toFile(), newfile.toFile(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new NutsIOException(session, NutsMessage.cstyle((String)"nable to load and re-create repository config file %s : %s", (Object[])new Object[]{file, e}), ex);
        }
        try (PrintStream o = new PrintStream(logError.resolve(fileName + ".error").getOutputStream());){
            o.printf("workspace.path:%s%n", session.locations().getWorkspaceLocation());
            o.printf("repository.path:%s%n", file);
            o.printf("workspace.options:%s%n", wboot.getBootOptions().formatter().setCompact(false).setRuntime(true).setInit(true).setExported(true).getBootCommandLine());
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                o.printf("location." + location.id() + ":%s%n", session.locations().getStoreLocation(location));
            }
            o.printf("java.class.path:%s%n", System.getProperty("java.class.path"));
            o.println();
            ex.printStackTrace(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

