/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.config;

import java.util.Arrays;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryFilters;
import net.thevpc.nuts.NutsRepositoryManager;
import net.thevpc.nuts.NutsRepositoryNotFoundException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.repository.config.DefaultNutsRepositoryModel;
import net.thevpc.nuts.runtime.standalone.session.NutsRepositorySessionAwareImpl;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;

public class DefaultNutsRepositoryManager
implements NutsRepositoryManager {
    private DefaultNutsRepositoryModel model;
    private NutsSession session;

    public DefaultNutsRepositoryManager(DefaultNutsRepositoryModel model) {
        this.model = model;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsRepositoryManager setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.model.getWorkspace(), session);
        return this;
    }

    public NutsRepositoryFilters filter() {
        return NutsRepositoryFilters.of((NutsSession)this.getSession());
    }

    private NutsRepository toSessionAwareRepo(NutsRepository x) {
        return NutsRepositorySessionAwareImpl.of(x, this.model.getWorkspace(), this.session);
    }

    public NutsRepository[] getRepositories() {
        return (NutsRepository[])Arrays.stream(this.model.getRepositories(this.session)).map(x -> this.toSessionAwareRepo((NutsRepository)x)).toArray(NutsRepository[]::new);
    }

    public NutsRepository findRepositoryById(String repositoryNameOrId) {
        this.checkSession();
        return this.toSessionAwareRepo(this.model.findRepositoryById(repositoryNameOrId, this.session));
    }

    public NutsRepository findRepositoryByName(String repositoryNameOrId) {
        this.checkSession();
        return this.toSessionAwareRepo(this.model.findRepositoryByName(repositoryNameOrId, this.session));
    }

    public NutsRepository findRepository(String repositoryNameOrId) {
        this.checkSession();
        return this.toSessionAwareRepo(this.model.findRepository(repositoryNameOrId, this.session));
    }

    public NutsRepository getRepository(String repositoryIdOrName) throws NutsRepositoryNotFoundException {
        this.checkSession();
        return this.toSessionAwareRepo(this.model.getRepository(repositoryIdOrName, this.session));
    }

    public NutsRepositoryManager removeRepository(String repositoryId) {
        this.checkSession();
        this.model.removeRepository(repositoryId, this.session);
        return this;
    }

    public NutsRepositoryManager removeAllRepositories() {
        this.checkSession();
        this.model.removeAllRepositories(this.session);
        return this;
    }

    public NutsRepository addRepository(NutsAddRepositoryOptions options) {
        this.checkSession();
        return this.toSessionAwareRepo(this.model.addRepository(options, this.session));
    }

    public NutsRepository addRepository(String repositoryNamedUrl) {
        this.checkSession();
        return this.toSessionAwareRepo(this.model.addRepository(repositoryNamedUrl, this.session));
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public DefaultNutsRepositoryModel getModel() {
        return this.model;
    }
}

