/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.config;

import java.util.Map;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfigManager;
import net.thevpc.nuts.NutsRepositoryRef;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSpeedQualifier;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.runtime.standalone.repository.config.NutsRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.spi.NutsRepositoryLocation;

public class DefaultNutsRepoConfigManager
implements NutsRepositoryConfigManager,
NutsRepositoryConfigManagerExt {
    private final NutsRepositoryConfigModel model;
    private NutsSession session;

    public DefaultNutsRepoConfigManager(NutsRepositoryConfigModel model) {
        this.model = model;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.getModel().getWorkspace(), this.session);
    }

    public String getGlobalName() {
        this.checkSession();
        return this.getModel().getGlobalName(this.session);
    }

    public NutsRepositoryRef getRepositoryRef() {
        this.checkSession();
        return this.getModel().getRepositoryRef(this.session);
    }

    public String getType() {
        this.checkSession();
        return this.getModel().getType(this.session);
    }

    public String getGroups() {
        this.checkSession();
        return this.getModel().getGroups(this.session);
    }

    public NutsSpeedQualifier getSpeed() {
        this.checkSession();
        return this.getModel().getSpeed(this.session);
    }

    public boolean isTemporary() {
        this.checkSession();
        return this.getModel().isTemporary(this.session);
    }

    public NutsRepositoryConfigManager setTemporary(boolean enabled) {
        this.checkSession();
        this.getModel().setTemporary(enabled, this.session);
        return this;
    }

    public boolean isIndexSubscribed() {
        this.checkSession();
        return this.getModel().isIndexSubscribed(this.session);
    }

    public NutsRepositoryLocation getLocation() {
        this.checkSession();
        return this.getModel().getLocation(this.session);
    }

    public NutsPath getLocationPath() {
        this.checkSession();
        return this.getModel().getLocationPath(this.session);
    }

    public NutsPath getStoreLocation() {
        this.checkSession();
        return this.getModel().getStoreLocation();
    }

    public NutsPath getStoreLocation(NutsStoreLocation folderType) {
        this.checkSession();
        return this.getModel().getStoreLocation(folderType, this.session);
    }

    public boolean isIndexEnabled() {
        this.checkSession();
        return this.getModel().isIndexEnabled(this.session);
    }

    public NutsRepositoryConfigManager setIndexEnabled(boolean enabled) {
        this.checkSession();
        this.getModel().setIndexEnabled(enabled, this.session);
        return this;
    }

    public NutsRepositoryConfigManager setMirrorEnabled(String repoName, boolean enabled) {
        this.checkSession();
        this.getModel().setMirrorEnabled(repoName, enabled, this.session);
        return this;
    }

    public int getDeployWeight() {
        this.checkSession();
        return this.getModel().getDeployWeight(this.session);
    }

    public boolean isEnabled() {
        return this.getModel().isEnabled(this.session);
    }

    public NutsRepositoryConfigManager setEnabled(boolean enabled) {
        this.checkSession();
        this.getModel().setEnabled(enabled, this.session);
        return this;
    }

    public NutsRepositoryConfigManager subscribeIndex() {
        this.checkSession();
        this.getModel().subscribeIndex(this.session);
        return this;
    }

    public NutsRepositoryConfigManager unsubscribeIndex() {
        this.checkSession();
        this.getModel().unsubscribeIndex(this.session);
        return this;
    }

    public boolean isSupportedMirroring() {
        this.checkSession();
        return this.getModel().isSupportedMirroring(this.session);
    }

    public NutsRepository findMirrorById(String repositoryNameOrId) {
        this.checkSession();
        return this.getModel().findMirrorById(repositoryNameOrId, this.session);
    }

    public NutsRepository findMirrorByName(String repositoryName) {
        this.checkSession();
        return this.getModel().findMirrorById(repositoryName, this.session);
    }

    public NutsRepository[] getMirrors() {
        this.checkSession();
        return this.getModel().getMirrors(this.session);
    }

    public NutsRepository getMirror(String repositoryIdOrName) {
        this.checkSession();
        return this.getModel().getMirror(repositoryIdOrName, this.session);
    }

    public NutsRepository findMirror(String repositoryIdOrName) {
        this.checkSession();
        return this.getModel().findMirror(repositoryIdOrName, this.session);
    }

    public NutsRepository addMirror(NutsAddRepositoryOptions options) {
        this.checkSession();
        return this.getModel().addMirror(options, this.session);
    }

    public NutsRepositoryConfigManager removeMirror(String repositoryId) {
        this.checkSession();
        this.getModel().removeMirror(repositoryId, this.session);
        return this;
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        this.checkSession();
        return this.getModel().getStoreLocationStrategy(this.session);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsRepositoryConfigManager setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.model.getWorkspace(), session);
        return this;
    }

    public Map<String, String> getConfigMap(boolean inherit) {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
        return this.model.toMap(inherit, this.getSession());
    }

    public String getConfigProperty(String key, String defaultValue, boolean inherit) {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
        return this.model.get(key, defaultValue, inherit, this.getSession());
    }

    public Map<String, String> getConfigMap() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
        return this.model.toMap(this.getSession());
    }

    public String getConfigProperty(String property, String defaultValue) {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
        return this.model.get(property, defaultValue, this.getSession());
    }

    public NutsRepositoryConfigManager setConfigProperty(String property, String value) {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
        this.model.set(property, value, this.session);
        return this;
    }

    @Override
    public NutsRepositoryConfigModel getModel() {
        return this.model;
    }
}

