/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.cmd.undeploy;

import java.util.logging.Level;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.repository.cmd.undeploy.AbstractNutsRepositoryUndeployCommand;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryExt;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsRepositoryUndeployCommand;

public class DefaultNutsRepositoryUndeployCommand
extends AbstractNutsRepositoryUndeployCommand {
    private NutsLogger LOG;

    public DefaultNutsRepositoryUndeployCommand(NutsRepository repo) {
        super(repo);
    }

    public DefaultNutsRepositoryUndeployCommand(NutsWorkspace ws) {
        super(null);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsRepositoryUndeployCommand.class, (NutsSession)session);
        }
        return this.LOG;
    }

    @Override
    public NutsRepositoryUndeployCommand run() {
        NutsSession session = this.getSession();
        NutsWorkspaceUtils.checkSession(this.getRepo().getWorkspace(), session);
        this.getRepo().security().setSession(session).checkAllowed("undeploy", "undeploy");
        try {
            NutsRepositoryExt xrepo = NutsRepositoryExt.of(this.getRepo());
            xrepo.undeployImpl(this);
            if (session.isIndexed() && xrepo.getIndexStore() != null && xrepo.getIndexStore().isEnabled()) {
                try {
                    xrepo.getIndexStore().invalidate(this.getId(), session);
                }
                catch (NutsException ex) {
                    this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"error invalidating Indexer for {0} : {1}", (Object[])new Object[]{this.getRepo().getName(), ex}));
                }
            }
            this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.SUCCESS).log(NutsMessage.jstyle((String)"{0} undeploy {1}", (Object[])new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20), this.getId()}));
        }
        catch (RuntimeException ex) {
            this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"{0} undeploy {1}", (Object[])new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20), this.getId()}));
        }
        return this;
    }
}

