/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.cmd.search;

import java.util.ArrayList;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.repository.cmd.search.AbstractNutsSearchVersionsRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryExt;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSearchVersionsRepositoryCommand;

public class DefaultNutsSearchVersionsRepositoryCommand
extends AbstractNutsSearchVersionsRepositoryCommand {
    private NutsLogger LOG;

    public DefaultNutsSearchVersionsRepositoryCommand(NutsRepository repo) {
        super(repo);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsSearchVersionsRepositoryCommand.class, (NutsSession)session);
        }
        return this.LOG;
    }

    @Override
    public NutsSearchVersionsRepositoryCommand run() {
        NutsSession session = this.getSession();
        NutsWorkspaceUtils.checkSession(this.getRepo().getWorkspace(), session);
        this.getRepo().security().setSession(session).checkAllowed("fetch-desc", "find-versions");
        NutsRepositoryExt xrepo = NutsRepositoryExt.of(this.getRepo());
        NutsWorkspaceUtils.of(session).checkShortId(this.id);
        xrepo.checkAllowedFetch(this.id, session);
        try {
            NutsIterator<NutsId> rr;
            ArrayList resultList = new ArrayList();
            if (this.getFetchMode() == NutsFetchMode.REMOTE && session.isIndexed() && xrepo.getIndexStore() != null && xrepo.getIndexStore().isEnabled()) {
                NutsIterator d = null;
                try {
                    d = xrepo.getIndexStore().searchVersions(this.id, session);
                }
                catch (NutsException ex) {
                    this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"error finding version with Indexer for {0} : {1}", (Object[])new Object[]{this.getRepo().getName(), ex}));
                }
                if (d != null && this.filter != null) {
                    resultList.add(IteratorBuilder.of(d, session).filter(x -> this.filter.acceptId(x, session), e -> NutsDescribables.resolveOrToString((Object)this.filter, (NutsElements)e)).safeIgnore().iterator());
                }
            }
            if ((rr = xrepo.searchVersionsImpl(this.id, this.getFilter(), this.getFetchMode(), session)) != null) {
                resultList.add(rr);
            }
            this.result = IteratorUtils.coalesce(resultList);
            return this;
        }
        catch (RuntimeException ex) {
            this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"[{0}] {1} {2} {3}", (Object[])new Object[]{CoreStringUtils.alignLeft(this.getFetchMode().toString(), 7), CoreStringUtils.alignLeft(this.getRepo().getName(), 20), CoreStringUtils.alignLeft("Fetch versions for", 24), this.id}));
            throw ex;
        }
    }

    @Override
    public NutsIterator<NutsId> getResult() {
        if (this.result == null) {
            this.run();
        }
        return this.result;
    }
}

