/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.cmd.search;

import java.util.Iterator;
import java.util.logging.Level;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIndexerNotAccessibleException;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRunnable;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.repository.cmd.search.AbstractNutsSearchRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryExt;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.iter.IndexFirstIterator;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSearchRepositoryCommand;

public class DefaultNutsSearchRepositoryCommand
extends AbstractNutsSearchRepositoryCommand {
    private NutsLogger LOG;

    public DefaultNutsSearchRepositoryCommand(NutsRepository repo) {
        super(repo);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsSearchRepositoryCommand.class, (NutsSession)session);
        }
        return this.LOG;
    }

    @Override
    public NutsSearchRepositoryCommand run() {
        NutsSession session = this.getSession();
        NutsWorkspaceUtils.checkSession(this.getRepo().getWorkspace(), session);
        NutsRunnable startRunnable = NutsRunnable.of(() -> {
            this.getRepo().security().setSession(session).checkAllowed("fetch-desc", "search");
            NutsRepositoryExt xrepo = NutsRepositoryExt.of(this.getRepo());
            xrepo.checkAllowedFetch(null, session);
            this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.START).log(NutsMessage.jstyle((String)"{0} search packages", (Object[])new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20)}));
        }, (String)"CheckAuthorizations");
        NutsRunnable endRunnable = NutsRunnable.of(() -> this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.SUCCESS).log(NutsMessage.jstyle((String)"{0} search packages", (Object[])new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20)})), (String)"Log");
        try {
            boolean processIndexFirst;
            NutsRepositoryExt xrepo = NutsRepositoryExt.of(this.getRepo());
            boolean bl = processIndexFirst = this.getFetchMode() == NutsFetchMode.REMOTE && session.isIndexed() && xrepo.getIndexStore() != null && xrepo.getIndexStore().isEnabled();
            if (processIndexFirst) {
                NutsIterator o = null;
                try {
                    o = xrepo.getIndexStore().search(this.filter, session);
                }
                catch (NutsIndexerNotAccessibleException nutsIndexerNotAccessibleException) {
                }
                catch (NutsException ex) {
                    this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"error search operation using Indexer for {0} : {1}", (Object[])new Object[]{this.getRepo().getName(), ex}));
                }
                if (o != null) {
                    this.result = IteratorBuilder.of(new IndexFirstIterator<NutsId>((Iterator<NutsId>)o, (Iterator<NutsId>)xrepo.searchImpl(this.filter, this.getFetchMode(), session), session), session).onStart(startRunnable).onFinish(endRunnable).build();
                    return this;
                }
            }
            this.result = IteratorBuilder.of(xrepo.searchImpl(this.filter, this.getFetchMode(), session), session).onStart(startRunnable).onFinish(endRunnable).build();
        }
        catch (SecurityException | NutsNotFoundException ex) {
            this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"{0} search packages", (Object[])new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20)}));
            throw ex;
        }
        catch (RuntimeException ex) {
            this._LOGOP(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"{0} search packages", (Object[])new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20)}));
            throw ex;
        }
        return this;
    }

    @Override
    public NutsIterator<NutsId> getResult() {
        if (this.result == null) {
            this.run();
        }
        return this.result;
    }
}

