/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.cmd.fetch;

import java.util.logging.Level;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.log.NutsLogUtils;
import net.thevpc.nuts.runtime.standalone.repository.cmd.fetch.AbstractNutsFetchContentRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryExt;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsFetchContentRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class DefaultNutsFetchContentRepositoryCommand
extends AbstractNutsFetchContentRepositoryCommand {
    private NutsLogger LOG;

    public DefaultNutsFetchContentRepositoryCommand(NutsRepository repo) {
        super(repo);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsFetchContentRepositoryCommand.class, (NutsSession)session);
        }
        return this.LOG;
    }

    @Override
    public NutsFetchContentRepositoryCommand run() {
        NutsRepository repo = this.getRepo();
        NutsSession session = this.getSession();
        NutsWorkspaceUtils.checkSession(repo.getWorkspace(), session);
        NutsDescriptor descriptor0 = this.descriptor;
        if (descriptor0 == null) {
            NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(repo);
            descriptor0 = repoSPI.fetchDescriptor().setId(this.id).setSession(session).setFetchMode(this.getFetchMode()).getResult();
        }
        this.id = this.id.builder().setFaceContent().build();
        repo.security().setSession(this.getSession()).checkAllowed("fetch-content", "fetch-content");
        NutsRepositoryExt xrepo = NutsRepositoryExt.of(repo);
        xrepo.checkAllowedFetch(this.id, session);
        long startTime = System.currentTimeMillis();
        try {
            NutsContent f = xrepo.fetchContentImpl(this.id, descriptor0, this.localPath, this.getFetchMode(), session);
            if (f == null) {
                throw new NutsNotFoundException(this.getSession(), this.id);
            }
            NutsLogUtils.traceMessage(this._LOG(session), Level.FINER, repo.getName(), session, this.getFetchMode(), this.id.getLongId(), NutsLogVerb.SUCCESS, "fetch package", startTime, null);
            this.result = f;
        }
        catch (RuntimeException ex) {
            if (!CoreNutsUtils.isUnsupportedFetchModeException(ex)) {
                NutsLogUtils.traceMessage(this._LOG(session), Level.FINEST, repo.getName(), session, this.getFetchMode(), this.id.getLongId(), NutsLogVerb.FAIL, "fetch package", startTime, CoreStringUtils.exceptionToMessage(ex));
            }
            throw ex;
        }
        return this;
    }

    @Override
    public NutsFetchContentRepositoryCommand setId(NutsId id) {
        this.id = id;
        return this;
    }

    @Override
    public NutsId getId() {
        return this.id;
    }
}

