/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.cmd.deploy;

import java.util.logging.Level;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.repository.cmd.deploy.AbstractNutsDeployRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryExt;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;

public class DefaultNutsDeployRepositoryCommand
extends AbstractNutsDeployRepositoryCommand {
    private NutsLogger LOG;

    public DefaultNutsDeployRepositoryCommand(NutsRepository repo) {
        super(repo);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsDeployRepositoryCommand.class, (NutsSession)session);
        }
        return this.LOG;
    }

    @Override
    public NutsDeployRepositoryCommand run() {
        NutsSession session = this.getSession();
        this.getRepo().security().setSession(this.getSession()).checkAllowed("deploy", "deploy");
        this.checkParameters();
        try {
            NutsRepositoryExt xrepo = NutsRepositoryExt.of(this.repo);
            NutsDescriptor rep = xrepo.deployImpl(this);
            this.setDescriptor(rep);
            this.setId(rep.getId());
            if (session.isIndexed() && xrepo.getIndexStore() != null && xrepo.getIndexStore().isEnabled()) {
                try {
                    xrepo.getIndexStore().revalidate(this.getId(), session);
                }
                catch (NutsException ex) {
                    this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"error revalidating Indexer for {0} : {1}", (Object[])new Object[]{this.getRepo().getName(), ex}));
                }
            }
            this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.SUCCESS).log(NutsMessage.jstyle((String)"{0} deploy {1}", (Object[])new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20), this.getId()}));
        }
        catch (RuntimeException ex) {
            this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"{0} deploy {1}", (Object[])new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20), this.getId()}));
            throw ex;
        }
        return this;
    }
}

