/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.runtime.standalone.util.collections.CoreCollectionUtils;
import net.thevpc.nuts.spi.NutsRepositoryDB;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import net.thevpc.nuts.spi.NutsRepositorySelectorList;

public class NutsRepositorySelectorHelper {
    public static NutsAddRepositoryOptions createRepositoryOptions(String s, boolean requireName, NutsSession session) {
        NutsRepositorySelectorList r = NutsRepositorySelectorList.of((String)s, (NutsRepositoryDB)NutsRepositoryDB.of((NutsSession)session), (NutsSession)session);
        NutsRepositoryLocation[] all = r.resolve(null, NutsRepositoryDB.of((NutsSession)session));
        if (all.length != 1) {
            throw new IllegalArgumentException("unexpected");
        }
        return NutsRepositorySelectorHelper.createRepositoryOptions(all[0], requireName, session);
    }

    public static NutsAddRepositoryOptions createRepositoryOptions(NutsRepositoryLocation loc, boolean requireName, NutsSession session) {
        String defaultName = null;
        NutsRepositoryDB db = NutsRepositoryDB.of((NutsSession)session);
        if (db.isDefaultRepositoryName(loc.getName())) {
            defaultName = loc.getName();
        } else {
            String nn = db.getRepositoryNameByURL(loc.getPath());
            if (nn != null) {
                defaultName = nn;
            }
        }
        if (defaultName != null) {
            NutsAddRepositoryOptions u = NutsRepositorySelectorHelper.createDefaultRepositoryOptions(defaultName, session);
            if (u != null && (loc.getPath().isEmpty() || Objects.equals(loc.getPath(), u.getConfig().getLocation().getPath()) || Objects.equals(loc.getFullLocation(), u.getConfig().getLocation().getFullLocation())) && !u.getName().equals(loc.getName())) {
                u.setName(loc.getName());
            }
            if (u != null) {
                return u;
            }
        }
        return NutsRepositorySelectorHelper.createCustomRepositoryOptions(loc.getName(), loc.getFullLocation(), requireName, session);
    }

    public static NutsAddRepositoryOptions createCustomRepositoryOptions(String name, String url, boolean requireName, NutsSession session) {
        if ((name == null || name.isEmpty()) && requireName) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing repository name (<name>=<url>) for %s", (Object[])new Object[]{name}));
        }
        if (name == null || name.isEmpty()) {
            name = url;
            if (name.startsWith("http://")) {
                name = name.substring("http://".length());
            } else if (name.startsWith("https://")) {
                name = name.substring("https://".length());
            }
            name = name.replaceAll("[/\\\\:?.]", "-");
            while (name.endsWith("-")) {
                name = name.substring(0, name.length() - 1);
            }
            while (name.startsWith("-")) {
                name = name.substring(1);
            }
        }
        if (name.isEmpty() || url.isEmpty()) {
            throw new IllegalArgumentException("missing repository name (<name>=<url>) for " + name);
        }
        return new NutsAddRepositoryOptions().setName(name).setFailSafe(false).setCreate(true).setOrder(!NutsBlankable.isBlank((String)url) && NutsPath.of((String)url, (NutsSession)session).isFile() ? 1000 : 10000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)url)));
    }

    public static NutsAddRepositoryOptions createDefaultRepositoryOptions(String nameOrURL, NutsSession session) {
        switch (nameOrURL) {
            case "local": {
                return new NutsAddRepositoryOptions().setName("local").setDeployWeight(10).setFailSafe(false).setCreate(true).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)"nuts@local")));
            }
            case "system": {
                return new NutsAddRepositoryOptions().setDeployWeight(100).setName("system").setFailSafe(true).setCreate(true).setOrder(2000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)("nuts@" + NutsPath.of((String)NutsUtilPlatforms.getPlatformHomeFolder(null, (NutsStoreLocation)NutsStoreLocation.LIB, (Map)session.config().stored().getHomeLocations(), (boolean)true, (String)"default-workspace"), (NutsSession)session).resolve("id").toString()))));
            }
            case ".m2": 
            case "m2": 
            case "maven-local": {
                return new NutsAddRepositoryOptions().setName("maven-local").setFailSafe(false).setCreate(true).setOrder(1000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)("maven@" + NutsPath.ofUserHome((NutsSession)session).resolve(".m2/repository").toString()))));
            }
            case "maven": 
            case "mvn": 
            case "central": 
            case "maven-central": {
                return new NutsAddRepositoryOptions().setName("maven-central").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)"maven@htmlfs:https://repo.maven.apache.org/maven2")).setEnv(CoreCollectionUtils.fill(new HashMap(), "maven.solrsearch.url", "https://search.maven.org/solrsearch/select", "maven.solrsearch.enable", "true")));
            }
            case "jcenter": {
                return new NutsAddRepositoryOptions().setName("jcenter").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)"maven@https://jcenter.bintray.com")));
            }
            case "jboss": {
                return new NutsAddRepositoryOptions().setName("jboss").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)"maven@https://repository.jboss.org/nexus/content/repositories/releases")));
            }
            case "clojars": {
                return new NutsAddRepositoryOptions().setName("clojars").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)"maven@https://repo.clojars.org")));
            }
            case "atlassian": {
                return new NutsAddRepositoryOptions().setName("atlassian").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)"maven@htmlfs:https://packages.atlassian.com/maven/public")));
            }
            case "atlassian-snapshot": {
                return new NutsAddRepositoryOptions().setName("atlassian-atlassian").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)"maven@https://packages.atlassian.com/maven/public-snapshot")));
            }
            case "oracle": {
                return new NutsAddRepositoryOptions().setName("oracle").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)"maven@https://maven.oracle.com")));
            }
            case "google": {
                return new NutsAddRepositoryOptions().setName("google").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)"maven@https://maven.google.com")));
            }
            case "spring": 
            case "spring-framework": {
                return new NutsAddRepositoryOptions().setName("spring").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)"maven@https://repo.spring.io/release")));
            }
            case "maven-thevpc-git": 
            case "vpc-public-maven": {
                return new NutsAddRepositoryOptions().setName("vpc-public-maven").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)"maven@dotfilefs:https://raw.githubusercontent.com/thevpc/vpc-public-maven/master")));
            }
            case "nuts-thevpc-git": 
            case "vpc-public-nuts": {
                return new NutsAddRepositoryOptions().setName("vpc-public-nuts").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)"maven@dotfilefs:https://raw.githubusercontent.com/thevpc/vpc-public-nuts/master")));
            }
            case "dev": 
            case "thevpc": 
            case "preview": {
                return new NutsAddRepositoryOptions().setName("thevpc").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)"maven@htmlfs:https://thevpc.net/maven")));
            }
        }
        return null;
    }
}

