/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import java.util.LinkedHashMap;
import java.util.Map;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPredicates;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryRef;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;

public class NutsRepositoryRegistryHelper {
    private Map<String, RepoAndRef> repositoriesByName = new LinkedHashMap<String, RepoAndRef>();
    private Map<String, RepoAndRef> repositoriesByUuid = new LinkedHashMap<String, RepoAndRef>();
    private NutsWorkspace ws;

    public NutsRepositoryRegistryHelper(NutsWorkspace ws) {
        this.ws = ws;
    }

    public NutsRepository[] getRepositories() {
        return (NutsRepository[])this.repositoriesByUuid.values().stream().map(x -> x.repo).filter(NutsPredicates.nonNull()).toArray(NutsRepository[]::new);
    }

    public NutsRepositoryRef[] getRepositoryRefs() {
        return (NutsRepositoryRef[])this.repositoriesByUuid.values().stream().map(x -> x.ref).filter(NutsPredicates.nonNull()).toArray(NutsRepositoryRef[]::new);
    }

    public void addRepository(NutsRepository repository, NutsSession session) {
        if (repository == null) {
            return;
        }
        NutsRepositoryRef repositoryRef = repository.config().setSession(session).getRepositoryRef();
        String uuid = repository.getUuid();
        String name = repository.getName();
        if (name == null) {
            return;
        }
        RepoAndRef ii = null;
        if (uuid != null && (ii = this.repositoriesByUuid.get(uuid)) != null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"repository with the same uuid already exists % / %s", (Object[])new Object[]{ii.repo.getUuid(), ii.repo.getName()}));
        }
        ii = this.repositoriesByName.get(name);
        if (ii != null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"repository with the same name already exists %s / %s", (Object[])new Object[]{ii.repo.getUuid(), ii.repo.getName()}));
        }
        if (!name.matches("[a-zA-Z][.a-zA-Z0-9_-]*")) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid repository name %s", (Object[])new Object[]{name}));
        }
        RepoAndRef rr = new RepoAndRef(repository);
        rr.ref = repositoryRef;
        this.repositoriesByName.put(name, rr);
        if (uuid != null) {
            this.repositoriesByUuid.put(uuid, rr);
        }
    }

    public NutsRepository removeRepository(String repository) {
        NutsRepository r = this.findRepository(repository);
        if (r != null) {
            this.repositoriesByName.remove(r.getName());
            this.repositoriesByUuid.remove(r.getUuid());
            return r;
        }
        return null;
    }

    private RepoAndRef findRepositoryAndRefById(String repositoryNameOrId) {
        RepoAndRef y;
        if (!NutsBlankable.isBlank((String)repositoryNameOrId) && (y = this.repositoriesByUuid.get(repositoryNameOrId)) != null) {
            return y;
        }
        return null;
    }

    private RepoAndRef findRepositoryAndRef(String repositoryNameOrId) {
        if (!NutsBlankable.isBlank((String)repositoryNameOrId)) {
            RepoAndRef y = this.repositoriesByUuid.get(repositoryNameOrId);
            if (y != null) {
                return y;
            }
            y = this.repositoriesByName.get(repositoryNameOrId);
            if (y != null) {
                return y;
            }
        }
        return null;
    }

    private RepoAndRef findRepositoryAndRefByName(String repositoryNameOrId) {
        RepoAndRef y;
        if (!NutsBlankable.isBlank((String)repositoryNameOrId) && (y = this.repositoriesByName.get(repositoryNameOrId)) != null) {
            return y;
        }
        return null;
    }

    public NutsRepository findRepositoryById(String repositoryNameOrId) {
        RepoAndRef rr = this.findRepositoryAndRefById(repositoryNameOrId);
        if (rr == null) {
            return null;
        }
        return rr.repo;
    }

    public NutsRepository findRepositoryByName(String repositoryNameOrId) {
        RepoAndRef rr = this.findRepositoryAndRefByName(repositoryNameOrId);
        if (rr == null) {
            return null;
        }
        return rr.repo;
    }

    public NutsRepository findRepository(String repositoryNameOrId) {
        RepoAndRef rr = this.findRepositoryAndRef(repositoryNameOrId);
        if (rr == null) {
            return null;
        }
        return rr.repo;
    }

    public NutsRepositoryRef findRepositoryRef(String repositoryNameOrId) {
        RepoAndRef rr = this.findRepositoryAndRef(repositoryNameOrId);
        if (rr == null) {
            return null;
        }
        return rr.ref;
    }

    private static class RepoAndRef {
        NutsRepositoryRef ref;
        NutsRepository repo;

        public RepoAndRef(NutsRepository repo) {
            this.repo = repo;
        }
    }
}

