/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.NutsContentEvent;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryEvent;
import net.thevpc.nuts.NutsRepositoryListener;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSpeedQualifier;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.impl.NutsRepositoryExt;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NutsInstalledRepository;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsSpeedQualifiers;

public class NutsRepositoryHelper {
    private NutsLogger LOG;
    private final NutsRepository repo;

    private NutsRepositoryHelper(NutsRepository repo) {
        this.repo = repo;
    }

    public static NutsRepositoryHelper of(NutsRepository repo) {
        Map up = repo.getUserProperties();
        NutsRepositoryHelper wp = (NutsRepositoryHelper)up.get(NutsRepositoryHelper.class.getName());
        if (wp == null) {
            wp = new NutsRepositoryHelper(repo);
            up.put(NutsRepositoryHelper.class.getName(), wp);
        }
        return wp;
    }

    public static NutsSpeedQualifier getSupportSpeedLevel(NutsRepository repository, NutsRepositorySupportedAction supportedAction, NutsId id, NutsFetchMode mode, boolean transitive, NutsSession session) {
        NutsSpeedQualifier r;
        if (repository instanceof NutsInstalledRepository) {
            return NutsSpeedQualifier.UNAVAILABLE;
        }
        NutsRepositoryExt xrepo = NutsRepositoryExt.of(repository);
        ArrayList<NutsSpeedQualifier> speeds = new ArrayList<NutsSpeedQualifier>();
        if (xrepo.acceptAction(id, supportedAction, mode, session) && (r = repository.config().getSpeed()) != NutsSpeedQualifier.UNAVAILABLE) {
            speeds.add(r);
        }
        if (transitive) {
            for (NutsRepository remote : repository.config().setSession(session).getMirrors()) {
                NutsSpeedQualifier r2 = NutsRepositoryHelper.getSupportSpeedLevel(remote, supportedAction, id, mode, transitive, session);
                if (r2 == NutsSpeedQualifier.UNAVAILABLE) continue;
                speeds.add(r2);
            }
        }
        if (speeds.size() == 0) {
            return NutsSpeedQualifier.UNAVAILABLE;
        }
        return NutsSpeedQualifiers.max(speeds.toArray(new NutsSpeedQualifier[0]));
    }

    public static int getSupportDeployLevel(NutsRepository repository, NutsRepositorySupportedAction supportedAction, NutsId id, NutsFetchMode mode, boolean transitive, NutsSession session) {
        int r;
        if (repository instanceof NutsInstalledRepository) {
            return 0;
        }
        NutsRepositoryExt xrepo = NutsRepositoryExt.of(repository);
        int result = 0;
        if (xrepo.acceptAction(id, supportedAction, mode, session) && (r = repository.config().getDeployWeight()) > 0 && r > result) {
            result = r;
        }
        if (transitive) {
            for (NutsRepository remote : repository.config().setSession(session).getMirrors()) {
                int r2 = NutsRepositoryHelper.getSupportDeployLevel(remote, supportedAction, id, mode, transitive, session);
                if (r2 <= 0 || r2 <= result) continue;
                result = r2;
            }
        }
        return result;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(NutsRepositoryHelper.class, (NutsSession)session);
        }
        return this.LOG;
    }

    public Events events() {
        return new Events(this);
    }

    public static class Events {
        private final NutsRepositoryHelper u;

        public Events(NutsRepositoryHelper u) {
            this.u = u;
        }

        public void fireOnUndeploy(NutsContentEvent evt) {
            for (NutsRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onUndeploy(evt);
            }
            for (NutsRepositoryListener listener : evt.getSession().events().getRepositoryListeners()) {
                listener.onUndeploy(evt);
            }
        }

        public void fireOnDeploy(NutsContentEvent event) {
            for (NutsRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onDeploy(event);
            }
            for (NutsRepositoryListener listener : event.getSession().events().getRepositoryListeners()) {
                listener.onDeploy(event);
            }
        }

        public void fireOnPush(NutsContentEvent event) {
            for (NutsRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onPush(event);
            }
            for (NutsRepositoryListener listener : event.getSession().events().getRepositoryListeners()) {
                listener.onPush(event);
            }
            for (NutsRepositoryListener listener : (NutsRepositoryListener[])event.getSession().getListeners(NutsRepositoryListener.class)) {
                listener.onPush(event);
            }
        }

        public void fireOnAddRepository(NutsRepositoryEvent event) {
            if (this.u._LOG(event.getSession()).isLoggable(Level.FINEST)) {
                this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.ADD).log(NutsMessage.jstyle((String)"{0} add    repo {1}", (Object[])new Object[]{CoreStringUtils.alignLeft(this.u.repo.getName(), 20), event.getRepository().getName()}));
            }
            for (NutsRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onAddRepository(event);
            }
            for (NutsRepositoryListener listener : event.getSession().events().getRepositoryListeners()) {
                listener.onAddRepository(event);
            }
            for (NutsRepositoryListener listener : (NutsRepositoryListener[])event.getSession().getListeners(NutsRepositoryListener.class)) {
                listener.onAddRepository(event);
            }
        }

        public void fireOnRemoveRepository(NutsRepositoryEvent event) {
            if (this.u._LOG(event.getSession()).isLoggable(Level.FINEST)) {
                this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.REMOVE).log(NutsMessage.jstyle((String)"{0} remove repo {1}", (Object[])new Object[]{CoreStringUtils.alignLeft(this.u.repo.getName(), 20), event.getRepository().getName()}));
            }
            for (NutsRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onRemoveRepository(event);
            }
            for (NutsRepositoryListener listener : event.getSession().events().getRepositoryListeners()) {
                listener.onRemoveRepository(event);
            }
            for (NutsRepositoryListener listener : (NutsRepositoryListener[])event.getSession().getListeners(NutsRepositoryListener.class)) {
                listener.onRemoveRepository(event);
            }
        }
    }
}

