/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import java.io.IOException;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsInputStreamMonitor;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSearchId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsSearchIdByDescriptor;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsSearchIdById;
import net.thevpc.nuts.runtime.standalone.repository.NutsIdPathIteratorModel;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;

public abstract class NutsIdPathIteratorBase
implements NutsIdPathIteratorModel {
    public NutsId validate(NutsId id, NutsDescriptor t, NutsPath pathname, NutsPath rootPath, NutsIdFilter filter, NutsRepository repository, NutsSession session) throws IOException {
        if (t != null) {
            if (!CoreNutsUtils.isEffectiveId(t.getId())) {
                NutsDescriptor nutsDescriptor = null;
                try {
                    nutsDescriptor = NutsWorkspaceExt.of(session.getWorkspace()).resolveEffectiveDescriptor(t, session);
                }
                catch (Exception ex) {
                    NutsLoggerOp.of(NutsIdPathIteratorBase.class, (NutsSession)session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"error resolving effective descriptor for {0} in url {1} : {2}", (Object[])new Object[]{t.getId(), pathname, ex}));
                }
                t = nutsDescriptor;
            }
            if (filter == null || filter.acceptSearchId((NutsSearchId)new NutsSearchIdByDescriptor(t), session)) {
                NutsId nutsId = t.getId().builder().setRepository(repository.getName()).build();
                return nutsId;
            }
        }
        if (id != null && (filter == null || filter.acceptSearchId((NutsSearchId)new NutsSearchIdById(id), session))) {
            return id;
        }
        return null;
    }

    @Override
    public NutsId parseId(NutsPath pathname, NutsPath rootPath, NutsIdFilter filter, NutsRepository repository, NutsSession session) throws IOException {
        NutsDescriptor t = null;
        try {
            t = this.parseDescriptor(pathname, NutsInputStreamMonitor.of((NutsSession)session).setSource(pathname).create(), NutsFetchMode.LOCAL, repository, session, rootPath);
        }
        catch (Exception ex) {
            NutsLoggerOp.of(NutsIdPathIteratorBase.class, (NutsSession)session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"error parsing url : {0} : {1}", (Object[])new Object[]{pathname, this.toString()}));
        }
        if (t != null) {
            return this.validate(null, t, pathname, rootPath, filter, repository, session);
        }
        return null;
    }
}

