/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import java.util.Stack;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.runtime.standalone.repository.NutsIdPathIteratorModel;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class NutsIdPathIterator
extends NutsIteratorBase<NutsId> {
    private final NutsRepository repository;
    private final Stack<PathAndDepth> stack = new Stack();
    private final NutsIdFilter filter;
    private final NutsSession session;
    private final NutsIdPathIteratorModel model;
    private final int maxDepth;
    private final NutsPath basePath;
    private final NutsPath rootFolder;
    private NutsId last;
    private long visitedFoldersCount;
    private long visitedFilesCount;
    private final NutsObjectElement extraProperties;
    private final String kind;

    public NutsIdPathIterator(NutsRepository repository, NutsPath rootFolder, NutsPath basePath, NutsIdFilter filter, NutsSession session, NutsIdPathIteratorModel model, int maxDepth, String kind, NutsObjectElement extraProperties) {
        this.repository = repository;
        this.extraProperties = extraProperties;
        this.kind = kind;
        this.session = session;
        this.filter = filter;
        this.model = model;
        this.maxDepth = maxDepth;
        if (rootFolder == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"could not iterate over null rootFolder"));
        }
        this.basePath = basePath;
        this.rootFolder = rootFolder;
        NutsPath startUrl = rootFolder;
        if (basePath != null) {
            if (basePath.isAbsolute()) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"expected relative path : %s", (Object[])new Object[]{basePath}));
            }
            startUrl = startUrl.resolve(basePath);
        }
        this.stack.push(new PathAndDepth(startUrl, true, 0));
    }

    public NutsElement describe(NutsElements elems) {
        return elems.ofObject().set("type", "ScanPath").set("repository", this.repository == null ? null : this.repository.getName()).set("filter", NutsDescribables.resolveOrDestruct((Object)this.filter, (NutsElements)elems)).set("path", elems.toElement((Object)this.basePath)).set("root", elems.toElement((Object)this.rootFolder)).set("maxDepth", this.maxDepth).addAll(this.extraProperties).build();
    }

    public boolean hasNext() {
        this.last = null;
        while (!this.stack.isEmpty()) {
            PathAndDepth file = this.stack.pop();
            if (file.folder) {
                this.session.getTerminal().printProgress("%-14s %-8s %-8s %s", new Object[]{this.repository.getName(), this.kind, "search folder", file.path.toCompressedForm()});
                ++this.visitedFoldersCount;
                NutsPath[] children = new NutsPath[]{};
                try {
                    children = (NutsPath[])file.path.list().toArray(NutsPath[]::new);
                }
                catch (NutsIOException ex) {
                    this.session.getTerminal().printProgress("%-14s %-8s %-8s %s %s", new Object[]{this.repository.getName(), this.kind, "search folder", file.path.toCompressedForm(), NutsTexts.of((NutsSession)this.session).ofStyled("failed!", NutsTextStyle.error())});
                    NutsLoggerOp.of(NutsIdPathIterator.class, (NutsSession)this.session).level(Level.FINE).log(NutsMessage.jstyle((String)"error listing : {0} : {1} : {2}", (Object[])new Object[]{file.path, this.toString(), ex.toString()}));
                }
                catch (Exception ex) {
                    this.session.getTerminal().printProgress("%-14s %-8s %-8s %s %s", new Object[]{this.repository.getName(), this.kind, "search folder", file.path.toCompressedForm(), NutsTexts.of((NutsSession)this.session).ofStyled("failed!", NutsTextStyle.error())});
                    NutsLoggerOp.of(NutsIdPathIterator.class, (NutsSession)this.session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"error listing : {0} : {1}", (Object[])new Object[]{file.path, this.toString()}));
                }
                boolean deep = file.depth < this.maxDepth;
                for (NutsPath child : children) {
                    if (child.isDirectory()) {
                        if (!deep) continue;
                        this.stack.push(new PathAndDepth(child, true, file.depth + 1));
                        continue;
                    }
                    if (!this.model.isDescFile(child)) continue;
                    this.stack.push(new PathAndDepth(child, false, file.depth));
                }
                continue;
            }
            ++this.visitedFilesCount;
            NutsId t = null;
            try {
                t = this.model.parseId(file.path, this.rootFolder, this.filter, this.repository, this.session);
            }
            catch (Exception ex) {
                NutsLoggerOp.of(NutsIdPathIterator.class, (NutsSession)this.session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"error parsing : {0} : {1}", (Object[])new Object[]{file.path, this.toString()}));
            }
            if (t == null) continue;
            this.last = t;
            return true;
        }
        return this.last != null;
    }

    public NutsId next() {
        NutsId ret = this.last;
        this.last = null;
        return ret;
    }

    public void remove() {
        if (this.last != null) {
            this.model.undeploy(this.last, this.session);
        }
        throw new NutsUnsupportedOperationException(this.session, NutsMessage.cstyle((String)"unsupported Remove", (Object[])new Object[0]));
    }

    public long getVisitedFoldersCount() {
        return this.visitedFoldersCount;
    }

    public long getVisitedFilesCount() {
        return this.visitedFilesCount;
    }

    private static class PathAndDepth {
        private final NutsPath path;
        private final int depth;
        private final boolean folder;

        public PathAndDepth(NutsPath path, boolean folder, int depth) {
            this.path = path;
            this.folder = folder;
            this.depth = depth;
        }
    }
}

