/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.spi.NutsRepositoryDB;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsRepositoryDB
implements NutsRepositoryDB {
    private final Map<String, String> defaultRepositoriesByName = new LinkedHashMap<String, String>();
    private final Map<String, String> aliasToBase = new LinkedHashMap<String, String>();
    private final Map<String, Set<String>> baseToAliases = new LinkedHashMap<String, Set<String>>();

    private DefaultNutsRepositoryDB(NutsSession session) {
        this.reg("system", "nuts@" + NutsPath.of((String)NutsUtilPlatforms.getDefaultPlatformHomeFolder(null, (NutsStoreLocation)NutsStoreLocation.LIB, (boolean)true, (String)"default-workspace"), (NutsSession)session).resolve("id").toString(), new String[0]);
        this.reg("maven-local", "maven@" + NutsPath.ofUserHome((NutsSession)session).resolve(".m2/repository").toString(), ".m2", "m2");
        this.reg("maven-central", "maven@htmlfs:https://repo.maven.apache.org/maven2", "central", "maven", "central");
        this.reg("jcenter", "maven@https://jcenter.bintray.com", new String[0]);
        this.reg("jboss", "maven@https://repository.jboss.org/nexus/content/repositories/releases", new String[0]);
        this.reg("clojars", "maven@https://repo.clojars.org", new String[0]);
        this.reg("atlassian", "maven@https://packages.atlassian.com/maven/public", new String[0]);
        this.reg("atlassian-snapshot", "maven@https://packages.atlassian.com/maven/public-snapshot", new String[0]);
        this.reg("oracle", "maven@https://maven.oracle.com", new String[0]);
        this.reg("google", "maven@https://maven.google.com", new String[0]);
        this.reg("spring", "maven@https://repo.spring.io/release", "spring-framework");
        this.reg("maven-thevpc-git", "maven@https://raw.githubusercontent.com/thevpc/vpc-public-maven/master", "vpc-public-maven");
        this.reg("nuts-thevpc-git", "maven@https://raw.githubusercontent.com/thevpc/vpc-public-nuts/master", "vpc-public-nuts");
        this.reg("thevpc", "maven@htmlfs:https://thevpc.net/maven", "dev", "preview");
        this.reg("local", "nuts@local", new String[0]);
    }

    public Set<String> getAllNames(String name) {
        Set<String> a = this.baseToAliases.get(name);
        if (a != null) {
            return Collections.unmodifiableSet(a);
        }
        String base = this.aliasToBase.get(name);
        if (base != null && (a = this.baseToAliases.get(base)) != null) {
            return Collections.unmodifiableSet(a);
        }
        return Collections.singleton(name);
    }

    public String getRepositoryNameByURL(String url) {
        NutsRepositoryLocation v;
        NutsRepositoryLocation v0 = NutsRepositoryLocation.of((String)url).setName(null);
        for (Map.Entry<String, String> entry : this.defaultRepositoriesByName.entrySet()) {
            v = NutsRepositoryLocation.of((String)entry.getValue()).setName(null);
            if (!v.equals((Object)v0)) continue;
            return entry.getKey();
        }
        v0 = NutsRepositoryLocation.of((String)url).setName(null).setLocationType(null);
        for (Map.Entry<String, String> entry : this.defaultRepositoriesByName.entrySet()) {
            v = NutsRepositoryLocation.of((String)entry.getValue()).setName(null).setLocationType(null);
            if (!v.equals((Object)v0)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean isDefaultRepositoryName(String name) {
        return this.defaultRepositoriesByName.containsKey(name) || this.aliasToBase.containsKey(name);
    }

    public String getRepositoryURLByName(String name) {
        String a = this.defaultRepositoriesByName.get(name);
        if (a != null) {
            return a;
        }
        String base = this.aliasToBase.get(name);
        if (base != null) {
            return this.defaultRepositoriesByName.get(base);
        }
        return null;
    }

    private void reg(String name, String url, String ... names) {
        this.defaultRepositoriesByName.put(name, url);
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        all.add(name);
        for (String other : names) {
            this.aliasToBase.put(other, name);
            all.add(other);
        }
        this.baseToAliases.put(name, all);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

