/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import java.util.Map;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.repository.NutsRepositorySelectorHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.nuts.NutsFolderRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.nuts.NutsHttpFolderRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.nuts.NutsHttpSrvRepository;
import net.thevpc.nuts.runtime.standalone.repository.util.NutsRepositoryUtils;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsRepositoryDB;
import net.thevpc.nuts.spi.NutsRepositoryFactoryComponent;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class DefaultNutsRepoFactoryComponent
implements NutsRepositoryFactoryComponent {
    public int getSupportLevel(NutsSupportLevelContext criteria) {
        if (criteria == null) {
            return -1;
        }
        NutsRepositoryConfig r = (NutsRepositoryConfig)criteria.getConstraints(NutsRepositoryConfig.class);
        if (r != null) {
            String type = NutsRepositoryUtils.getRepoType(r);
            if ("nuts".equals(type)) {
                return 20;
            }
            if (NutsBlankable.isBlank((String)type)) {
                NutsPath rp = NutsPath.of((String)r.getLocation().getPath(), (NutsSession)criteria.getSession()).resolve("nuts-repository.json");
                if (rp.exists()) {
                    r.setLocation(r.getLocation().setLocationType("nuts"));
                    return 20;
                }
                return 12;
            }
        }
        return -1;
    }

    public NutsAddRepositoryOptions[] getDefaultRepositories(NutsSession session) {
        if (!session.config().isGlobal()) {
            return new NutsAddRepositoryOptions[]{NutsRepositorySelectorHelper.createRepositoryOptions(NutsRepositoryLocation.of((String)"system", (NutsRepositoryDB)NutsRepositoryDB.of((NutsSession)session), (NutsSession)session), true, session)};
        }
        return new NutsAddRepositoryOptions[0];
    }

    public NutsRepository create(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository) {
        NutsRepositoryConfig config = options.getConfig();
        String type = NutsRepositoryUtils.getRepoType(config);
        if (NutsBlankable.isBlank((String)type)) {
            return null;
        }
        if ("nuts".equals(type)) {
            if (NutsBlankable.isBlank((NutsBlankable)config.getLocation()) || NutsPath.of((String)config.getLocation().getPath(), (NutsSession)session).isFile()) {
                return new NutsFolderRepository(options, session, parentRepository);
            }
            if (NutsPath.of((String)config.getLocation().getPath(), (NutsSession)session).isURL()) {
                Map e = config.getEnv();
                if (e != null && NutsUtilStrings.parseBoolean((String)((String)e.get("nuts-api-server")), (Boolean)false, (Boolean)false).booleanValue()) {
                    return new NutsHttpSrvRepository(options, session, parentRepository);
                }
                return new NutsHttpFolderRepository(options, session, parentRepository);
            }
        }
        return null;
    }
}

