/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.log;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.log.NutsLogRecord;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;

public class NutsLogUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Map<Level, String> logLevelCache = new HashMap<Level, String>();
    private static final Map<String, String> logVerbCache = new HashMap<String, String>();
    private static final Map<String, String> classNameCache = new HashMap<String, String>();

    public static NutsLogRecord toNutsLogRecord(LogRecord record, NutsSession session) {
        Level lvl;
        if (record instanceof NutsLogRecord) {
            return (NutsLogRecord)record;
        }
        NutsLogRecord h = new NutsLogRecord(session, lvl, (lvl = record.getLevel()).intValue() <= Level.SEVERE.intValue() ? NutsLogVerb.FAIL : (lvl.intValue() <= Level.WARNING.intValue() ? NutsLogVerb.WARNING : (lvl.intValue() <= Level.INFO.intValue() ? NutsLogVerb.INFO : (lvl.intValue() <= Level.FINE.intValue() ? NutsLogVerb.DEBUG : NutsLogVerb.DEBUG))), NutsMessage.jstyle((String)record.getMessage(), (Object[])record.getParameters()), record.getMillis(), record.getThrown());
        h.setResourceBundle(record.getResourceBundle());
        h.setResourceBundleName(record.getResourceBundleName());
        h.setSequenceNumber(record.getSequenceNumber());
        h.setSourceClassName(record.getSourceClassName());
        h.setLoggerName(record.getLoggerName());
        h.setSourceMethodName(record.getSourceMethodName());
        h.setThreadID(record.getThreadID());
        return h;
    }

    public static String logLevel(Level l) {
        String v = logLevelCache.get(l);
        if (v == null) {
            StringBuilder sb = new StringBuilder(l.getName());
            NutsLogUtils.ensureSize(sb, 6);
            v = sb.toString();
            logLevelCache.put(l, v);
        }
        return v;
    }

    public static String logVerb(String l) {
        String v;
        if (l == null) {
            l = "";
        }
        if ((v = logVerbCache.get(l)) == null) {
            StringBuilder sb = new StringBuilder(7);
            sb.append(l);
            NutsLogUtils.ensureSize(sb, 7);
            v = sb.toString();
            logVerbCache.put(l, v);
        }
        return v;
    }

    public static void ensureSize(StringBuilder sb, int size) {
        sb.ensureCapacity(size);
        int length = size - sb.length();
        while (length > 0) {
            if (length >= 16) {
                sb.append("                ");
                length -= 16;
                continue;
            }
            if (length >= 8) {
                sb.append("        ");
                length -= 8;
                continue;
            }
            if (length >= 4) {
                sb.append("    ");
                length -= 4;
                continue;
            }
            if (length >= 2) {
                sb.append("  ");
                length -= 2;
                continue;
            }
            sb.append(' ');
            --length;
        }
    }

    public static String formatClassName(String className) {
        if (className == null) {
            return "";
        }
        String v = classNameCache.get(className);
        if (v == null) {
            int end;
            int maxSize = 47;
            StringBuilder sb = new StringBuilder(maxSize);
            int pos = 0;
            while ((end = className.indexOf(46, pos)) >= 0) {
                sb.append(className.charAt(pos)).append('.');
                pos = end + 1;
            }
            sb.append(className.substring(pos));
            NutsLogUtils.ensureSize(sb, maxSize);
            v = sb.toString();
            classNameCache.put(className, v);
        }
        return v;
    }

    public static String[] stacktraceToArray(Throwable th) {
        try {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                th.printStackTrace(pw);
            }
            BufferedReader br = new BufferedReader(new StringReader(sw.toString()));
            ArrayList<String> s = new ArrayList<String>();
            String line = null;
            while ((line = br.readLine()) != null) {
                s.add(line);
            }
            return s.toArray(new String[0]);
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public static String stacktrace(Throwable th) {
        try {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                th.printStackTrace(pw);
            }
            return sw.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static final NutsSession resolveSession(LogRecord record, NutsWorkspace ws) {
        NutsSession session = null;
        if (record instanceof NutsLogRecord) {
            session = ((NutsLogRecord)record).getSession();
        }
        if (session == null) {
            session = NutsWorkspaceExt.of(ws).defaultSession();
        }
        return session;
    }

    public static final NutsSession resolveSession(LogRecord record, NutsSession defSession) {
        NutsSession session = null;
        if (record instanceof NutsLogRecord) {
            session = ((NutsLogRecord)record).getSession();
        }
        if (session == null) {
            session = defSession;
        }
        return session;
    }

    public static void traceMessage(NutsLogger log, Level lvl, String name, NutsSession session, NutsFetchMode fetchMode, NutsId id, NutsLogVerb tracePhase, String title, long startTime, NutsMessage extraMsg) {
        if (!log.isLoggable(lvl)) {
            return;
        }
        if (extraMsg == null) {
            String sep = "";
            extraMsg = NutsMessage.formatted((String)"");
        } else {
            String sep = " : ";
        }
        long time = startTime != 0L ? System.currentTimeMillis() - startTime : 0L;
        String modeString = CoreStringUtils.alignLeft(fetchMode.id(), 7);
        log.with().session(session).level(lvl).verb(tracePhase).time(time).log(NutsMessage.jstyle((String)"[{0}] {1} {2} {3} {4}", (Object[])new Object[]{modeString, CoreStringUtils.alignLeft(name, 20), CoreStringUtils.alignLeft(title, 18), id == null ? "" : id, extraMsg}));
    }

    public static void traceMessage(NutsLogger log, NutsFetchStrategy fetchMode, NutsId id, NutsLogVerb tracePhase, String message, long startTime) {
        if (log.isLoggable(Level.FINEST)) {
            long time = startTime != 0L ? System.currentTimeMillis() - startTime : 0L;
            String fetchString = "[" + CoreStringUtils.alignLeft(fetchMode.id(), 7) + "] ";
            log.with().level(Level.FINEST).verb(tracePhase).time(time).log(NutsMessage.jstyle((String)"{0}{1} {2}", (Object[])new Object[]{fetchString, id, CoreStringUtils.alignLeft(message, 18)}));
        }
    }
}

