/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.log;

import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.log.DefaultNutsLogger;
import net.thevpc.nuts.runtime.standalone.log.NutsLogRecord;

public class DefaultNutsLoggerOp
implements NutsLoggerOp {
    private NutsSession session;
    private DefaultNutsLogger logger;
    private Level level = Level.FINE;
    private NutsLogVerb verb;
    private NutsMessage msg;
    private long time;
    private Supplier<NutsMessage> msgSupplier;
    private Throwable error;

    public DefaultNutsLoggerOp(DefaultNutsLogger logger) {
        this.logger = logger;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsLoggerOp session(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsLoggerOp verb(NutsLogVerb verb) {
        this.verb = verb;
        return this;
    }

    public NutsLoggerOp level(Level level) {
        this.level = level == null ? Level.FINE : level;
        return this;
    }

    public NutsLoggerOp error(Throwable error) {
        this.error = error;
        return this;
    }

    public void log(NutsMessage message) {
        this.msg = message;
        this.run();
    }

    public void log(Supplier<NutsMessage> msgSupplier) {
        this.msgSupplier = msgSupplier;
        this.run();
    }

    public NutsLoggerOp time(long time) {
        this.time = time;
        return this;
    }

    private void run() {
        if (this.logger.isLoggable(this.level)) {
            NutsSession s;
            NutsMessage m = this.msg;
            if (this.msgSupplier != null) {
                m = this.msgSupplier.get();
            }
            if ((s = this.session) == null) {
                s = this.logger.getSession();
            }
            NutsLogRecord record = new NutsLogRecord(s, this.level, this.verb, m, this.time, this.error);
            this.logger.log(record);
        }
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }
}

