/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.log;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Supplier;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.log.DefaultNutsLogManager;
import net.thevpc.nuts.runtime.standalone.log.DefaultNutsLoggerOp;
import net.thevpc.nuts.runtime.standalone.log.NutsLogRecord;
import net.thevpc.nuts.spi.NutsLogManager;

public class DefaultNutsLogger
implements NutsLogger {
    private NutsWorkspace workspace;
    private NutsSession session;
    private long defaultTime;
    private Logger log;
    private static final int offValue = Level.OFF.intValue();
    private LinkedList<LogRecord> suspendedTerminalRecords = new LinkedList();
    private int suspendedMax = 100;
    private boolean suspendTerminalMode = false;

    public DefaultNutsLogger(NutsWorkspace workspace, NutsSession session, Class log, boolean suspended) {
        this(workspace, session, log.getName());
        if (suspended) {
            this.suspendTerminal();
        }
    }

    public DefaultNutsLogger(NutsWorkspace workspace, NutsSession session, Class log) {
        this(workspace, session, log.getName());
    }

    public DefaultNutsLogger(NutsWorkspace workspace, NutsSession session, String log) {
        this(workspace, session, Logger.getLogger(log));
    }

    public DefaultNutsLogger(NutsWorkspace workspace, NutsSession session, Logger log) {
        this.workspace = workspace;
        this.log = log;
        this.session = session;
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public Filter getFilter() {
        return null;
    }

    private boolean isLoggable(Level level, Level current) {
        int levelValue = current.intValue();
        return level.intValue() >= levelValue && levelValue != offValue;
    }

    public boolean isLoggable(Level level) {
        if (this.isLoggable(level, NutsLogger.getTermLevel((NutsSession)this.getSession()))) {
            return true;
        }
        if (this.isLoggable(level, NutsLogger.getFileLevel((NutsSession)this.getSession()))) {
            return true;
        }
        for (Handler handler : NutsLogger.getHandlers((NutsSession)this.getSession())) {
            if (!this.isLoggable(level, handler.getLevel())) continue;
            return true;
        }
        return this.log.isLoggable(level);
    }

    public void log(Level level, NutsLogVerb verb, NutsMessage msg, Throwable thrown) {
        this.log(this.session, level, verb, msg, thrown);
    }

    public void log(NutsSession session, Level level, NutsLogVerb verb, NutsMessage msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (session == null) {
            session = this.session;
        }
        this.doLog(new NutsLogRecord(session, level, verb, msg, this.defaultTime, thrown));
    }

    public void log(NutsSession session, Level level, NutsLogVerb verb, Supplier<NutsMessage> msgSupplier, Supplier<Throwable> errorSupplier) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (session == null) {
            session = this.session;
        }
        this.doLog(new NutsLogRecord(session, level, verb, msgSupplier == null ? null : msgSupplier.get(), this.defaultTime, errorSupplier == null ? null : errorSupplier.get()));
    }

    private void doLog(LogRecord record) {
        record.setLoggerName(this.log.getName());
        if (!this.isLoggable(record)) {
            return;
        }
        this.log0(record);
    }

    public NutsLoggerOp with() {
        return new DefaultNutsLoggerOp(this).session(this.getSession());
    }

    private boolean isLoggable(LogRecord record) {
        Filter theFilter = this.getFilter();
        return theFilter == null || theFilter.isLoggable(record);
    }

    public void log(LogRecord record) {
        if (!this.isLoggable(record.getLevel())) {
            return;
        }
        if (!this.isLoggable(record)) {
            return;
        }
        this.log0(record);
    }

    public void suspendTerminal() {
        this.suspendTerminalMode = true;
    }

    private void log0(LogRecord record) {
        Handler fh;
        DefaultNutsLogManager logManager = (DefaultNutsLogManager)NutsLogManager.of((NutsSession)this.getSession());
        logManager.getModel().updateHandlers(record);
        Handler ch = logManager.getModel().getTermHandler();
        if (ch != null && ch.isLoggable(record)) {
            if (this.suspendTerminalMode) {
                this.suspendedTerminalRecords.add(record);
                if (this.suspendedTerminalRecords.size() > this.suspendedMax) {
                    LogRecord r = this.suspendedTerminalRecords.removeFirst();
                    logManager.getModel().updateTermHandler(r);
                    ch.publish(r);
                    ch.flush();
                }
            } else {
                ch.publish(record);
                ch.flush();
            }
        }
        if ((fh = logManager.getModel().getFileHandler()) != null && fh.isLoggable(record)) {
            fh.publish(record);
        }
        for (Handler handler : logManager.getModel().getHandlers()) {
            if (!handler.isLoggable(record)) continue;
            handler.publish(record);
        }
        this.log.log(record);
    }

    public void resumeTerminal(NutsSession session) {
        this.suspendTerminalMode = false;
        Handler ch = NutsLogger.getTermHandler((NutsSession)session);
        DefaultNutsLogManager logManager = (DefaultNutsLogManager)NutsLogManager.of((NutsSession)session);
        Iterator iterator = this.suspendedTerminalRecords.iterator();
        while (iterator.hasNext()) {
            LogRecord r = (LogRecord)iterator.next();
            iterator.remove();
            logManager.getModel().updateHandlers(r);
            if (ch == null) continue;
            ch.publish(r);
        }
        if (ch != null) {
            ch.flush();
        }
    }
}

