/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.log;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.thevpc.nuts.NutsLogConfig;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNutsBootManager;
import net.thevpc.nuts.runtime.standalone.log.DefaultNutsLogManager;
import net.thevpc.nuts.runtime.standalone.log.DefaultNutsLogger;
import net.thevpc.nuts.runtime.standalone.log.NutsLogConsoleHandler;
import net.thevpc.nuts.runtime.standalone.log.NutsLogFileHandler;
import net.thevpc.nuts.runtime.standalone.log.NutsLogUtils;
import net.thevpc.nuts.runtime.standalone.workspace.CoreNutsBootOptions;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;

public class DefaultNutsLogModel {
    private static Handler[] EMPTY = new Handler[0];
    private NutsWorkspace workspace;
    private NutsPrintStream out;
    private Handler consoleHandler;
    private Handler fileHandler;
    private NutsLogConfig logConfig = new NutsLogConfig();
    private List<Handler> extraHandlers = new ArrayList<Handler>();
    private Path logFolder;
    private NutsSession defaultSession;
    private Map<String, NutsLogger> loaded = new LinkedHashMap<String, NutsLogger>();

    public DefaultNutsLogModel(NutsWorkspace ws, CoreNutsBootOptions bOptions) {
        this.workspace = ws;
        NutsWorkspaceOptions bootOptions = NutsWorkspaceExt.of((NutsWorkspace)this.workspace).getModel().bootModel.getBootOptions();
        this.logFolder = Paths.get(bOptions.getStoreLocation(NutsStoreLocation.LOG), new String[0]);
        NutsLogConfig lc = bootOptions.getLogConfig();
        if (lc != null) {
            if (lc.getLogFileLevel() != null) {
                this.logConfig.setLogFileLevel(lc.getLogFileLevel());
            }
            if (lc.getLogTermLevel() != null) {
                this.logConfig.setLogTermLevel(lc.getLogTermLevel());
            }
            this.logConfig.setLogFileName(lc.getLogFileName());
            this.logConfig.setLogFileCount(lc.getLogFileCount());
            this.logConfig.setLogFileBase(lc.getLogFileBase());
            this.logConfig.setLogFileSize(lc.getLogFileSize());
        }
        this.out = ((DefaultNutsBootManager)ws.boot()).getModel().getSystemTerminal().err();
    }

    public NutsSession getDefaultSession() {
        return this.defaultSession;
    }

    public void setDefaultSession(NutsSession defaultSession) {
        this.defaultSession = defaultSession;
    }

    public Handler[] getHandlers() {
        if (this.extraHandlers.isEmpty()) {
            return EMPTY;
        }
        return this.extraHandlers.toArray(EMPTY);
    }

    public void removeHandler(Handler handler) {
        this.extraHandlers.remove(handler);
    }

    public void addHandler(Handler handler) {
        if (handler != null) {
            this.extraHandlers.add(handler);
        }
    }

    public Handler getTermHandler() {
        return this.consoleHandler;
    }

    public Handler getFileHandler() {
        return this.fileHandler;
    }

    public NutsLogger createLogger(String name, NutsSession session) {
        NutsLogger y = this.loaded.get(name);
        if (y == null) {
            if (session == null) {
                session = this.defaultSession;
            }
            y = new DefaultNutsLogger(this.workspace, session, name);
            this.loaded.put(name, y);
        }
        return y;
    }

    public NutsLogger createLogger(Class clazz, NutsSession session) {
        NutsLogger y = this.loaded.get(clazz.getName());
        if (y == null) {
            if (session == null) {
                session = this.defaultSession;
            }
            y = new DefaultNutsLogger(this.workspace, session, clazz);
            this.loaded.put(clazz.getName(), y);
        }
        return y;
    }

    public Level getTermLevel() {
        return this.logConfig.getLogTermLevel();
    }

    public void setTermLevel(Level level, NutsSession session) {
        if (level == null) {
            level = Level.INFO;
        }
        this.logConfig.setLogFileLevel(level);
        if (this.consoleHandler != null) {
            this.consoleHandler.setLevel(level);
        }
    }

    public Level getFileLevel() {
        return this.logConfig.getLogFileLevel();
    }

    public void setFileLevel(Level level, NutsSession session) {
        if (level == null) {
            level = Level.INFO;
        }
        this.logConfig.setLogFileLevel(level);
        if (this.fileHandler != null) {
            this.fileHandler.setLevel(level);
        }
    }

    public void updateHandlers(LogRecord record) {
        this.updateTermHandler(record);
        this.updateFileHandler(record);
    }

    public void updateFileHandler(LogRecord record) {
        if (this.fileHandler == null && this.logConfig.getLogFileLevel() != Level.OFF && this.fileHandler == null) {
            NutsSession session = NutsLogUtils.resolveSession(record, this.workspace);
            try {
                this.fileHandler = NutsLogFileHandler.create(session, this.logConfig, true, this.logFolder);
                this.fileHandler.setLevel(this.logConfig.getLogFileLevel());
            }
            catch (Exception ex) {
                Logger.getLogger(DefaultNutsLogManager.class.getName()).log(Level.FINE, "unable to create file handler", ex);
            }
        }
    }

    public void updateTermHandler(LogRecord record) {
        NutsSession session = NutsLogUtils.resolveSession(record, this.workspace);
        NutsPrintStream out = session.err();
        if (out != this.out || this.consoleHandler == null) {
            this.out = out;
            if (this.consoleHandler != null) {
                if (this.consoleHandler instanceof NutsLogConsoleHandler) {
                    ((NutsLogConsoleHandler)this.consoleHandler).setOutputStream(out, false);
                    this.consoleHandler.setLevel(this.logConfig.getLogTermLevel());
                } else {
                    this.consoleHandler.flush();
                    this.consoleHandler.setLevel(this.logConfig.getLogTermLevel());
                }
            } else {
                this.consoleHandler = new NutsLogConsoleHandler(out, false, NutsWorkspaceExt.of(this.workspace).defaultSession());
                this.consoleHandler.setLevel(this.logConfig.getLogTermLevel());
            }
        }
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }
}

