/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.log;

import java.util.logging.Handler;
import java.util.logging.Level;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.log.DefaultNutsLogModel;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsLogManager;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class DefaultNutsLogManager
implements NutsLogManager {
    private final DefaultNutsLogModel model;
    private final NutsWorkspace ws;

    public DefaultNutsLogManager(NutsWorkspace ws) {
        this.ws = ws;
        this.model = ((NutsWorkspaceExt)ws).getModel().logModel;
    }

    public Handler[] getHandlers(NutsSession session) {
        this.checkSession(session);
        return this.model.getHandlers();
    }

    public NutsLogManager removeHandler(Handler handler, NutsSession session) {
        this.checkSession(session);
        this.model.removeHandler(handler);
        return this;
    }

    public NutsLogManager addHandler(Handler handler, NutsSession session) {
        this.checkSession(session);
        this.model.addHandler(handler);
        return this;
    }

    public Handler getTermHandler(NutsSession session) {
        this.checkSession(session);
        return this.model.getTermHandler();
    }

    public Handler getFileHandler(NutsSession session) {
        this.checkSession(session);
        return this.model.getFileHandler();
    }

    public NutsLogger createLogger(String name, NutsSession session) {
        this.checkSession(session);
        return this.model.createLogger(name, session);
    }

    public NutsLogger createLogger(Class clazz, NutsSession session) {
        this.checkSession(session);
        return this.model.createLogger(clazz, session);
    }

    public Level getTermLevel(NutsSession session) {
        this.checkSession(session);
        return this.model.getTermLevel();
    }

    public NutsLogManager setTermLevel(Level level, NutsSession session) {
        this.checkSession(session);
        this.model.setTermLevel(level, session);
        return this;
    }

    public Level getFileLevel(NutsSession session) {
        this.checkSession(session);
        return this.model.getFileLevel();
    }

    public NutsLogManager setFileLevel(Level level, NutsSession session) {
        this.checkSession(session);
        this.model.setFileLevel(level, session);
        return this;
    }

    private void checkSession(NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), session);
    }

    public DefaultNutsLogModel getModel() {
        return this.model;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

