/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.lock;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLock;
import net.thevpc.nuts.NutsLockAcquireException;
import net.thevpc.nuts.NutsLockException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.runtime.standalone.lock.AbstractNutsLocks;
import net.thevpc.nuts.runtime.standalone.lock.DefaultFileNutsLock;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsLocks
extends AbstractNutsLocks {
    public DefaultNutsLocks(NutsSession ws) {
        super(ws);
    }

    public NutsLock create() {
        this.checkSession();
        Object s = this.getSource();
        Object lr = this.getResource();
        Path lrPath = null;
        if (lr == null) {
            if (s == null) {
                throw new NutsLockException(this.getSession(), NutsMessage.cstyle((String)"unsupported lock for null", (Object[])new Object[0]), null, null);
            }
            Path p = this.toPath(s);
            if (p == null) {
                throw new NutsLockException(this.getSession(), NutsMessage.cstyle((String)"unsupported lock for %s", (Object[])new Object[]{s.getClass().getName()}), null, s);
            }
            lrPath = p.resolveSibling(p.getFileName().toString() + ".lock");
        } else {
            lrPath = this.toPath(lr);
            if (lrPath == null) {
                throw new NutsLockException(this.getSession(), NutsMessage.cstyle((String)"unsupported lock %s", (Object[])new Object[]{lr.getClass().getName()}), lr, s);
            }
        }
        return new DefaultFileNutsLock(lrPath, s, this.getSession());
    }

    public <T> T call(Callable<T> runnable) {
        this.checkSession();
        NutsLock lock = this.create();
        if (!lock.tryLock()) {
            throw new NutsLockAcquireException(this.getSession(), null, this.getResource(), (Object)lock);
        }
        T value = null;
        try {
            value = runnable.call();
        }
        catch (Exception e) {
            if (e instanceof NutsException) {
                throw (NutsException)e;
            }
            throw new NutsException(this.getSession(), NutsMessage.plain((String)"call failed"), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return value;
    }

    public <T> T call(Callable<T> runnable, long time, TimeUnit unit) {
        this.checkSession();
        NutsLock lock = this.create();
        boolean b = false;
        try {
            b = lock.tryLock(time, unit);
        }
        catch (InterruptedException e) {
            throw new NutsLockAcquireException(this.getSession(), null, this.getResource(), (Object)lock);
        }
        if (!b) {
            throw new NutsLockAcquireException(this.getSession(), null, this.getResource(), (Object)lock);
        }
        T value = null;
        try {
            value = runnable.call();
        }
        catch (Exception e) {
            if (e instanceof NutsException) {
                throw (NutsException)e;
            }
            throw new NutsException(this.getSession(), NutsMessage.plain((String)"call failed"), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return value;
    }

    public void run(Runnable runnable) {
        this.checkSession();
        NutsLock lock = this.create();
        if (!lock.tryLock()) {
            throw new NutsLockAcquireException(this.getSession(), null, this.getResource(), (Object)lock);
        }
        try {
            runnable.run();
        }
        catch (Exception e) {
            if (e instanceof NutsException) {
                throw (NutsException)e;
            }
            throw new NutsException(this.getSession(), NutsMessage.plain((String)"call failed"), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public void run(Runnable runnable, long time, TimeUnit unit) {
        this.checkSession();
        NutsLock lock = this.create();
        boolean b = false;
        try {
            b = lock.tryLock(time, unit);
        }
        catch (InterruptedException e) {
            throw new NutsLockAcquireException(this.getSession(), null, this.getResource(), (Object)lock);
        }
        if (!b) {
            throw new NutsLockAcquireException(this.getSession(), null, this.getResource(), (Object)lock);
        }
        try {
            runnable.run();
        }
        catch (Exception e) {
            if (e instanceof NutsException) {
                throw (NutsException)e;
            }
            throw new NutsException(this.getSession(), NutsMessage.cstyle((String)"lock action failed", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    private Path toPath(Object lockedObject) {
        if (lockedObject instanceof NutsId) {
            NutsId nid = (NutsId)lockedObject;
            String face = nid.getFace();
            if (NutsBlankable.isBlank((String)face)) {
                face = "content";
            }
            return this.getSession().locations().setSession(this.getSession()).getStoreLocation((NutsId)lockedObject, NutsStoreLocation.RUN).resolve("nuts-" + face).toFile();
        }
        if (lockedObject instanceof Path) {
            return (Path)lockedObject;
        }
        if (lockedObject instanceof NutsPath) {
            return ((NutsPath)lockedObject).toFile();
        }
        if (lockedObject instanceof File) {
            return ((File)lockedObject).toPath();
        }
        if (lockedObject instanceof String) {
            return Paths.get((String)lockedObject, new String[0]);
        }
        return null;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

