/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDefaultStreamMetadata;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStreamMetadata;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyled;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTmp;

public class NutsStreamOrPath {
    private final Object value;
    private final Type type;
    private final boolean disposable;
    private final NutsSession session;

    private NutsStreamOrPath(Object value, Type type, boolean disposable, NutsSession session) {
        this.value = value;
        this.type = type;
        this.disposable = disposable;
        this.session = session;
        if (disposable) {
            if (value instanceof NutsPath && ((NutsPath)value).isFile()) {
                return;
            }
            throw new IllegalArgumentException("not disposable");
        }
    }

    public static NutsStreamOrPath ofSpecial(Object value, Type type, NutsSession session) {
        return new NutsStreamOrPath(value, type, false, session);
    }

    public static NutsStreamOrPath ofDisposable(NutsPath value) {
        return new NutsStreamOrPath(value, Type.PATH, true, value.getSession());
    }

    public static NutsStreamOrPath of(File value, NutsSession session) {
        return NutsStreamOrPath.of(NutsPath.of((File)value, (NutsSession)session));
    }

    public static NutsStreamOrPath of(URL value, NutsSession session) {
        return NutsStreamOrPath.of(NutsPath.of((URL)value, (NutsSession)session));
    }

    public static NutsStreamOrPath of(Path value, NutsSession session) {
        return NutsStreamOrPath.of(NutsPath.of((Path)value, (NutsSession)session));
    }

    public static NutsStreamOrPath of(String value, NutsSession session) {
        return NutsStreamOrPath.of(NutsPath.of((String)value, (NutsSession)session));
    }

    public static NutsStreamOrPath of(NutsPath value) {
        return new NutsStreamOrPath(value, Type.PATH, false, value.getSession());
    }

    public static NutsStreamOrPath of(NutsPrintStream value) {
        return new NutsStreamOrPath(value, Type.NUTS_PRINT_STREAM, false, value.getSession());
    }

    public static NutsStreamOrPath ofAnyOutputOrErr(Object value, NutsSession session) {
        NutsStreamOrPath a = NutsStreamOrPath.ofAnyOutputOrNull(value, session);
        if (a != null) {
            return a;
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported output from type %s", (Object[])new Object[]{value.getClass().getName()}));
    }

    public static NutsStreamOrPath ofAnyInputOrErr(Object value, NutsSession session) {
        NutsStreamOrPath a = NutsStreamOrPath.ofAnyInputOrNull(value, session);
        if (a != null) {
            return a;
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported input from type %s", (Object[])new Object[]{value.getClass().getName()}));
    }

    public static NutsStreamOrPath ofAnyOutputOrNull(Object value, NutsSession session) {
        if (value == null) {
            return null;
        }
        if (value instanceof ByteArrayOutputStream) {
            return NutsStreamOrPath.of((ByteArrayOutputStream)value, session);
        }
        if (value instanceof byte[]) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            try {
                b.write((byte[])value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return NutsStreamOrPath.of(b, session);
        }
        if (value instanceof NutsPrintStream) {
            return NutsStreamOrPath.of((NutsPrintStream)value);
        }
        if (value instanceof OutputStream) {
            return NutsStreamOrPath.of((OutputStream)value, session);
        }
        if (value instanceof NutsPath) {
            return NutsStreamOrPath.of((NutsPath)value);
        }
        if (value instanceof File) {
            return NutsStreamOrPath.of((File)value, session);
        }
        if (value instanceof URL) {
            return NutsStreamOrPath.of((URL)value, session);
        }
        if (value instanceof Path) {
            return NutsStreamOrPath.of((Path)value, session);
        }
        return null;
    }

    public static NutsStreamOrPath ofAnyInputOrNull(Object value, NutsSession session) {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return NutsStreamOrPath.of(new ByteArrayInputStream((byte[])value), session);
        }
        if (value instanceof InputStream) {
            return NutsStreamOrPath.of((InputStream)value, session);
        }
        if (value instanceof NutsPath) {
            return NutsStreamOrPath.of((NutsPath)value);
        }
        if (value instanceof File) {
            return NutsStreamOrPath.of((File)value, session);
        }
        if (value instanceof URL) {
            return NutsStreamOrPath.of((URL)value, session);
        }
        if (value instanceof Path) {
            return NutsStreamOrPath.of((Path)value, session);
        }
        if (value instanceof String) {
            return NutsStreamOrPath.of((String)value, session);
        }
        return null;
    }

    public static NutsStreamOrPath of(InputStream value, NutsSession session) {
        return new NutsStreamOrPath(value, Type.INPUT_STREAM, false, session);
    }

    public static NutsStreamOrPath of(OutputStream value, NutsSession session) {
        return new NutsStreamOrPath(value, Type.OUTPUT_STREAM, false, session);
    }

    public boolean dispose() {
        if (this.disposable) {
            try {
                Path f = ((NutsPath)this.value).toFile();
                if (Files.isRegularFile(f, new LinkOption[0])) {
                    Files.delete(f);
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isMultiRead() {
        return this.value instanceof NutsPath;
    }

    public NutsStreamOrPath toMultiRead(NutsSession session) {
        if (this.value instanceof NutsPath) {
            return this;
        }
        return this.toDisposable(session);
    }

    public NutsStreamOrPath toDisposable(NutsSession session) {
        String name = this.getName();
        Path tempFile = NutsTmp.of((NutsSession)session).createTempFile(name).toFile();
        NutsCp copy = NutsCp.of((NutsSession)session);
        if (this.type == Type.PATH) {
            copy.from((NutsPath)this.value);
        } else {
            copy.from((InputStream)this.value);
        }
        copy.to(tempFile);
        copy.run();
        return NutsStreamOrPath.ofDisposable(NutsPath.of((Path)tempFile, (NutsSession)session));
    }

    public boolean isDisposable() {
        return this.disposable;
    }

    public NutsPath getPath() {
        return (NutsPath)this.value;
    }

    public InputStream getInputStream() {
        switch (this.type) {
            case PATH: {
                return this.getPath().getInputStream();
            }
            case INPUT_STREAM: {
                return (InputStream)this.value;
            }
        }
        throw new IllegalArgumentException("no an input stream");
    }

    public OutputStream getOutputStream() {
        switch (this.type) {
            case PATH: {
                return this.getPath().getOutputStream();
            }
            case OUTPUT_STREAM: {
                return (OutputStream)this.value;
            }
            case NUTS_PRINT_STREAM: {
                return ((NutsPrintStream)this.value).asOutputStream();
            }
        }
        throw new IllegalArgumentException("no an output stream");
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPath() {
        return this.getType() == Type.PATH;
    }

    public NutsStreamMetadata getStreamMetaData() {
        switch (this.type) {
            case PATH: {
                return this.getPath().getStreamMetadata();
            }
            case INPUT_STREAM: 
            case OUTPUT_STREAM: {
                NutsStreamMetadata q = NutsStreamMetadata.resolve((Object)this.value);
                if (q == null) {
                    NutsTextStyled str = null;
                    str = this.value instanceof ByteArrayInputStream ? NutsTexts.of((NutsSession)this.session).ofStyled("<memory-buffer>", NutsTextStyle.path()) : (this.value instanceof ByteArrayOutputStream ? NutsTexts.of((NutsSession)this.session).ofStyled("<memory-buffer>", NutsTextStyle.path()) : (this.value instanceof byte[] ? NutsTexts.of((NutsSession)this.session).ofStyled("<memory-buffer>", NutsTextStyle.path()) : NutsTexts.of((NutsSession)this.session).ofStyled(this.value.toString(), NutsTextStyle.path())));
                    q = new NutsDefaultStreamMetadata(str.filteredText(), (NutsString)str, -1L, null, null);
                }
                return q;
            }
            case NUTS_PRINT_STREAM: {
                NutsPrintStream q = (NutsPrintStream)this.value;
                return q.getStreamMetadata();
            }
            case DESCRIPTOR: {
                NutsDescriptor q = (NutsDescriptor)this.value;
                NutsId id = q.getId();
                Object str = id != null ? id.format() : NutsTexts.of((NutsSession)this.session).ofStyled("<empty-descriptor>", NutsTextStyle.path());
                return new NutsDefaultStreamMetadata(str.filteredText(), str, -1L, null, null);
            }
        }
        return new NutsDefaultStreamMetadata(this.value.toString(), (NutsString)NutsTexts.of((NutsSession)this.session).ofStyled(this.value.toString(), NutsTextStyle.path()), -1L, null, null);
    }

    public boolean isInputStream() {
        return this.getType() == Type.INPUT_STREAM;
    }

    public boolean isOutputStream() {
        return this.getType() == Type.OUTPUT_STREAM;
    }

    public String getName() {
        if (this.isPath()) {
            return this.getPath().getName();
        }
        if (this.value instanceof InputStream) {
            return NutsStreamMetadata.of((Object)((InputStream)this.value)).getName();
        }
        return this.value.toString();
    }

    public boolean isDirectory() {
        return this.isPath() && this.getPath().isDirectory();
    }

    public NutsStreamOrPath[] list() {
        if (this.isPath()) {
            NutsPath p = this.getPath();
            return (NutsStreamOrPath[])p.list().map(NutsFunction.of(NutsStreamOrPath::of, (String)"NutsStreamOrPath::of")).toArray(NutsStreamOrPath[]::new);
        }
        return new NutsStreamOrPath[0];
    }

    public Type getType() {
        return this.type;
    }

    public long getContentLength() {
        if (this.isPath()) {
            return this.getPath().getContentLength();
        }
        return this.getStreamMetaData().getContentLength();
    }

    public NutsStreamOrPath setKindType(String s) {
        if (this.isPath()) {
            return NutsStreamOrPath.of(this.getPath().setUserKind(s));
        }
        if (this.isInputStream()) {
            NutsStreamMetadata md = this.getStreamMetaData();
            md.setUserKind(s);
            return this;
        }
        return this;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static enum Type {
        PATH,
        INPUT_STREAM,
        OUTPUT_STREAM,
        NUTS_PRINT_STREAM,
        DESCRIPTOR;

    }
}

