/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.thevpc.nuts.runtime.standalone.io.util.NonBlockingInputStream;
import net.thevpc.nuts.runtime.standalone.io.util.StopMonitor;

public class MultiPipeThread
extends Thread
implements StopMonitor {
    private final Object lock = new Object();
    private boolean requestStop = false;
    private boolean stopped = false;
    private final Map<String, PipeInfo> list = new HashMap<String, PipeInfo>();
    private String[] ids = null;

    public MultiPipeThread(String name) {
        super(name);
    }

    public String add(String name, NonBlockingInputStream in, OutputStream out) {
        String id = UUID.randomUUID().toString();
        this.list.put(id, new PipeInfo(id, name, in, out));
        return id;
    }

    @Override
    public boolean shouldStop() {
        return this.requestStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        this.requestStop = true;
        if (!this.stopped) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String[] getIds() {
        if (this.ids == null) {
            this.ids = this.list.keySet().toArray(new String[this.list.size()]);
        }
        return this.ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] bytes = new byte[10240];
            while (!this.shouldStop()) {
                for (String s : this.getIds()) {
                    PipeInfo p = this.list.get(s);
                    if (p.in.hasMoreBytes()) {
                        int count = p.in.readNonBlocking(bytes);
                        if (count <= 0) continue;
                        PipeInfo pipeInfo = p;
                        pipeInfo.pipedBytesCount = pipeInfo.pipedBytesCount + (long)count;
                        p.out.write(bytes, 0, count);
                        p.out.flush();
                        continue;
                    }
                    p.out.close();
                    this.list.remove(s);
                    this.ids = null;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.stopped = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private static class PipeInfo {
        private final String id;
        private final String name;
        private final NonBlockingInputStream in;
        private final OutputStream out;
        private long pipedBytesCount = 0L;

        public PipeInfo(String id, String name, NonBlockingInputStream in, OutputStream out) {
            this.id = id;
            this.name = name;
            this.in = in;
            this.out = out;
        }
    }
}

