/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.IOException;
import java.io.InputStream;
import net.thevpc.nuts.NutsStreamMetadata;
import net.thevpc.nuts.NutsStreamMetadataAware;
import net.thevpc.nuts.runtime.standalone.io.util.InterruptException;
import net.thevpc.nuts.runtime.standalone.io.util.Interruptible;

public class InputStreamExt
extends InputStream
implements NutsStreamMetadataAware,
Interruptible {
    private InputStream in;
    private Runnable onClose;
    private boolean interrupted;

    public InputStreamExt(InputStream in, Runnable onClose) {
        this.in = in;
        this.onClose = onClose;
    }

    @Override
    public void interrupt() throws InterruptException {
        this.interrupted = true;
    }

    @Override
    public int read() throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        return this.in.read();
    }

    @Override
    public void close() throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        this.in.close();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    @Override
    public int available() throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        return this.in.available();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        return this.in.read(b, off, len);
    }

    public NutsStreamMetadata getStreamMetadata() {
        return NutsStreamMetadata.of((Object)this.in);
    }
}

