/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.IOException;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.DefaultNutsInstalledRepository;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class FolderObjectIterator<T>
extends NutsIteratorBase<T> {
    private final Stack<PathAndDepth> stack = new Stack();
    private final Predicate<T> filter;
    private final NutsSession session;
    private final FolderIteratorModel<T> model;
    private final NutsLogger LOG;
    private final String name;
    private final NutsPath folder;
    private T last;
    private NutsPath lastPath;
    private long visitedFoldersCount;
    private long visitedFilesCount;
    private final int maxDepth;

    public FolderObjectIterator(String name, NutsPath folder, Predicate<T> filter, int maxDepth, NutsSession session, FolderIteratorModel<T> model) {
        this.session = session;
        this.filter = filter;
        this.model = model;
        this.name = name;
        this.maxDepth = maxDepth;
        if (folder == null) {
            throw new NullPointerException("could not iterate over null folder");
        }
        if (session == null) {
            throw new NullPointerException("null session");
        }
        this.folder = folder;
        this.stack.push(new PathAndDepth(folder, 0));
        this.LOG = NutsLogger.of(DefaultNutsInstalledRepository.class, (NutsSession)session);
    }

    public NutsElement describe(NutsElements elems) {
        return elems.ofObject().set("type", "ScanPath").set("name", this.name).set("path", NutsDescribables.resolveOrDestruct((Object)this.folder, (NutsElements)elems)).set("maxDepth", this.maxDepth).set("filter", NutsDescribables.resolveOrDestruct(this.filter, (NutsElements)elems)).build();
    }

    public boolean hasNext() {
        this.last = null;
        while (!this.stack.isEmpty()) {
            PathAndDepth file = this.stack.pop();
            if (file.path.isDirectory()) {
                boolean deep;
                this.session.getTerminal().printProgress("%-8s %s", new Object[]{"browse", file.path.toCompressedForm()});
                ++this.visitedFoldersCount;
                boolean bl = deep = this.maxDepth < 0 || file.depth < this.maxDepth;
                if (!file.path.isDirectory()) continue;
                try {
                    file.path.list().filter(pathname -> {
                        try {
                            return deep && pathname.isDirectory() || this.model.isObjectFile((NutsPath)pathname);
                        }
                        catch (Exception ex) {
                            NutsLoggerOp.of(FolderObjectIterator.class, (NutsSession)this.session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"unable to test desk file {0}", (Object[])new Object[]{pathname}));
                            return false;
                        }
                    }, "isDirectory || isObjectFile").forEach(item -> {
                        if (item.isDirectory()) {
                            if (this.maxDepth < 0 || file.depth < this.maxDepth) {
                                this.stack.push(new PathAndDepth((NutsPath)item, file.depth + 1));
                            }
                        } else {
                            this.stack.push(new PathAndDepth((NutsPath)item, file.depth));
                        }
                    });
                }
                catch (Exception ex) {
                    this.LOG.with().error((Throwable)ex).log(NutsMessage.jstyle((String)"unable to parse {0}", (Object[])new Object[]{file.path}));
                }
                continue;
            }
            ++this.visitedFilesCount;
            Object t = null;
            try {
                t = this.model.parseObject(file.path, this.session);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (t == null || this.filter != null && !this.filter.test(t)) continue;
            this.last = t;
            this.lastPath = file.path;
            break;
        }
        return this.last != null;
    }

    public T next() {
        T ret = this.last;
        this.last = null;
        this.lastPath = null;
        return ret;
    }

    public void remove() {
        if (this.last == null) {
            throw new NutsUnsupportedOperationException(this.session, NutsMessage.cstyle((String)"unsupported remove", (Object[])new Object[0]));
        }
        this.model.remove(this.last, this.lastPath, this.session);
    }

    public long getVisitedFoldersCount() {
        return this.visitedFoldersCount;
    }

    public long getVisitedFilesCount() {
        return this.visitedFilesCount;
    }

    public String toString() {
        return "FolderIterator<" + this.name + ">(folder=" + this.folder + "; depth=" + this.maxDepth + ')';
    }

    private static class PathAndDepth {
        private final NutsPath path;
        private final int depth;

        public PathAndDepth(NutsPath path, int depth) {
            this.path = path;
            this.depth = depth;
        }
    }

    public static interface FolderIteratorModel<T> {
        default public void remove(T object, NutsPath objectPath, NutsSession session) throws NutsExecutionException {
        }

        public boolean isObjectFile(NutsPath var1);

        public T parseObject(NutsPath var1, NutsSession var2) throws IOException;
    }
}

