/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDefaultStreamMetadata;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsStreamMetadata;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTmp;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.terminal.NutsTerminalModeOp;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamExt;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamMetadataAwareImpl;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamTee;
import net.thevpc.nuts.runtime.standalone.io.util.Interruptible;
import net.thevpc.nuts.runtime.standalone.io.util.NutsStreamOrPath;
import net.thevpc.nuts.runtime.standalone.repository.index.CacheDB;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAwarePrintWriter;
import net.thevpc.nuts.runtime.standalone.text.RawOutputStream;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.DoWhenExist;
import net.thevpc.nuts.runtime.standalone.util.DoWhenNotExists;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util.PathInfo;
import net.thevpc.nuts.runtime.standalone.xtra.digest.NutsDigestUtils;
import net.thevpc.nuts.runtime.standalone.xtra.download.DefaultHttpTransportComponent;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDB;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableFile;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;
import net.thevpc.nuts.spi.NutsTransportComponent;
import net.thevpc.nuts.spi.NutsTransportConnection;

public class CoreIOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final String MIME_TYPE_SHA1 = "text/sha-1";
    public static String newLineString = null;

    @Deprecated
    public static PrintWriter toPrintWriter(Writer writer, NutsSystemTerminalBase term, NutsSession session) {
        if (writer == null) {
            return null;
        }
        if (writer instanceof ExtendedFormatAware && writer instanceof PrintWriter) {
            return (PrintWriter)writer;
        }
        ExtendedFormatAwarePrintWriter s = new ExtendedFormatAwarePrintWriter(writer, term, session);
        NutsWorkspaceUtils.setSession(s, session);
        return s;
    }

    @Deprecated
    public static PrintWriter toPrintWriter(OutputStream writer, NutsSystemTerminalBase term, NutsSession session) {
        if (writer == null) {
            return null;
        }
        ExtendedFormatAwarePrintWriter s = new ExtendedFormatAwarePrintWriter(writer, term, session);
        NutsWorkspaceUtils.setSession(s, session);
        return s;
    }

    @Deprecated
    public static OutputStream convertOutputStream(OutputStream out, NutsTerminalMode expected, NutsSystemTerminalBase term, NutsSession session) {
        ExtendedFormatAware a = CoreIOUtils.convertOutputStreamToExtendedFormatAware(out, expected, term, session);
        return (OutputStream)((Object)a);
    }

    @Deprecated
    public static ExtendedFormatAware convertOutputStreamToExtendedFormatAware(OutputStream out, NutsTerminalMode expected, NutsSystemTerminalBase term, NutsSession session) {
        if (out == null) {
            return null;
        }
        ExtendedFormatAware aw = null;
        aw = out instanceof ExtendedFormatAware ? (ExtendedFormatAware)((Object)out) : new RawOutputStream(out, term, session);
        switch (expected) {
            case INHERITED: {
                return aw.convert(NutsTerminalModeOp.NOP);
            }
            case FORMATTED: {
                return aw.convert(NutsTerminalModeOp.FORMAT);
            }
            case FILTERED: {
                return aw.convert(NutsTerminalModeOp.FILTER);
            }
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported terminal mode %s", (Object[])new Object[]{expected}));
    }

    public static String resolveRepositoryPath(NutsAddRepositoryOptions options, Path rootFolder, NutsSession session) {
        NutsWorkspace ws = session.getWorkspace();
        String loc = options.getLocation();
        String goodName = options.getName();
        if (NutsBlankable.isBlank((String)goodName)) {
            goodName = options.getConfig().getName();
        }
        if (NutsBlankable.isBlank((String)goodName)) {
            goodName = options.getName();
        }
        if (NutsBlankable.isBlank((String)goodName)) {
            goodName = options.isTemporary() ? "temp-" + UUID.randomUUID() : "repo-" + UUID.randomUUID();
        }
        if (NutsBlankable.isBlank((String)loc)) {
            if (options.isTemporary()) {
                if (NutsBlankable.isBlank((String)goodName)) {
                    goodName = "temp";
                }
                if (goodName.length() < 3) {
                    goodName = goodName + "-repo";
                }
                loc = NutsTmp.of((NutsSession)session).createTempFolder(goodName + "-").toString();
            } else if (NutsBlankable.isBlank((String)loc)) {
                if (NutsBlankable.isBlank((String)goodName)) {
                    goodName = CoreNutsUtils.randomColorName() + "-repo";
                }
                loc = goodName;
            }
        }
        return NutsPath.of((String)loc, (NutsSession)session).toAbsolute(rootFolder.toString()).toString();
    }

    public static NutsPrintStream resolveOut(NutsSession session) {
        return session.getTerminal() == null ? NutsPrintStream.ofNull((NutsSession)session) : session.getTerminal().out();
    }

    public static void copy(Reader in, Writer out, NutsSession session) {
        CoreIOUtils.copy(in, out, 1024, session);
    }

    public static long copy(InputStream in, OutputStream out, NutsSession session) {
        return CoreIOUtils.copy(in, out, 1024, session);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, NutsSession session) {
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        try {
            int len;
            while ((len = in.read(buffer)) > 0) {
                count += (long)len;
                out.write(buffer, 0, len);
            }
            return len;
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }

    public static void copy(Reader in, Writer out, int bufferSize, NutsSession session) {
        char[] buffer = new char[bufferSize];
        try {
            int len;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(InputStream is, boolean close, NutsSession session) {
        String string;
        block6: {
            try {
                byte[] bytes = CoreIOUtils.loadByteArray(is, session);
                string = new String(bytes);
                if (is == null || !close) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null && close) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NutsIOException(session, (Throwable)ex);
                }
            }
            is.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(Reader is, boolean close, NutsSession session) {
        String string;
        block6: {
            try {
                char[] bytes = CoreIOUtils.loadCharArray(is, session);
                string = new String(bytes);
                if (is == null || !close) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null && close) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NutsIOException(session, (Throwable)ex);
                }
            }
            is.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] loadCharArray(Reader r, NutsSession session) {
        try (CharArrayWriter out = null;){
            out = new CharArrayWriter();
            CoreIOUtils.copy(r, out, session);
            out.flush();
            char[] cArray = out.toCharArray();
            return cArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadByteArray(InputStream r, NutsSession session) {
        byte[] byArray;
        block6: {
            ByteArrayOutputStream out = null;
            try {
                out = new ByteArrayOutputStream();
                CoreIOUtils.copy(r, out, session);
                out.flush();
                byArray = out.toByteArray();
                if (out == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NutsIOException(session, (Throwable)ex);
                }
            }
            out.close();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadByteArray(InputStream r, boolean close, NutsSession session) {
        byte[] byArray;
        block8: {
            ByteArrayOutputStream out = null;
            try {
                out = new ByteArrayOutputStream();
                CoreIOUtils.copy(r, out, session);
                out.flush();
                byArray = out.toByteArray();
                if (out == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (r != null && close) {
                        r.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NutsIOException(session, (Throwable)ex);
                }
            }
            out.close();
        }
        if (r != null && close) {
            r.close();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadByteArray(InputStream stream, int maxSize, boolean close, NutsSession session) {
        try {
            try {
                if (maxSize > 0) {
                    int count;
                    ByteArrayOutputStream to = new ByteArrayOutputStream();
                    byte[] bytes = new byte[Math.max(maxSize, 10240)];
                    int all = 0;
                    while ((count = stream.read(bytes)) > 0) {
                        if (all + count < maxSize) {
                            to.write(bytes, 0, count);
                            all += count;
                            continue;
                        }
                        int count2 = maxSize - all;
                        to.write(bytes, 0, count2);
                        all += count2;
                        break;
                    }
                    byte[] byArray2 = to.toByteArray();
                    return byArray2;
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                CoreIOUtils.copy(stream, os, close, true, session);
                byte[] byArray = os.toByteArray();
                return byArray;
            }
            finally {
                if (close) {
                    stream.close();
                }
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static long copy(InputStream from, OutputStream to, boolean closeInput, boolean closeOutput, NutsSession session) {
        byte[] bytes = new byte[1024];
        long all = 0L;
        try {
            try {
                long l;
                block11: {
                    try {
                        int count;
                        while ((count = from.read(bytes)) > 0) {
                            to.write(bytes, 0, count);
                            all += (long)count;
                        }
                        l = all;
                        if (!closeInput) break block11;
                    }
                    catch (Throwable throwable) {
                        if (closeInput) {
                            from.close();
                        }
                        throw throwable;
                    }
                    from.close();
                }
                return l;
            }
            finally {
                if (closeOutput) {
                    to.close();
                }
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }

    public static void delete(NutsSession session, File file) {
        CoreIOUtils.delete(session, file.toPath());
    }

    public static void delete(final NutsSession session, Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        if (Files.isRegularFile(file, new LinkOption[0])) {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                return;
            }
        }
        final int[] deleted = new int[]{0, 0, 0};
        final NutsLogger LOG = session == null ? null : NutsLogger.of(CoreIOUtils.class, (NutsSession)session);
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                        if (LOG != null) {
                            LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"delete file {0}", (Object[])new Object[]{file}));
                        }
                        deleted[0] = deleted[0] + 1;
                    }
                    catch (IOException e) {
                        if (LOG != null) {
                            LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"failed deleting file : {0}", (Object[])new Object[]{file}));
                        }
                        deleted[2] = deleted[2] + 1;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    try {
                        Files.delete(dir);
                        if (LOG != null) {
                            LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"delete folder {0}", (Object[])new Object[]{dir}));
                        }
                        deleted[1] = deleted[1] + 1;
                    }
                    catch (IOException e) {
                        if (LOG != null) {
                            LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"failed deleting folder: {0}", (Object[])new Object[]{dir}));
                        }
                        deleted[2] = deleted[2] + 1;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }

    public static String getFileExtension(String s) {
        int i = s.lastIndexOf(46);
        if (i == 0) {
            return s.substring(1);
        }
        if (i > 0) {
            if (i < s.length() - 1) {
                return s.substring(i + 1);
            }
            return "";
        }
        return "";
    }

    public static String getFileExtension(String s, boolean longest, boolean includeDot) {
        int i;
        int n = i = longest ? s.indexOf(46) : s.lastIndexOf(46);
        if (i == 0) {
            return includeDot ? s : s.substring(1);
        }
        if (i > 0) {
            if (i < s.length() - 1) {
                return s.substring(includeDot ? i : i + 1);
            }
            return "";
        }
        return "";
    }

    public static String buildUrl(String url, String path) {
        if (!url.endsWith("/")) {
            if (path.startsWith("/")) {
                return url + path;
            }
            return url + "/" + path;
        }
        if (path.startsWith("/")) {
            return url + path.substring(1);
        }
        return url + path;
    }

    public static boolean isURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static NutsTransportConnection getHttpClientFacade(NutsSession session, String url) {
        NutsTransportComponent best = (NutsTransportComponent)session.extensions().createSupported(NutsTransportComponent.class, false, (Object)url);
        if (best == null) {
            best = DefaultHttpTransportComponent.INSTANCE;
        }
        return best.open(url);
    }

    public static String urlEncodeString(String s, NutsSession session) {
        if (s == null || s.trim().length() == 0) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new NutsIOException(session, (Throwable)e);
        }
    }

    public static Path resolveLocalPathFromURL(URL url) {
        try {
            return new File(url.toURI()).toPath();
        }
        catch (URISyntaxException e) {
            return new File(url.getPath()).toPath();
        }
    }

    public static URL resolveURLFromResource(Class cls, String urlPath, NutsSession session) {
        if (!urlPath.startsWith("/")) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to resolve url from %s", (Object[])new Object[]{urlPath}));
        }
        URL url = cls.getResource(urlPath);
        String urlFile = url.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                if (!jarFile.startsWith("/")) {
                    jarFile = "/" + jarFile;
                }
                try {
                    return new URL("file:" + jarFile);
                }
                catch (IOException ex2) {
                    throw new NutsIOException(session, (Throwable)ex2);
                }
            }
        }
        String encoded = CoreIOUtils.encodePath(urlPath, session);
        String url_tostring = url.toString();
        if (url_tostring.endsWith(encoded)) {
            try {
                return new URL(url_tostring.substring(0, url_tostring.length() - encoded.length()));
            }
            catch (IOException ex) {
                throw new NutsIOException(session, (Throwable)ex);
            }
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to resolve url from %s", (Object[])new Object[]{urlPath}));
    }

    private static String encodePath(String path, NutsSession session) {
        StringTokenizer st = new StringTokenizer(path, "/", true);
        StringBuilder encoded = new StringBuilder();
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.equals("/")) {
                encoded.append(t);
                continue;
            }
            try {
                encoded.append(URLEncoder.encode(t, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to encode %s", (Object[])new Object[]{t}), (Throwable)ex);
            }
        }
        return encoded.toString();
    }

    public static File resolveLocalFileFromResource(Class cls, String url, NutsSession session) {
        return CoreIOUtils.resolveLocalFileFromURL(CoreIOUtils.resolveURLFromResource(cls, url, session));
    }

    public static File resolveLocalFileFromURL(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    public static byte[] charsToBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    public static char[] bytesToChars(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        CharBuffer charBuffer = StandardCharsets.UTF_8.decode(byteBuffer);
        char[] chars = Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        return chars;
    }

    public static InputStream getCachedUrlWithSHA1(String path, String sourceTypeName, boolean ignoreSha1NotFound, NutsSession session) {
        NutsPath p;
        String cachedID;
        long lastModified;
        NutsPath p2;
        String cachedID2;
        String sha1;
        NutsPath urlContent;
        block4: {
            NutsPath cacheBasePath = session.locations().getStoreLocation(session.getWorkspace().getRuntimeId(), NutsStoreLocation.CACHE);
            urlContent = cacheBasePath.resolve("urls-content");
            sha1 = null;
            try {
                ByteArrayOutputStream t = new ByteArrayOutputStream();
                NutsCp.of((NutsSession)session).from(path + ".sha1").to((OutputStream)t).run();
                sha1 = t.toString().trim();
            }
            catch (NutsIOException ex) {
                if (ignoreSha1NotFound) break block4;
                throw ex;
            }
        }
        NanoDB cachedDB = CacheDB.of(session);
        NanoDBTableFile<CachedURL> cacheTable = cachedDB.tableBuilder(CachedURL.class, session).setNullable(false).addAllFields().addIndices("url").getOrCreate();
        CachedURL old = cacheTable.findByIndex("url", path, session).findFirst().orElse(null);
        if (sha1 != null && old != null && sha1.equalsIgnoreCase(old.sha1) && (cachedID2 = old.path) != null && (p2 = urlContent.resolve(cachedID2)).exists()) {
            return p2.getInputStream();
        }
        NutsPath header = NutsPath.of((String)path, (NutsSession)session);
        long size = header.getContentLength();
        Instant lastModifiedInstant = header.getLastModifiedInstant();
        long l = lastModified = lastModifiedInstant == null ? 0L : lastModifiedInstant.toEpochMilli();
        if (sha1 == null && old != null && old.lastModified != -1L && old.lastModified == lastModified && old != null && old.size == size && (cachedID = old.path) != null && (p = urlContent.resolve(cachedID)).exists()) {
            return p.getInputStream();
        }
        String s = UUID.randomUUID().toString();
        NutsPath outPath = urlContent.resolve(s + "~");
        urlContent.mkdirs();
        OutputStream p3 = outPath.getOutputStream();
        long finalLastModified = lastModified;
        InputStreamTee ist = new InputStreamTee(header.getInputStream(), p3, () -> {
            if (outPath.exists()) {
                long newSize;
                CachedURL ccu = new CachedURL();
                ccu.url = path;
                ccu.path = s;
                ccu.sha1 = NutsDigestUtils.evalSHA1Hex(outPath, session);
                ccu.size = newSize = outPath.getContentLength();
                ccu.lastModified = finalLastModified;
                NutsPath newLocalPath = urlContent.resolve(s);
                try {
                    Files.move(outPath.toFile(), newLocalPath.toFile(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (IOException ex) {
                    throw new NutsIOException(session, (Throwable)ex);
                }
                cacheTable.add(ccu, session);
                cacheTable.flush(session);
            }
        });
        return InputStreamMetadataAwareImpl.of(ist, (NutsStreamMetadata)new NutsDefaultStreamMetadata(path, (NutsString)NutsTexts.of((NutsSession)session).ofStyled(path, NutsTextStyle.path()), size, NutsPath.of((String)path, (NutsSession)session).getContentType(), sourceTypeName));
    }

    public static void storeProperties(Map<String, String> props, OutputStream out, boolean sort, NutsSession session) {
        CoreIOUtils.storeProperties(props, new OutputStreamWriter(out), sort, session);
    }

    public static void storeProperties(Map<String, String> props, Writer w, boolean sort, NutsSession session) {
        try {
            Set<String> keys = props.keySet();
            if (sort) {
                keys = new TreeSet<String>(keys);
            }
            for (String key : keys) {
                String value = props.get(key);
                w.write(CoreIOUtils.escapePropsString(key, true));
                w.write("=");
                w.write(CoreIOUtils.escapePropsString(value, false));
                w.write("\n");
                w.flush();
            }
            w.flush();
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }

    public static String escapePropsString(String theString, boolean escapeSpace) {
        if (theString == null) {
            theString = "";
        }
        char[] chars = theString.toCharArray();
        StringBuilder buffer = new StringBuilder(chars.length);
        block9: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    continue block9;
                }
                case ' ': {
                    if (i == 0 || escapeSpace) {
                        buffer.append('\\');
                    }
                    buffer.append(' ');
                    continue block9;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block9;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block9;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block9;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block9;
                }
                default: {
                    if (c > '=' && c < '\u007f') {
                        buffer.append(c);
                        continue block9;
                    }
                    if (c < ' ' || c > '~') {
                        buffer.append('\\');
                        buffer.append('u');
                        buffer.append(NutsUtilStrings.toHexChar((int)(c >> 12 & 0xF)));
                        buffer.append(NutsUtilStrings.toHexChar((int)(c >> 8 & 0xF)));
                        buffer.append(NutsUtilStrings.toHexChar((int)(c >> 4 & 0xF)));
                        buffer.append(NutsUtilStrings.toHexChar((int)(c & 0xF)));
                        continue block9;
                    }
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static Path toPathInputSource(NutsStreamOrPath is, List<Path> tempPaths, NutsSession session) {
        if (is.isPath() && is.getPath().isFile()) {
            return is.getPath().toFile();
        }
        Path temp = NutsTmp.of((NutsSession)session).createTempFile(is.getName()).toFile();
        NutsCp a = NutsCp.of((NutsSession)session).removeOptions(new NutsPathOption[]{NutsPathOption.SAFE});
        if (is.isPath()) {
            a.from(is.getPath());
        } else {
            a.from(is.getInputStream());
        }
        a.to(temp).setSession(session).run();
        tempPaths.add(temp);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getNewLine() {
        if (newLineString != null) return newLineString;
        Class<CoreIOUtils> clazz = CoreIOUtils.class;
        synchronized (CoreIOUtils.class) {
            newLineString = System.getProperty("line.separator");
            // ** MonitorExit[var0] (shouldn't be in output)
            return newLineString;
        }
    }

    public static boolean isAbsolutePath(String location) {
        return new File(location).isAbsolute();
    }

    public static String getAbsolutePath(String path) {
        return new File(path).toPath().toAbsolutePath().normalize().toString();
    }

    public static void copyFolder(Path src, Path dest, NutsSession session) {
        try {
            Files.walk(src, new FileVisitOption[0]).forEach(source -> CoreIOUtils.copy(source, dest.resolve(src.relativize((Path)source))));
        }
        catch (IOException e) {
            throw new NutsIOException(session, (Throwable)e);
        }
    }

    private static void copy(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(CoreStringUtils.exceptionToString(e), e);
        }
    }

    public static InputStream toInterruptible(InputStream in) {
        if (in == null) {
            return null;
        }
        if (in instanceof Interruptible) {
            return in;
        }
        return new InputStreamExt(in, null);
    }

    public static boolean isObsoletePath(NutsSession session, Path path) {
        try {
            return CoreIOUtils.isObsoleteInstant(session, Files.getLastModifiedTime(path, new LinkOption[0]).toInstant());
        }
        catch (IOException e) {
            return true;
        }
    }

    public static boolean isObsoletePath(NutsSession session, NutsPath path) {
        try {
            Instant i = path.getLastModifiedInstant();
            if (i == null) {
                return false;
            }
            return CoreIOUtils.isObsoleteInstant(session, i);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isObsoleteInstant(NutsSession session, Instant instant) {
        if (session.getExpireTime() != null) {
            return instant == null || instant.isBefore(session.getExpireTime());
        }
        return false;
    }

    public static byte[] loadFileContentLenient(Path out) {
        if (Files.isRegularFile(out, new LinkOption[0])) {
            try {
                return Files.readAllBytes(out);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new byte[0];
    }

    public static byte[] readBestEffort(int len, InputStream in, NutsSession session) {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return new byte[0];
        }
        byte[] buf = new byte[len];
        int count = CoreIOUtils.readBestEffort(buf, 0, len, in, session);
        if (count == len) {
            return buf;
        }
        byte[] buf2 = new byte[count];
        System.arraycopy(buf, 0, buf2, 0, count);
        return buf2;
    }

    public static int readBestEffort(byte[] b, int off, int len, InputStream in, NutsSession session) {
        int n;
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n = 0; n < len; n += count) {
            count = 0;
            try {
                count = in.read(b, off + n, len - n);
            }
            catch (IOException e) {
                throw new NutsIOException(session, (Throwable)e);
            }
            if (count < 0) break;
        }
        return n;
    }

    public static boolean Arrays_equals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[aFromIndex + i] == b[bFromIndex + i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareContent(Path file1, Path file2, NutsSession session) {
        if (Files.isRegularFile(file1, new LinkOption[0]) == false) return false;
        if (Files.isRegularFile(file2, new LinkOption[0]) == false) return false;
        try {
            if (Files.size(file1) != Files.size(file2)) return false;
            max = 2048;
            b1 = new byte[max];
            b2 = new byte[max];
            in1 = Files.newInputStream(file1, new OpenOption[0]);
            var7_8 = null;
            try {
                in2 = Files.newInputStream(file1, new OpenOption[0]);
                var9_11 = null;
                while (true) {
                    c1 = CoreIOUtils.readBestEffort(b1, 0, b1.length, in1, session);
                    c2 = CoreIOUtils.readBestEffort(b2, 0, b2.length, in2, session);
                    if (c1 == c2) ** GOTO lbl-1000
                    var12_15 = false;
                    if (in2 == null) return var12_15;
                    if (var9_11 != null) {
                    }
                    ** GOTO lbl43
                    {
                        block47: {
                            block48: {
                                block46: {
                                    block45: {
                                        catch (Throwable var10_13) {
                                            var9_11 = var10_13;
                                            throw var10_13;
                                        }
                                        catch (Throwable var14_27) {
                                            if (in2 == null) throw var14_27;
                                            if (var9_11 == null) {
                                                in2.close();
                                                throw var14_27;
                                            }
                                            try {
                                                in2.close();
                                                throw var14_27;
                                            }
                                            catch (Throwable var15_28) {
                                                var9_11.addSuppressed(var15_28);
                                                throw var14_27;
                                            }
                                        }
                                        try {
                                            in2.close();
                                            return var12_15;
                                        }
                                        catch (Throwable var13_19) {
                                            var9_11.addSuppressed(var13_19);
                                            return var12_15;
                                        }
lbl43:
                                        // 1 sources

                                        in2.close();
                                        return var12_15;
lbl-1000:
                                        // 1 sources

                                        {
                                            if (c1 != 0) ** GOTO lbl-1000
                                            var12_16 = true;
                                            if (in2 == null) return var12_16;
                                            if (var9_11 == null) break block45;
                                        }
                                        try {
                                            in2.close();
                                            return var12_16;
                                        }
                                        catch (Throwable var13_21) {
                                            var9_11.addSuppressed(var13_21);
                                            return var12_16;
                                        }
                                    }
                                    in2.close();
                                    return var12_16;
lbl-1000:
                                    // 1 sources

                                    {
                                        if (CoreIOUtils.Arrays_equals(b1, 0, c1, b2, 0, c1)) ** GOTO lbl-1000
                                        var12_17 = false;
                                        if (in2 == null) return var12_17;
                                        if (var9_11 == null) break block46;
                                    }
                                    try {
                                        in2.close();
                                        return var12_17;
                                    }
                                    catch (Throwable var13_23) {
                                        var9_11.addSuppressed(var13_23);
                                        return var12_17;
                                    }
                                }
                                in2.close();
                                return var12_17;
lbl-1000:
                                // 1 sources

                                {
                                    if (c1 >= max) break block47;
                                    var12_18 = true;
                                    if (in2 == null) return var12_18;
                                    if (var9_11 == null) break block48;
                                }
                                try {
                                    in2.close();
                                    return var12_18;
                                }
                                catch (Throwable var13_25) {
                                    var9_11.addSuppressed(var13_25);
                                    return var12_18;
                                }
                            }
                            in2.close();
                            return var12_18;
                        }
                        ** try [egrp 18[TRYBLOCK] [23 : 440->492)] { 
lbl-1000:
                        // 1 sources

                        {
                            continue;
                        }
                    }
                    break;
                }
            }
lbl87:
            // 2 sources

            catch (Throwable var8_10) {
                var7_8 = var8_10;
                throw var8_10;
            }
            finally {
                if (in1 != null) {
                    if (var7_8 != null) {
                        try {
                            in1.close();
                        }
                        catch (Throwable var13_20) {
                            var7_8.addSuppressed(var13_20);
                        }
                    } else {
                        in1.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new NutsIOException(session, (Throwable)e);
        }
    }

    public static InputStream createBytesStream(byte[] bytes, NutsMessage message, String contentType, String kind, NutsSession session) {
        return InputStreamMetadataAwareImpl.of(new ByteArrayInputStream(bytes), (NutsStreamMetadata)new NutsDefaultStreamMetadata(message, (long)bytes.length, contentType, kind, session));
    }

    public static String betterPath(String path1) {
        String home = System.getProperty("user.home");
        if (path1.startsWith(home + "/") || path1.startsWith(home + "\\")) {
            return "~" + path1.substring(home.length());
        }
        return path1;
    }

    public static String replaceFilePrefixes(String path, Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            String v = CoreIOUtils.replaceFilePrefix(path, e.getKey(), e.getValue());
            if (v.equals(path)) continue;
            return v;
        }
        return path;
    }

    public static String replaceFilePrefix(String path, String prefix, String replacement) {
        String path1 = path;
        String fs = File.separator;
        if (!prefix.endsWith(fs)) {
            prefix = prefix + fs;
        }
        if (!path1.endsWith(fs)) {
            path1 = prefix + fs;
        }
        if (path1.equals(prefix)) {
            if (replacement == null) {
                return "";
            }
            return replacement;
        }
        if (path.startsWith(prefix)) {
            if (replacement == null || replacement.equals("")) {
                return path1.substring(prefix.length());
            }
            return replacement + fs + path1.substring(prefix.length());
        }
        return path;
    }

    public static String longestCommonParent(String path1, String path2) {
        int latestSlash = -1;
        int len = Math.min(path1.length(), path2.length());
        for (int i = 0; i < len && path1.charAt(i) == path2.charAt(i); ++i) {
            if (path1.charAt(i) != '/') continue;
            latestSlash = i;
        }
        if (latestSlash <= 0) {
            return "";
        }
        return path1.substring(0, latestSlash + 1);
    }

    public static PathInfo.Status tryWriteStatus(byte[] content, NutsPath out, NutsSession session) {
        return CoreIOUtils.tryWrite(content, out, DoWhenExist.IGNORE, DoWhenNotExists.IGNORE, session);
    }

    public static PathInfo.Status tryWrite(byte[] content, NutsPath out, NutsSession session) {
        return CoreIOUtils.tryWrite(content, out, DoWhenExist.ASK, DoWhenNotExists.CREATE, session);
    }

    public static PathInfo.Status tryWrite(byte[] content, NutsPath out, DoWhenExist doWhenExist, DoWhenNotExists doWhenNotExist, NutsSession session) {
        if (doWhenExist == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"missing doWhenExist"));
        }
        if (doWhenNotExist == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"missing doWhenNotExist"));
        }
        out = out.toAbsolute().normalize();
        byte[] old = null;
        if (out.isRegularFile()) {
            try {
                old = out.readAllBytes();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (old == null) {
            switch (doWhenNotExist) {
                case IGNORE: {
                    return PathInfo.Status.DISCARDED;
                }
                case CREATE: {
                    out.mkParentDirs();
                    out.writeBytes(content);
                    if (session.isPlainTrace()) {
                        session.out().resetLine().printf("create file %s%n", new Object[]{out});
                    }
                    return PathInfo.Status.CREATED;
                }
                case ASK: {
                    if (session.getTerminal().ask().resetLine().setDefaultValue((Object)true).setSession(session).forBoolean("create %s ?", new Object[]{NutsTexts.of((NutsSession)session).ofStyled(CoreIOUtils.betterPath(out.toString()), NutsTextStyle.path())}).getBooleanValue().booleanValue()) {
                        out.mkParentDirs();
                        out.writeBytes(content);
                        if (session.isPlainTrace()) {
                            session.out().resetLine().printf("create file %s%n", new Object[]{out});
                        }
                        return PathInfo.Status.CREATED;
                    }
                    return PathInfo.Status.DISCARDED;
                }
            }
            throw new NutsUnsupportedEnumException(session, (Enum)doWhenNotExist);
        }
        if (Arrays.equals(old, content)) {
            return PathInfo.Status.DISCARDED;
        }
        switch (doWhenExist) {
            case IGNORE: {
                return PathInfo.Status.DISCARDED;
            }
            case OVERRIDE: {
                out.writeBytes(content);
                if (session.isPlainTrace()) {
                    session.out().resetLine().printf("update file %s%n", new Object[]{out});
                }
                return PathInfo.Status.OVERRIDDEN;
            }
            case ASK: {
                if (session.getTerminal().ask().resetLine().setDefaultValue((Object)true).setSession(session).forBoolean("override %s ?", new Object[]{NutsTexts.of((NutsSession)session).ofStyled(CoreIOUtils.betterPath(out.toString()), NutsTextStyle.path())}).getBooleanValue().booleanValue()) {
                    out.writeBytes(content);
                    if (session.isPlainTrace()) {
                        session.out().resetLine().printf("update file %s%n", new Object[]{out});
                    }
                    return PathInfo.Status.OVERRIDDEN;
                }
                return PathInfo.Status.DISCARDED;
            }
        }
        throw new NutsUnsupportedEnumException(session, (Enum)doWhenExist);
    }

    public static Set<CopyOption> asCopyOptions(Set<NutsPathOption> noptions) {
        HashSet<CopyOption> joptions = new HashSet<CopyOption>();
        for (NutsPathOption option : noptions) {
            switch (option) {
                case REPLACE_EXISTING: {
                    joptions.add(StandardCopyOption.REPLACE_EXISTING);
                    break;
                }
                case ATOMIC: {
                    joptions.add(StandardCopyOption.ATOMIC_MOVE);
                    break;
                }
                case COPY_ATTRIBUTES: {
                    joptions.add(StandardCopyOption.COPY_ATTRIBUTES);
                }
            }
        }
        return joptions;
    }

    public static NutsStream<String> safeLines(final byte[] bytes, NutsSession session) {
        return NutsStream.of((Iterator)new Iterator<String>(){
            BufferedReader br;
            String line;

            @Override
            public boolean hasNext() {
                if (this.br == null) {
                    this.br = CoreIOUtils.bufferedReaderOf(bytes);
                }
                try {
                    this.line = null;
                    this.line = this.br.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.line != null;
            }

            @Override
            public String next() {
                return this.line;
            }
        }, (NutsSession)session);
    }

    public static BufferedReader bufferedReaderOf(byte[] bytes) {
        return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
    }

    public static class CachedURL {
        String url;
        String path;
        String sha1;
        long lastModified;
        long size;
    }
}

