/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.thevpc.nuts.NutsCommandHistory;
import net.thevpc.nuts.NutsCommandHistoryEntry;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.io.terminal.history.NutsCommandHistoryEntryImpl;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class NutsCommandHistoryImpl
implements NutsCommandHistory {
    private NutsPath path;
    private final NutsSession session;
    private final List<NutsCommandHistoryEntry> entries = new ArrayList<NutsCommandHistoryEntry>();

    public NutsCommandHistoryImpl(NutsSession session) {
        this.session = session;
    }

    public void load() {
        this.entries.clear();
        if (this.path == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.plain((String)"missing path"));
        }
        if (this.path.exists()) {
            try (InputStream in = this.path.getInputStream();){
                this.load(in);
            }
            catch (IOException ex) {
                throw new NutsIOException(this.session, (Throwable)ex);
            }
        }
    }

    public void save() {
        if (this.path == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.plain((String)"missing path"));
        }
        this.path.mkParentDirs();
        try (OutputStream out = this.path.getOutputStream();){
            this.save(out);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    public void load(InputStream in) {
        this.entries.clear();
        if (in != null) {
            try (BufferedReader out = new BufferedReader(new InputStreamReader(in));){
                String line = null;
                Instant instant = null;
                int index = 0;
                while ((line = out.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    if (line.startsWith("#")) {
                        if (!line.startsWith("#at:")) continue;
                        instant = Instant.parse(line.substring("#at:".length()).trim());
                        continue;
                    }
                    this.entries.add(new NutsCommandHistoryEntryImpl(index, line, instant));
                }
            }
            catch (IOException ex) {
                throw new NutsIOException(this.session, (Throwable)ex);
            }
        }
    }

    public void save(OutputStream outs) {
        try (PrintStream out = new PrintStream(outs);){
            for (NutsCommandHistoryEntry entry : this.entries) {
                out.println("#at:" + entry.getTime().toString());
                out.println(entry.getLine().replace("\n", "\\n").replace("\r", "\\r"));
            }
        }
    }

    public NutsCommandHistory setPath(Path path) {
        this.path = path == null ? null : NutsPath.of((Path)path, (NutsSession)this.session);
        return this;
    }

    public NutsCommandHistory setPath(File path) {
        this.path = path == null ? null : NutsPath.of((File)path, (NutsSession)this.session);
        return this;
    }

    public NutsCommandHistory setPath(NutsPath path) {
        this.path = path;
        return this;
    }

    public NutsPath getPath() {
        return this.path;
    }

    public int size() {
        return this.entries.size();
    }

    public void purge() {
        this.entries.clear();
        if (this.path.exists()) {
            this.path.delete();
        }
    }

    public NutsCommandHistoryEntry getEntry(int index) {
        return this.entries.get(index);
    }

    public ListIterator<NutsCommandHistoryEntry> iterator(int index) {
        return this.entries.listIterator(index);
    }

    public void add(Instant time, String line) {
        this.entries.add(new NutsCommandHistoryEntryImpl(this.entries.size(), line, time));
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

