/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal;

import java.io.InputStream;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsQuestion;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.io.progress.CProgressBar;
import net.thevpc.nuts.runtime.standalone.io.progress.NutsProgressUtils;
import net.thevpc.nuts.runtime.standalone.io.terminal.AbstractNutsSessionTerminal;
import net.thevpc.nuts.runtime.standalone.io.terminal.CoreTerminalUtils;

public class UnmodifiableSessionTerminal
extends AbstractNutsSessionTerminal {
    private final NutsSessionTerminal base;
    protected CProgressBar progressBar;
    protected NutsSession session;

    public UnmodifiableSessionTerminal(NutsSessionTerminal base, NutsSession session) {
        this.base = base;
        this.session = session;
    }

    @Override
    public String readLine(NutsPrintStream out, String promptFormat, Object ... params) {
        return this.getBase().readLine(out, promptFormat, params);
    }

    public String readLine(NutsPrintStream out, NutsMessage message) {
        return this.getBase().readLine(out, message);
    }

    public char[] readPassword(NutsPrintStream out, NutsMessage message) {
        return this.getBase().readPassword(out, message);
    }

    public String readLine(NutsPrintStream out, NutsMessage message, NutsSession session) {
        return this.getBase().readLine(out, message, session);
    }

    public char[] readPassword(NutsPrintStream out, NutsMessage message, NutsSession session) {
        return this.getBase().readPassword(out, message, session);
    }

    public InputStream getIn() {
        return this.getBase().getIn();
    }

    public void setIn(InputStream in) {
    }

    public NutsPrintStream getOut() {
        return this.getBase().getOut();
    }

    public void setOut(NutsPrintStream out) {
    }

    public NutsPrintStream getErr() {
        return this.getBase().getErr();
    }

    public void setErr(NutsPrintStream out) {
    }

    public NutsSessionTerminal copy() {
        return this.getBase().copy();
    }

    public String readLine(String promptFormat, Object ... params) {
        return this.getBase().readLine(promptFormat, params);
    }

    public char[] readPassword(String prompt, Object ... params) {
        return this.getBase().readPassword(prompt, params);
    }

    public <T> NutsQuestion<T> ask() {
        return this.getBase().ask().setSession(this.session);
    }

    public InputStream in() {
        return this.getBase().in();
    }

    public NutsPrintStream out() {
        return this.getBase().out();
    }

    public NutsPrintStream err() {
        return this.getBase().err();
    }

    public NutsSessionTerminal printProgress(float progress, NutsMessage message) {
        if (NutsProgressUtils.acceptProgress(this.session)) {
            if (this.getBase() != null) {
                this.getBase().printProgress(progress, message);
            } else {
                this.getProgressBar().printProgress(Float.isNaN(progress) ? -1 : (int)(progress * 100.0f), NutsTexts.of((NutsSession)this.session).toText((Object)message).toString(), this.err());
            }
        }
        return this;
    }

    private CProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = CoreTerminalUtils.createProgressBar(this.session);
        }
        return this.progressBar;
    }

    public NutsSessionTerminal getBase() {
        return this.base;
    }

    @Override
    public NutsSession getSession() {
        return this.session;
    }
}

