/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal;

import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;

public class DefaultWriteTypeProcessor {
    private String askMessage;
    private Object[] askMessageParams;
    private String logMessage;
    private Object[] logMessageParams;
    private Supplier<RuntimeException> error;
    private NutsLogger log;
    private NutsConfirmationMode writeType;
    private NutsSession session;

    public DefaultWriteTypeProcessor(NutsConfirmationMode writeType, NutsSession session) {
        this.writeType = writeType;
        this.session = session;
    }

    public static DefaultWriteTypeProcessor of(NutsConfirmationMode writeType, NutsSession session) {
        return new DefaultWriteTypeProcessor(writeType, session);
    }

    public DefaultWriteTypeProcessor ask(String m, Object ... p) {
        if (m == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing ask message", (Object[])new Object[0]));
        }
        this.askMessage = m;
        this.askMessageParams = p;
        return this;
    }

    public DefaultWriteTypeProcessor withLog(NutsLogger log, String m, Object ... p) {
        if (log == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing ask log", (Object[])new Object[0]));
        }
        this.log = log;
        if (m == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing log message", (Object[])new Object[0]));
        }
        this.logMessage = m;
        this.logMessageParams = p;
        return this;
    }

    public DefaultWriteTypeProcessor onError(Supplier<RuntimeException> error) {
        if (error == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing error handler", (Object[])new Object[0]));
        }
        this.error = error;
        return this;
    }

    private String getAskMessage() {
        if (this.askMessage == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing ask message", (Object[])new Object[0]));
        }
        return this.askMessage;
    }

    private Object[] getAskMessageParams() {
        return this.askMessageParams == null ? new Object[]{} : this.askMessageParams;
    }

    private String getLogMessage() {
        if (this.logMessage == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing log message", (Object[])new Object[0]));
        }
        return this.logMessage;
    }

    private Object[] getLogMessageParams() {
        return this.logMessageParams == null ? new Object[]{} : this.logMessageParams;
    }

    private Supplier<RuntimeException> getError() {
        if (this.error == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing error handler", (Object[])new Object[0]));
        }
        return this.error;
    }

    private NutsLogger getLog() {
        if (this.log == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing log", (Object[])new Object[0]));
        }
        return this.log;
    }

    public boolean process() {
        switch (this.writeType) {
            case ERROR: {
                throw this.getError().get();
            }
            case ASK: {
                if (this.session.getTerminal().ask().setSession(this.session).forBoolean(this.getAskMessage(), this.getAskMessageParams()).setDefaultValue((Object)false).getBooleanValue().booleanValue()) break;
                return false;
            }
            case NO: {
                this.getLog().with().session(this.session).level(Level.FINE).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)this.getLogMessage(), (Object[])this.getLogMessageParams()));
                return false;
            }
        }
        this.getLog().with().session(this.session).level(Level.FINE).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)this.getLogMessage(), (Object[])this.getLogMessageParams()));
        return true;
    }
}

