/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNutsBootModel;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultNutsSessionTerminalFromSession;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultNutsSessionTerminalFromSystem;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigModel;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import net.thevpc.nuts.spi.NutsTerminals;

public class DefaultNutsTerminals
implements NutsTerminals {
    public DefaultNutsWorkspaceConfigModel cmodel;
    public NutsWorkspace ws;
    public DefaultNutsBootModel bootModel;

    public DefaultNutsTerminals(NutsSession session) {
        this.ws = session.getWorkspace();
        this.cmodel = ((DefaultNutsWorkspaceConfigManager)session.config()).getModel();
        this.bootModel = NutsWorkspaceExt.of((NutsWorkspace)session.getWorkspace()).getModel().bootModel;
    }

    public DefaultNutsWorkspaceConfigModel getModel() {
        return this.cmodel;
    }

    private void checkSession(NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.cmodel.getWorkspace(), session);
    }

    public NutsTerminals enableRichTerm(NutsSession session) {
        this.checkSession(session);
        this.bootModel.enableRichTerm(session);
        return this;
    }

    public NutsSessionTerminal createTerminal(NutsSession session) {
        this.checkSession(session);
        return this.cmodel.createTerminal(session);
    }

    public NutsSessionTerminal createTerminal(InputStream in, NutsPrintStream out, NutsPrintStream err, NutsSession session) {
        this.checkSession(session);
        return this.cmodel.createTerminal(in, out, err, session);
    }

    public NutsSessionTerminal createTerminal(NutsSessionTerminal terminal, NutsSession session) {
        this.checkSession(session);
        if (terminal == null) {
            return this.createTerminal(session);
        }
        if (terminal instanceof DefaultNutsSessionTerminalFromSystem) {
            DefaultNutsSessionTerminalFromSystem t = (DefaultNutsSessionTerminalFromSystem)terminal;
            return new DefaultNutsSessionTerminalFromSystem(session, t);
        }
        if (terminal instanceof DefaultNutsSessionTerminalFromSession) {
            DefaultNutsSessionTerminalFromSession t = (DefaultNutsSessionTerminalFromSession)terminal;
            return new DefaultNutsSessionTerminalFromSession(session, t);
        }
        return new DefaultNutsSessionTerminalFromSession(session, terminal);
    }

    public NutsSessionTerminal createMemTerminal(NutsSession session) {
        return this.createMemTerminal(false, session);
    }

    public NutsSessionTerminal createMemTerminal(boolean mergeErr, NutsSession session) {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[0]);
        NutsMemoryPrintStream out = NutsMemoryPrintStream.of((NutsSession)session);
        NutsMemoryPrintStream err = mergeErr ? out : NutsMemoryPrintStream.of((NutsSession)session);
        return this.createTerminal(in, (NutsPrintStream)out, (NutsPrintStream)err, session);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

