/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import net.thevpc.nuts.NutsBootTerminal;
import net.thevpc.nuts.NutsCommandAutoCompleteResolver;
import net.thevpc.nuts.NutsCommandHistory;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPrintStreams;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNutsBootModel;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamSystem;
import net.thevpc.nuts.runtime.standalone.workspace.CoreNutsBootOptions;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsAnsiTermHelper;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;
import net.thevpc.nuts.spi.NutsSystemTerminalBaseImpl;

@NutsComponentScope(value=NutsComponentScopeType.PROTOTYPE)
public class DefaultNutsSystemTerminalBaseBoot
extends NutsSystemTerminalBaseImpl {
    private final Scanner scanner;
    private final NutsPrintStream out;
    private final NutsPrintStream err;
    private final InputStream in;
    private final NutsWorkspace workspace;
    private final NutsSession session;
    private NutsLogger LOG;
    private NutsCommandHistory history;
    private String commandHighlighter;
    private NutsCommandAutoCompleteResolver commandAutoCompleteResolver;

    public DefaultNutsSystemTerminalBaseBoot(DefaultNutsBootModel bootModel) {
        this.session = bootModel.bootSession();
        this.workspace = this.session.getWorkspace();
        NutsWorkspaceOptions bo = bootModel.getBootOptions();
        NutsBootTerminal bootStdFd = new NutsBootTerminal(bo.getStdin() == null ? System.in : bo.getStdin(), bo.getStdout() == null ? System.out : bo.getStdout(), bo.getStderr() == null ? System.err : bo.getStderr(), new String[]{"boot"});
        CoreNutsBootOptions bOptions = bootModel.getCoreBootOptions();
        NutsTerminalMode terminalMode = bOptions.getOptions().getTerminalMode();
        if (terminalMode == null) {
            terminalMode = bOptions.getOptions().isBot() ? NutsTerminalMode.FILTERED : (bootStdFd.getFlags().contains("ansi") ? NutsTerminalMode.FORMATTED : NutsTerminalMode.FILTERED);
        }
        this.out = new NutsPrintStreamSystem(bootStdFd.getOut(), null, null, bootStdFd.getFlags().contains("ansi"), bootModel.getBootSession(), (NutsSystemTerminalBase)this).setMode(terminalMode);
        this.err = new NutsPrintStreamSystem(bootStdFd.getErr(), null, null, bootStdFd.getFlags().contains("ansi"), bootModel.getBootSession(), (NutsSystemTerminalBase)this).setMode(terminalMode);
        this.in = bootStdFd.getIn();
        this.scanner = new Scanner(this.in);
    }

    private NutsLogger _LOG() {
        if (this.LOG == null && this.session != null) {
            this.LOG = NutsLogger.of(NutsSystemTerminalBase.class, (NutsSession)this.session);
        }
        return this.LOG;
    }

    public int getSupportLevel(NutsSupportLevelContext criteria) {
        return 10;
    }

    public String readLine(NutsPrintStream out, NutsMessage message, NutsSession session) {
        if (out == null) {
            out = this.getOut();
        }
        if (out == null) {
            out = NutsPrintStreams.of((NutsSession)session).stdout();
        }
        if (message != null) {
            out.printf("%s", new Object[]{message});
            out.flush();
        }
        return this.scanner.nextLine();
    }

    public char[] readPassword(NutsPrintStream out, NutsMessage message, NutsSession session) {
        if (out == null) {
            out = this.getOut();
        }
        if (out == null) {
            out = NutsPrintStreams.of((NutsSession)session).stdout();
        }
        if (message != null) {
            out.printf("%s", new Object[]{message});
            out.flush();
        }
        return this.scanner.nextLine().toCharArray();
    }

    public InputStream getIn() {
        return this.in;
    }

    public NutsPrintStream getOut() {
        return this.out;
    }

    public NutsPrintStream getErr() {
        return this.err;
    }

    public NutsCommandAutoCompleteResolver getAutoCompleteResolver() {
        return this.commandAutoCompleteResolver;
    }

    public boolean isAutoCompleteSupported() {
        return false;
    }

    public NutsSystemTerminalBase setCommandAutoCompleteResolver(NutsCommandAutoCompleteResolver autoCompleteResolver) {
        this.commandAutoCompleteResolver = autoCompleteResolver;
        return this;
    }

    public NutsCommandHistory getCommandHistory() {
        return this.history;
    }

    public NutsSystemTerminalBase setCommandHistory(NutsCommandHistory history) {
        this.history = history;
        return this;
    }

    public String getCommandHighlighter() {
        return this.commandHighlighter;
    }

    public NutsSystemTerminalBase setCommandHighlighter(String commandHighlighter) {
        this.commandHighlighter = commandHighlighter;
        return this;
    }

    public Object run(NutsTerminalCommand command, NutsSession session) {
        return null;
    }

    public NutsSystemTerminalBase.Cursor getTerminalCursor(NutsSession session) {
        NutsWorkspaceUtils.checkSession(session.getWorkspace(), session);
        return (NutsSystemTerminalBase.Cursor)this.run(NutsTerminalCommand.GET_CURSOR, session);
    }

    public NutsSystemTerminalBase.Size getTerminalSize(NutsSession session) {
        NutsWorkspaceUtils.checkSession(session.getWorkspace(), session);
        return (NutsSystemTerminalBase.Size)this.run(NutsTerminalCommand.GET_SIZE, session);
    }

    public void setStyles(NutsTextStyles styles, NutsSession session) {
        String s = NutsAnsiTermHelper.of((NutsSession)session).styled(styles, session);
        if (s != null) {
            try {
                NutsBootTerminal bootStdFd = session.boot().getBootTerminal();
                bootStdFd.getOut().write(s.getBytes());
            }
            catch (IOException e) {
                throw new NutsIOException(session, (Throwable)e);
            }
        }
    }
}

