/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import net.thevpc.nuts.NutsBootTerminal;
import net.thevpc.nuts.NutsCommandAutoCompleteResolver;
import net.thevpc.nuts.NutsCommandHistory;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPrintStreams;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamSystem;
import net.thevpc.nuts.runtime.standalone.io.terminal.CoreAnsiTermHelper;
import net.thevpc.nuts.runtime.standalone.util.NutsCachedValue;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.spi.NutsAnsiTermHelper;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;
import net.thevpc.nuts.spi.NutsSystemTerminalBaseImpl;

@NutsComponentScope(value=NutsComponentScopeType.PROTOTYPE)
public class DefaultNutsSystemTerminalBase
extends NutsSystemTerminalBaseImpl {
    public static final int THIRTY_SECONDS = 30000;
    NutsCachedValue<NutsSystemTerminalBase.Cursor> termCursor;
    NutsCachedValue<NutsSystemTerminalBase.Size> termSize;
    private NutsLogger LOG;
    private Scanner scanner;
    private NutsTerminalMode outMode = NutsTerminalMode.FORMATTED;
    private NutsTerminalMode errMode = NutsTerminalMode.FORMATTED;
    private NutsPrintStream out;
    private NutsPrintStream err;
    private InputStream in;
    private NutsWorkspace workspace;
    private NutsSession session;
    private NutsCommandHistory history;
    private String commandHighlighter;
    private NutsCommandAutoCompleteResolver commandAutoCompleteResolver;

    private NutsLogger _LOG() {
        if (this.LOG == null && this.session != null) {
            this.LOG = NutsLogger.of(NutsSystemTerminalBase.class, (NutsSession)this.session);
        }
        return this.LOG;
    }

    public int getSupportLevel(NutsSupportLevelContext criteria) {
        this.session = criteria.getSession();
        this.workspace = this.session.getWorkspace();
        NutsWorkspaceOptions options = this.session.boot().getBootOptions();
        NutsTerminalMode terminalMode = options.getTerminalMode();
        NutsBootTerminal bootStdFd = NutsWorkspaceExt.of((NutsSession)this.session).getModel().bootModel.getBootTerminal();
        if (terminalMode == null) {
            terminalMode = options.isBot() || !bootStdFd.getFlags().contains("ansi") ? NutsTerminalMode.FILTERED : NutsTerminalMode.FORMATTED;
        }
        if (bootStdFd.getFlags().contains("tty")) {
            this.termCursor = new NutsCachedValue<NutsSystemTerminalBase.Cursor>(CoreAnsiTermHelper::evalCursor, 30000L);
            this.termSize = new NutsCachedValue<NutsSystemTerminalBase.Size>(CoreAnsiTermHelper::evalSize, 30000L);
        } else {
            this.termCursor = new NutsCachedValue<NutsSystemTerminalBase.Cursor>(session -> null, 30000L);
            this.termSize = new NutsCachedValue<NutsSystemTerminalBase.Size>(session -> null, 30000L);
        }
        this.out = new NutsPrintStreamSystem(bootStdFd.getOut(), null, null, bootStdFd.getFlags().contains("ansi"), this.session, (NutsSystemTerminalBase)this).setMode(terminalMode);
        this.err = new NutsPrintStreamSystem(bootStdFd.getErr(), null, null, bootStdFd.getFlags().contains("ansi"), this.session, (NutsSystemTerminalBase)this).setMode(terminalMode);
        this.in = bootStdFd.getIn();
        this.scanner = new Scanner(this.in);
        return 10;
    }

    public String readLine(NutsPrintStream out, NutsMessage message, NutsSession session) {
        if (out == null) {
            out = this.getOut();
        }
        if (out == null) {
            out = NutsPrintStreams.of((NutsSession)session).stdout();
        }
        if (message != null) {
            out.printf("%s", new Object[]{message});
            out.flush();
        }
        return this.scanner.nextLine();
    }

    public char[] readPassword(NutsPrintStream out, NutsMessage message, NutsSession session) {
        if (out == null) {
            out = this.getOut();
        }
        if (out == null) {
            out = NutsPrintStreams.of((NutsSession)session).stdout();
        }
        if (message != null) {
            out.printf("%s", new Object[]{message});
            out.flush();
        }
        return this.scanner.nextLine().toCharArray();
    }

    public InputStream getIn() {
        return this.in;
    }

    public NutsPrintStream getOut() {
        return this.out;
    }

    public NutsPrintStream getErr() {
        return this.err;
    }

    public NutsCommandAutoCompleteResolver getAutoCompleteResolver() {
        return this.commandAutoCompleteResolver;
    }

    public boolean isAutoCompleteSupported() {
        return false;
    }

    public NutsSystemTerminalBase setCommandAutoCompleteResolver(NutsCommandAutoCompleteResolver autoCompleteResolver) {
        this.commandAutoCompleteResolver = autoCompleteResolver;
        return this;
    }

    public NutsCommandHistory getCommandHistory() {
        return this.history;
    }

    public NutsSystemTerminalBase setCommandHistory(NutsCommandHistory history) {
        this.history = history;
        return this;
    }

    public String getCommandHighlighter() {
        return this.commandHighlighter;
    }

    public DefaultNutsSystemTerminalBase setCommandHighlighter(String commandHighlighter) {
        this.commandHighlighter = commandHighlighter;
        return this;
    }

    public Object run(NutsTerminalCommand command, NutsSession session) {
        switch (command.getName()) {
            case "get-cursor": {
                return this.termCursor.getValue(session);
            }
            case "get-size": {
                return this.termSize.getValue(session);
            }
        }
        String s = NutsAnsiTermHelper.of((NutsSession)session).command(command, session);
        if (s != null) {
            try {
                NutsBootTerminal bootStdFd = session.boot().getBootTerminal();
                bootStdFd.getOut().write(s.getBytes());
            }
            catch (IOException e) {
                throw new NutsIOException(session, (Throwable)e);
            }
        }
        return null;
    }

    public void setStyles(NutsTextStyles styles, NutsSession session) {
        String s = NutsAnsiTermHelper.of((NutsSession)session).styled(styles, session);
        if (s != null) {
            try {
                NutsBootTerminal bootStdFd = session.boot().getBootTerminal();
                bootStdFd.getOut().write(s.getBytes());
            }
            catch (IOException e) {
                throw new NutsIOException(session, (Throwable)e);
            }
        }
    }
}

