/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Scanner;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsInputStreams;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPrintStreams;
import net.thevpc.nuts.NutsQuestion;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsSystemTerminal;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.ask.DefaultNutsQuestion;
import net.thevpc.nuts.runtime.standalone.io.progress.CProgressBar;
import net.thevpc.nuts.runtime.standalone.io.progress.NutsProgressUtils;
import net.thevpc.nuts.runtime.standalone.io.terminal.AbstractNutsSessionTerminal;
import net.thevpc.nuts.runtime.standalone.io.terminal.CoreTerminalUtils;
import net.thevpc.nuts.runtime.standalone.io.terminal.NutsPrintStreamCache;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;

@NutsComponentScope(value=NutsComponentScopeType.PROTOTYPE)
public class DefaultNutsSessionTerminalFromSession
extends AbstractNutsSessionTerminal {
    protected NutsWorkspace ws;
    protected NutsSession session;
    protected NutsPrintStream out;
    protected NutsPrintStream err;
    protected NutsPrintStreamCache outCache = new NutsPrintStreamCache();
    protected NutsPrintStreamCache errCache = new NutsPrintStreamCache();
    protected InputStream in;
    protected BufferedReader inReader;
    protected NutsSessionTerminal parent;
    protected CProgressBar progressBar;

    public DefaultNutsSessionTerminalFromSession(NutsSession session, DefaultNutsSessionTerminalFromSession other) {
        this.session = session;
        this.parent = other.parent;
        this.ws = session.getWorkspace();
        this.in = other.in;
        this.inReader = other.inReader;
        this.setOut(other.out);
        this.setErr(other.err);
    }

    public DefaultNutsSessionTerminalFromSession(NutsSession session, NutsSessionTerminal parent) {
        this.session = session;
        this.parent = parent;
        this.ws = session.getWorkspace();
    }

    public BufferedReader getReader() {
        if (this.inReader != null) {
            return this.inReader;
        }
        InputStream _in = this.getIn();
        if (_in != null) {
            this.inReader = new BufferedReader(new InputStreamReader(_in));
        }
        return this.inReader;
    }

    public String readLine(NutsPrintStream out, NutsMessage message) {
        return this.readLine(out, message, this.session);
    }

    public char[] readPassword(NutsPrintStream out, NutsMessage message) {
        return this.readPassword(out, message, this.session);
    }

    public String readLine(NutsPrintStream out, NutsMessage message, NutsSession session) {
        if (session == null) {
            session = this.session;
        }
        if (out == null) {
            out = this.out();
        }
        if (out == null) {
            out = NutsPrintStreams.of((NutsSession)session).stdout();
        }
        if (this.in == null && this.parent != null) {
            if (this.out == null) {
                return this.parent.readLine(out, message, session);
            }
            return this.parent.readLine(out, message, session);
        }
        out.printf("%s", new Object[]{message});
        out.flush();
        try {
            return this.getReader().readLine();
        }
        catch (IOException e) {
            throw new NutsIOException(session, (Throwable)e);
        }
    }

    public char[] readPassword(NutsPrintStream out, NutsMessage message, NutsSession session) {
        if (session == null) {
            session = this.session;
        }
        if (out == null) {
            out = this.out();
        }
        if (out == null) {
            out = NutsPrintStreams.of((NutsSession)session).stdout();
        }
        if (this.in == null && this.parent != null) {
            if (this.out == null) {
                return this.parent.readPassword(out, message, session);
            }
            return this.parent.readPassword(out, message, session);
        }
        InputStream in = this.getIn();
        Console cons = null;
        char[] passwd = null;
        if (in == null) {
            in = NutsInputStreams.of((NutsSession)session).stdin();
        }
        if (in == NutsInputStreams.of((NutsSession)session).stdin() && (cons = System.console()) != null) {
            String txt = NutsTexts.of((NutsSession)session).toText((Object)message).toString();
            passwd = cons.readPassword("%s", txt);
            if (passwd != null) {
                return passwd;
            }
            return null;
        }
        out.printf("%s", new Object[]{message});
        out.flush();
        Scanner s = new Scanner(in);
        return s.nextLine().toCharArray();
    }

    public InputStream getIn() {
        if (this.in != null) {
            return this.in;
        }
        if (this.parent != null) {
            return this.parent.getIn();
        }
        return null;
    }

    public void setIn(InputStream in) {
        this.in = in;
        this.inReader = null;
    }

    public NutsPrintStream getOut() {
        NutsPrintStream o;
        NutsSessionTerminal p;
        if (this.out == null && (p = this.getParent()) != null && (o = p.getOut()) != null) {
            return this.outCache.get(o, this.getSession());
        }
        return this.out;
    }

    public void setOut(NutsPrintStream out) {
        if (out != null) {
            out = out.setSession(this.session);
        }
        this.out = out;
    }

    public NutsPrintStream getErr() {
        NutsPrintStream o;
        NutsSessionTerminal p;
        if (this.err == null && (p = this.getParent()) != null && (o = p.getErr()) != null) {
            return this.errCache.get(o, this.getSession());
        }
        return this.err;
    }

    public void setErr(NutsPrintStream err) {
        if (err != null) {
            err = err.setSession(this.session);
        }
        this.err = err;
    }

    public NutsSessionTerminal copy() {
        DefaultNutsSessionTerminalFromSession r = new DefaultNutsSessionTerminalFromSession(this.session, this.parent);
        r.copyFrom(this);
        return r;
    }

    public String readLine(String prompt, Object ... params) {
        return this.readLine(this.out(), prompt, params);
    }

    public char[] readPassword(String prompt, Object ... params) {
        return this.readPassword(this.out(), prompt, params);
    }

    public <T> NutsQuestion<T> ask() {
        return new DefaultNutsQuestion(this.ws, this, this.out()).setSession(this.session);
    }

    public InputStream in() {
        return this.getIn();
    }

    public NutsPrintStream out() {
        return this.getOut();
    }

    public NutsPrintStream err() {
        return this.getErr();
    }

    public NutsSessionTerminal printProgress(float progress, NutsMessage message) {
        if (NutsProgressUtils.acceptProgress(this.session)) {
            if (this.getParent() instanceof NutsSystemTerminal) {
                ((NutsSystemTerminal)this.getParent()).printProgress(progress, message, this.session);
            } else {
                this.getProgressBar().printProgress(Float.isNaN(progress) ? -1 : (int)(progress * 100.0f), NutsTexts.of((NutsSession)this.session).toText((Object)message).toString(), this.err());
            }
        }
        return this;
    }

    public NutsSessionTerminal getParent() {
        return this.parent;
    }

    public boolean isInOverridden() {
        return this.in != null;
    }

    public boolean isOutOverridden() {
        return this.out != null;
    }

    public boolean isErrOverridden() {
        return this.err != null;
    }

    private CProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = CoreTerminalUtils.createProgressBar(this.session);
        }
        return this.progressBar;
    }

    protected void copyFrom(DefaultNutsSessionTerminalFromSession other) {
        this.ws = other.ws;
        this.parent = other.parent;
        this.out = other.out;
        this.err = other.err;
        this.in = other.in;
        this.inReader = other.inReader;
    }

    @Override
    public NutsSession getSession() {
        return this.session;
    }
}

