/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal;

import java.io.InputStream;
import net.thevpc.nuts.NutsCommandAutoCompleteResolver;
import net.thevpc.nuts.NutsCommandHistory;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSystemTerminal;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.progress.CProgressBar;
import net.thevpc.nuts.runtime.standalone.io.progress.NutsProgressUtils;
import net.thevpc.nuts.runtime.standalone.io.terminal.CoreTerminalUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;
import net.thevpc.nuts.spi.NutsSystemTerminalBaseImpl;

public abstract class AbstractSystemTerminalAdapter
extends NutsSystemTerminalBaseImpl
implements NutsSystemTerminal {
    protected CProgressBar progressBar;
    private NutsWorkspace ws;
    private String commandHighlighter;

    public NutsCommandAutoCompleteResolver getAutoCompleteResolver() {
        NutsSystemTerminalBase p = this.getBase();
        if (p != null) {
            return p.getAutoCompleteResolver();
        }
        return null;
    }

    public boolean isAutoCompleteSupported() {
        return this.getBase().isAutoCompleteSupported();
    }

    public NutsSystemTerminalBase setCommandAutoCompleteResolver(NutsCommandAutoCompleteResolver autoCompleteResolver) {
        NutsSystemTerminalBase p = this.getBase();
        if (p != null) {
            p.setCommandAutoCompleteResolver(autoCompleteResolver);
        }
        return this;
    }

    public NutsSystemTerminalBase setCommandHistory(NutsCommandHistory history) {
        this.getBase().setCommandHistory(history);
        return this;
    }

    public NutsCommandHistory getCommandHistory() {
        return this.getBase().getCommandHistory();
    }

    public String readLine(NutsMessage message, NutsSession session) {
        NutsSystemTerminalBase p = this.getBase();
        if (p instanceof NutsSystemTerminal) {
            return ((NutsSystemTerminal)p).readLine(message, session);
        }
        return this.getBase().readLine(this.out(), message, session);
    }

    public char[] readPassword(NutsMessage message, NutsSession session) {
        NutsSystemTerminalBase p = this.getBase();
        if (p instanceof NutsSystemTerminal) {
            return ((NutsSystemTerminal)p).readPassword(message, session);
        }
        return p.readPassword(this.out(), message, session);
    }

    public InputStream in() {
        return this.getIn();
    }

    public NutsPrintStream out() {
        return this.getOut();
    }

    public NutsPrintStream err() {
        return this.getErr();
    }

    public NutsSystemTerminal printProgress(float progress, NutsMessage message, NutsSession session) {
        if (NutsProgressUtils.acceptProgress(session)) {
            if (this.getBase() instanceof NutsSystemTerminal) {
                ((NutsSystemTerminal)this.getBase()).printProgress(progress, message, session);
            } else {
                this.getProgressBar(session).printProgress(Float.isNaN(progress) ? -1 : (int)(progress * 100.0f), NutsTexts.of((NutsSession)session).toText((Object)message).toString(), this.err());
            }
        }
        return this;
    }

    private CProgressBar getProgressBar(NutsSession session) {
        if (this.progressBar == null) {
            this.progressBar = CoreTerminalUtils.createProgressBar(session);
        }
        return this.progressBar;
    }

    public int getSupportLevel(NutsSupportLevelContext criteria) {
        return 10;
    }

    public String readLine(NutsPrintStream out, NutsMessage message, NutsSession session) {
        return this.getBase().readLine(out, message, session);
    }

    public char[] readPassword(NutsPrintStream out, NutsMessage message, NutsSession session) {
        return this.getBase().readPassword(out, message, session);
    }

    public InputStream getIn() {
        return this.getBase().getIn();
    }

    public NutsPrintStream getOut() {
        return this.getBase().getOut();
    }

    public NutsPrintStream getErr() {
        return this.getBase().getErr();
    }

    public abstract NutsSystemTerminalBase getBase();

    public String getCommandHighlighter() {
        return this.commandHighlighter;
    }

    public NutsSystemTerminal setCommandHighlighter(String commandHighlighter) {
        this.commandHighlighter = commandHighlighter;
        return this;
    }

    public Object run(NutsTerminalCommand command, NutsSession session) {
        return this.getBase().run(command, session);
    }

    public void setStyles(NutsTextStyles styles, NutsSession session) {
        this.getBase().setStyles(styles, session);
    }
}

