/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.progress;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsProgressFactory;
import net.thevpc.nuts.NutsProgressMonitor;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStreamMetadata;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.io.progress.DefaultNutsInputStreamProgressFactory;
import net.thevpc.nuts.runtime.standalone.io.progress.DefaultNutsProgressFactory;
import net.thevpc.nuts.runtime.standalone.io.progress.MonitoredInputStream;
import net.thevpc.nuts.runtime.standalone.io.progress.NutsProgressMonitorList;
import net.thevpc.nuts.runtime.standalone.io.progress.ProgressOptions;
import net.thevpc.nuts.runtime.standalone.io.progress.SilentNutsProgressMonitor;
import net.thevpc.nuts.runtime.standalone.io.progress.TraceNutsProgressMonitor;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringMapParser;

public class NutsProgressUtils {
    public static ProgressOptions parseProgressOptions(NutsSession session) {
        ProgressOptions o = new ProgressOptions();
        boolean enabledVisited = false;
        StringMapParser p = new StringMapParser("=", ",; ");
        Map<String, String> m = p.parseMap(session.getProgressOptions(), session);
        NutsElements elems = NutsElements.of((NutsSession)session);
        for (Map.Entry<String, String> e : m.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            if (!enabledVisited) {
                if (v != null) continue;
                Boolean a = NutsUtilStrings.parseBoolean((String)k, null, null);
                if (a != null) {
                    o.setEnabled(a);
                    enabledVisited = true;
                    continue;
                }
                o.put(k, elems.ofString(v));
                continue;
            }
            o.put(k, elems.ofString(v));
        }
        return o;
    }

    public static boolean acceptProgress(NutsSession session) {
        if (!session.isPlainOut()) {
            return false;
        }
        return !session.isBot() && NutsProgressUtils.parseProgressOptions(session).isEnabled();
    }

    public static InputStream monitor(URL from, NutsProgressMonitor monitor, NutsSession session) {
        return NutsProgressUtils.monitor(NutsPath.of((URL)from, (NutsSession)session).getInputStream(), from, (NutsString)NutsTexts.of((NutsSession)session).ofStyled(NutsPath.of((URL)from, (NutsSession)session).getName(), NutsTextStyle.path()), NutsPath.of((URL)from, (NutsSession)session).getContentLength(), monitor, session);
    }

    public static InputStream monitor(InputStream from, Object source, NutsString sourceName, long length, NutsProgressMonitor monitor, NutsSession session) {
        return new MonitoredInputStream(from, source, sourceName, length, monitor, session);
    }

    public static InputStream monitor(InputStream from, Object source, NutsProgressMonitor monitor, NutsSession session) {
        NutsText sourceName = null;
        long length = -1L;
        NutsStreamMetadata m = NutsStreamMetadata.resolve((Object)from);
        if (m != null) {
            sourceName = NutsTexts.of((NutsSession)session).toText((Object)m.getName());
            length = m.getContentLength();
        }
        return new MonitoredInputStream(from, source, (NutsString)sourceName, length, monitor, session);
    }

    public static NutsProgressFactory createLogProgressMonitorFactory(MonitorType mt) {
        switch (mt) {
            case STREAM: {
                return new DefaultNutsInputStreamProgressFactory();
            }
            case DEFAULT: {
                return new DefaultNutsProgressFactory();
            }
        }
        return new DefaultNutsProgressFactory();
    }

    public static NutsProgressMonitor createProgressMonitor(MonitorType mt, Object source, Object sourceOrigin, NutsSession session, boolean logProgress, boolean traceProgress, NutsProgressFactory progressFactory) {
        NutsProgressMonitor e;
        ArrayList<NutsProgressMonitor> all = new ArrayList<NutsProgressMonitor>();
        if (logProgress && (e = NutsProgressUtils.createLogProgressMonitorFactory(mt).create(source, sourceOrigin, session)) != null) {
            all.add(e);
        }
        if (traceProgress) {
            all.add(new TraceNutsProgressMonitor());
        }
        if (progressFactory != null && (e = progressFactory.create(source, sourceOrigin, session)) != null) {
            all.add(e);
        }
        if (all.isEmpty()) {
            return new SilentNutsProgressMonitor();
        }
        if (all.size() == 1) {
            return (NutsProgressMonitor)all.get(0);
        }
        return new NutsProgressMonitorList(all.toArray(new NutsProgressMonitor[0]));
    }

    public static enum MonitorType {
        STREAM,
        DEFAULT;

    }
}

