/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.progress;

import java.io.IOException;
import java.io.InputStream;
import net.thevpc.nuts.NutsDefaultStreamMetadata;
import net.thevpc.nuts.NutsProgressEvent;
import net.thevpc.nuts.NutsProgressMonitor;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStreamMetadata;
import net.thevpc.nuts.NutsStreamMetadataAware;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.runtime.standalone.io.progress.DefaultNutsProgressEvent;
import net.thevpc.nuts.runtime.standalone.io.util.InterruptException;
import net.thevpc.nuts.runtime.standalone.io.util.Interruptible;

public class MonitoredInputStream
extends InputStream
implements NutsStreamMetadataAware,
Interruptible {
    private final InputStream base;
    private final long length;
    private final NutsProgressMonitor monitor;
    private final Object source;
    private final NutsString sourceName;
    private long count;
    private long lastCount;
    private long startTime;
    private long lastTime;
    private boolean completed = false;
    private boolean interrupted = false;
    private final NutsSession session;

    public MonitoredInputStream(InputStream base, Object source, NutsString sourceName, long length, NutsProgressMonitor monitor, NutsSession session) {
        this.base = base;
        this.session = session;
        if (monitor == null) {
            throw new NullPointerException();
        }
        this.monitor = monitor;
        this.source = source;
        this.sourceName = sourceName;
        this.length = length;
    }

    @Override
    public void interrupt() throws InterruptException {
        this.interrupted = true;
    }

    @Override
    public int read() throws IOException {
        if (this.interrupted) {
            throw new IOException(new InterruptException("Interrupted"));
        }
        try {
            this.onBeforeRead();
            int r = this.base.read();
            if (r != -1) {
                this.onAfterRead(1L);
            } else {
                this.onComplete(null);
            }
            return r;
        }
        catch (IOException ex) {
            this.onComplete(ex);
            throw ex;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            if (this.interrupted) {
                throw new IOException(new InterruptException("Interrupted"));
            }
            this.onBeforeRead();
            int r = this.base.read(b);
            this.onAfterRead(r);
            return r;
        }
        catch (IOException ex) {
            this.onComplete(ex);
            throw ex;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            if (this.interrupted) {
                throw new IOException(new InterruptException("Interrupted"));
            }
            this.onBeforeRead();
            int r = this.base.read(b, off, len);
            this.onAfterRead(r);
            return r;
        }
        catch (IOException ex) {
            this.onComplete(ex);
            throw ex;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            if (this.interrupted) {
                throw new IOException(new InterruptException("Interrupted"));
            }
            this.onBeforeRead();
            long r = this.base.skip(n);
            this.onAfterRead(r);
            return r;
        }
        catch (IOException ex) {
            this.onComplete(ex);
            throw ex;
        }
    }

    @Override
    public int available() throws IOException {
        try {
            if (this.interrupted) {
                throw new IOException(new InterruptException("Interrupted"));
            }
            return this.base.available();
        }
        catch (IOException ex) {
            this.onComplete(ex);
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        this.onComplete(null);
        this.base.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.base.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.base.reset();
        }
        catch (IOException ex) {
            this.onComplete(ex);
            throw ex;
        }
    }

    @Override
    public boolean markSupported() {
        return this.base.markSupported();
    }

    private void onBeforeRead() {
        if (!this.completed && this.startTime == 0L) {
            long now;
            this.startTime = now = System.currentTimeMillis();
            this.lastTime = now;
            this.lastCount = 0L;
            this.count = 0L;
            this.monitor.onStart((NutsProgressEvent)new DefaultNutsProgressEvent(this.source, this.sourceName, 0L, 0L, 0L, 0L, this.length, null, this.session, this.length < 0L));
        }
    }

    private void onAfterRead(long count) {
        if (!this.completed) {
            long now = System.currentTimeMillis();
            this.count += count;
            if (this.monitor.onProgress((NutsProgressEvent)new DefaultNutsProgressEvent(this.source, this.sourceName, this.count, now - this.startTime, this.count - this.lastCount, now - this.lastTime, this.length, null, this.session, this.length < 0L))) {
                this.lastCount = this.count;
                this.lastTime = now;
            }
        }
    }

    private void onComplete(IOException ex) {
        if (!this.completed) {
            this.completed = true;
            long now = System.currentTimeMillis();
            this.monitor.onComplete((NutsProgressEvent)new DefaultNutsProgressEvent(this.source, this.sourceName, this.count, now - this.startTime, this.count - this.lastCount, now - this.lastTime, this.length, ex, this.session, this.length < 0L));
        }
    }

    public NutsStreamMetadata getStreamMetadata() {
        NutsStreamMetadata md = NutsStreamMetadata.of((Object)this.base);
        return new NutsDefaultStreamMetadata(this.sourceName, this.length, md.getContentType(), md.getUserKind());
    }

    public String toString() {
        return String.valueOf(this.sourceName);
    }
}

