/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.progress;

import java.io.File;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import net.thevpc.nuts.NutsDefaultStreamMetadata;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInputStreamMonitor;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsProgressEvent;
import net.thevpc.nuts.NutsProgressFactory;
import net.thevpc.nuts.NutsProgressMonitor;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.progress.DefaultNutsProgressEvent;
import net.thevpc.nuts.runtime.standalone.io.progress.NutsProgressUtils;
import net.thevpc.nuts.runtime.standalone.io.progress.SilentStartNutsProgressMonitorAdapter;
import net.thevpc.nuts.runtime.standalone.io.progress.SingletonNutsInputStreamProgressFactory;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamMetadataAwareImpl;
import net.thevpc.nuts.runtime.standalone.io.util.NutsStreamOrPath;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsInputStreamMonitor
implements NutsInputStreamMonitor {
    private final NutsWorkspace ws;
    private String sourceTypeName;
    private NutsStreamOrPath source;
    private Object sourceOrigin;
    private NutsString sourceName;
    private long length = -1L;
    private NutsSession session;
    private boolean logProgress;
    private boolean traceProgress;
    private NutsProgressFactory progressFactory;

    public DefaultNutsInputStreamMonitor(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsInputStreamMonitor setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.ws, session);
        return this;
    }

    public NutsString getName() {
        return this.sourceName;
    }

    public NutsInputStreamMonitor setName(NutsString name) {
        this.sourceName = name;
        return this;
    }

    public Object getOrigin() {
        return this.sourceOrigin;
    }

    public NutsInputStreamMonitor setOrigin(Object origin) {
        this.sourceOrigin = origin;
        return this;
    }

    public long getLength() {
        return this.length;
    }

    public NutsInputStreamMonitor setLength(long len) {
        this.length = len;
        return this;
    }

    public NutsInputStreamMonitor setSource(String path) {
        this.source = path == null ? null : NutsStreamOrPath.of(path, this.session);
        return this;
    }

    public NutsInputStreamMonitor setSource(NutsPath inputSource) {
        this.source = inputSource == null ? null : NutsStreamOrPath.of(inputSource);
        return this;
    }

    public NutsInputStreamMonitor setSource(Path path) {
        this.checkSession();
        this.source = path == null ? null : NutsStreamOrPath.of(path, this.session);
        return this;
    }

    public NutsInputStreamMonitor setSource(File path) {
        this.checkSession();
        this.source = path == null ? null : NutsStreamOrPath.of(path, this.session);
        return this;
    }

    public NutsInputStreamMonitor setSource(InputStream path) {
        this.checkSession();
        this.source = path == null ? null : NutsStreamOrPath.of(path, this.session);
        return this;
    }

    public InputStream create() {
        String sourceTypeName;
        this.checkSession();
        if (this.source == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing Source", (Object[])new Object[0]));
        }
        this.checkSession();
        NutsString sourceName = this.sourceName;
        if (sourceName == null || sourceName.isEmpty()) {
            sourceName = NutsTexts.of((NutsSession)this.session).toText((Object)this.source);
        }
        if (sourceName == null || sourceName.isEmpty()) {
            sourceName = NutsTexts.of((NutsSession)this.session).toText((Object)this.source.getName());
        }
        if (sourceName == null || sourceName.isEmpty()) {
            sourceName = NutsTexts.of((NutsSession)this.session).toText((Object)String.valueOf(this.source.getValue()));
        }
        NutsProgressMonitor monitor = NutsProgressUtils.createProgressMonitor(NutsProgressUtils.MonitorType.STREAM, this.source.getValue(), this.sourceOrigin, this.session, this.isLogProgress(), this.isTraceProgress(), this.getProgressFactory());
        boolean verboseMode = this.getSession().boot().getBootCustomBoolArgument(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), new String[]{"---monitor-start"});
        long size = -1L;
        try {
            if (verboseMode && monitor != null) {
                monitor.onStart((NutsProgressEvent)new DefaultNutsProgressEvent(this.source, sourceName, 0L, 0L, 0L, 0L, size, null, this.session, true));
            }
            size = this.source.getContentLength();
        }
        catch (UncheckedIOException | NutsIOException e) {
            if (verboseMode && monitor != null) {
                monitor.onComplete((NutsProgressEvent)new DefaultNutsProgressEvent(this.source, sourceName, 0L, 0L, 0L, 0L, size, e, this.session, true));
            }
            throw e;
        }
        if (size < 0L) {
            size = this.getLength();
        }
        if (monitor == null) {
            return this.source.getInputStream();
        }
        InputStream openedStream = this.source.getInputStream();
        if (!verboseMode) {
            monitor.onStart((NutsProgressEvent)new DefaultNutsProgressEvent(this.source, sourceName, 0L, 0L, 0L, 0L, size, null, this.session, size < 0L));
        }
        if ((sourceTypeName = this.getSourceTypeName()) == null) {
            sourceTypeName = this.source.getStreamMetaData().getUserKind();
        }
        if (sourceTypeName == null) {
            sourceTypeName = "nuts-Path";
        }
        return InputStreamMetadataAwareImpl.of(NutsProgressUtils.monitor(openedStream, this.source, sourceName, size, new SilentStartNutsProgressMonitorAdapter(monitor, sourceName.filteredText()), this.session), new NutsDefaultStreamMetadata(this.source.getStreamMetaData()).setUserKind(sourceTypeName));
    }

    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    public NutsInputStreamMonitor setSourceTypeName(String sourceType) {
        this.sourceTypeName = sourceType;
        return this;
    }

    public boolean isTraceProgress() {
        return this.traceProgress;
    }

    public boolean isLogProgress() {
        return this.logProgress;
    }

    public NutsInputStreamMonitor setLogProgress(boolean value) {
        this.logProgress = value;
        return this;
    }

    public NutsInputStreamMonitor setTraceProgress(boolean value) {
        this.traceProgress = value;
        return this;
    }

    public NutsProgressFactory getProgressFactory() {
        return this.progressFactory;
    }

    public NutsInputStreamMonitor setProgressFactory(NutsProgressFactory value) {
        this.progressFactory = value;
        return this;
    }

    public NutsInputStreamMonitor setProgressMonitor(NutsProgressMonitor value) {
        this.progressFactory = value == null ? null : new SingletonNutsInputStreamProgressFactory(value);
        return this;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

