/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.progress;

import java.util.Calendar;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.progress.NutsProgressUtils;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;

public class CProgressBar {
    public static final Formatter RECTANGLES = new SimpleFormatter("\u2b1c\u2b1b", "\u2b1b", null, null, null);
    public static final Formatter CIRCLES = new SimpleFormatter("\u26aa\u26ab", "\u26ab", null, null, null);
    public static final Formatter PARALLELOGRAM = new SimpleFormatter("\u25b1\u25b0", "\u25b0", null, null, null);
    public static final Formatter SIMPLE = new SimpleFormatter(" *", null, null, "[", "]");
    public static final Formatter RECTANGLES2 = new SimpleFormatter(" \u2581\u2582\u2583\u2584\u2585\u2586\u2587\u2588", "\u2581\u2582\u2583\u2584\u2585\u2586\u2587\u2588", "\u2588\u2587\u2586\u2585\u2584\u2583\u2582\u2581", null, null);
    public static final Formatter RECTANGLES3 = new SimpleFormatter(" \u2591\u2592\u2593\u2588", "\u2588", null, null, null);
    public static final Formatter RECTANGLES4 = new SimpleFormatter(" \u258f\u258e\u258d\u258c\u258b\u258a\u2589\u2588", "\u2581\u2582\u2583\u2584\u2585\u2586\u2587\u2588", "\u2588\u2587\u2586\u2585\u2584\u2583\u2582\u2581", null, null);
    public static final Formatter DOTS1 = new SimpleFormatter(" \u28c0\u28c4\u28e4\u28e6\u28f6\u28f7\u28ff", "\u28ff", null, null, null);
    public static final Formatter DOTS2 = new SimpleFormatter(" \u28c0\u28c4\u28c6\u28c7\u28e7\u28f7\u28ff", "\u28ff", null, null, null);
    public static final Formatter CIRCLES2 = new SimpleFormatter("\u25cb\u25d4\u25d0\u25d5\u2b24", "\u2b24", null, null, null);
    public static final Formatter DEFAULT = RECTANGLES4;
    private static final IndeterminatePosition DEFAULT_INDETERMINATE_POSITION = new DefaultIndeterminatePosition();
    private boolean formatted = true;
    private int size = 10;
    private int maxMessage = 0;
    private float indeterminateSize = 0.3f;
    private NutsSession session;
    private int columns = 3;
    private int maxColumns = 133;
    private boolean suffixMoveLineStart = true;
    private boolean prefixMoveLineStart = true;
    private long lastPrint = 0L;
    private long minPeriod = 0L;
    private IndeterminatePosition indeterminatePosition = DEFAULT_INDETERMINATE_POSITION;
    private boolean optionNewline;
    private Formatter formatter = CorePlatformUtils.SUPPORTS_UTF_ENCODING ? RECTANGLES4 : SIMPLE;
    private NutsWorkspace ws;

    public CProgressBar(NutsSession session) {
        this.session = session;
        boolean bl = this.formatted = session != null;
        if (session != null) {
            this.optionNewline = NutsProgressUtils.parseProgressOptions(session).isArmedNewline();
            this.ws = session.getWorkspace();
        }
    }

    public CProgressBar(NutsSession session, int size) {
        this.session = session;
        this.setSize(size);
    }

    public long getMinPeriod() {
        return this.minPeriod;
    }

    public void setMinPeriod(long minPeriod) {
        this.minPeriod = minPeriod;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public CProgressBar setFormatter(Formatter formatter) {
        this.formatter = formatter == null ? DEFAULT : formatter;
        return this;
    }

    public IndeterminatePosition getIndeterminatePosition() {
        return this.indeterminatePosition;
    }

    public CProgressBar setIndeterminatePosition(IndeterminatePosition indeterminatePosition) {
        this.indeterminatePosition = indeterminatePosition == null ? DEFAULT_INDETERMINATE_POSITION : indeterminatePosition;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public CProgressBar setSize(int size) {
        if (size < 10) {
            size = 10;
        }
        this.size = size;
        return this;
    }

    public int getColumns() {
        return this.columns;
    }

    public CProgressBar setColumns(int columns) {
        this.columns = columns <= 1 ? 1 : columns;
        return this;
    }

    public boolean isSuffixMoveLineStart() {
        return this.suffixMoveLineStart;
    }

    public boolean isPrefixMoveLineStart() {
        return this.prefixMoveLineStart;
    }

    public boolean isNoMoveLineStart() {
        return !this.isPrefixMoveLineStart() && !this.isSuffixMoveLineStart();
    }

    public CProgressBar setSuffixMoveLineStart(boolean v) {
        this.suffixMoveLineStart = v;
        return this;
    }

    public CProgressBar setPrefixMoveLineStart(boolean v) {
        this.prefixMoveLineStart = v;
        return this;
    }

    public CProgressBar setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.ws, session);
        return this;
    }

    public String progress(int percent) {
        if (this.session != null) {
            return this.progressWithSession(percent);
        }
        return this.progressWithoutSession(percent);
    }

    public String progressWithoutSession(int percent) {
        int i;
        StringBuilder sb;
        boolean indeterminate;
        long now = System.currentTimeMillis();
        if (this.minPeriod > 0L && now < this.lastPrint + this.minPeriod) {
            return "";
        }
        this.lastPrint = now;
        boolean bl = indeterminate = percent < 0;
        if (indeterminate) {
            int i2;
            StringBuilder formattedLine = new StringBuilder();
            formattedLine.append(this.getFormatter().getStart());
            int indeterminateSize = (int)(this.indeterminateSize * (float)this.size);
            if (indeterminateSize >= this.size) {
                indeterminateSize = this.size - 1;
            }
            if (indeterminateSize < 1) {
                indeterminateSize = 1;
            }
            int x = 0;
            boolean forward = true;
            if (indeterminateSize < this.size) {
                int p = this.size - indeterminateSize;
                int h = this.indeterminatePosition.evalIndeterminatePos(this, 2 * p);
                if (h < 0) {
                    h = -h;
                }
                if ((x = h % (2 * p)) >= p) {
                    forward = false;
                    x = 2 * p - x;
                }
            } else {
                x = 0;
            }
            if (x < 0) {
                x = 0;
            }
            StringBuilder sb2 = new StringBuilder();
            for (i2 = 0; i2 < x; ++i2) {
                sb2.append(this.getFormatter().getIndicator(0.0f, i2));
            }
            for (i2 = 0; i2 < indeterminateSize; ++i2) {
                sb2.append(this.getFormatter().getIntermediateIndicator(i2, indeterminateSize, x, forward));
            }
            formattedLine.append(sb2.toString());
            int r = this.size - x - indeterminateSize;
            sb2.setLength(0);
            for (int i3 = 0; i3 < r; ++i3) {
                sb2.append(this.getFormatter().getIndicator(0.0f, x + indeterminateSize + i3));
            }
            formattedLine.append(sb2.toString());
            formattedLine.append(this.getFormatter().getEnd());
            return formattedLine.toString();
        }
        if (percent > 100) {
            percent = 100 - percent;
        }
        double d = (double)this.size / 100.0 * (double)percent;
        int x = (int)d;
        float rest = (float)(d - (double)x);
        StringBuilder formattedLine = new StringBuilder();
        formattedLine.append(this.getFormatter().getStart());
        if (x > 0) {
            sb = new StringBuilder();
            for (i = 0; i < x; ++i) {
                sb.append(this.getFormatter().getIndicator(1.0f, i));
            }
            formattedLine.append(sb.toString());
        }
        sb = new StringBuilder();
        if (rest > 0.0f && this.size - x > 0) {
            sb.append(this.getFormatter().getIndicator(rest, x));
            for (i = 0; i < this.size - x - 1; ++i) {
                sb.append(this.getFormatter().getIndicator(0.0f, x + 1 + i));
            }
        } else {
            for (i = 0; i < this.size - x; ++i) {
                sb.append(this.getFormatter().getIndicator(0.0f, x + i));
            }
        }
        formattedLine.append(sb.toString());
        formattedLine.append(this.getFormatter().getEnd());
        return formattedLine.toString();
    }

    public String progressWithSession(int percent) {
        return this.progressWithSessionOld(percent);
    }

    public String progressWithSessionOld(int percent) {
        int i;
        StringBuilder sb;
        boolean indeterminate;
        long now = System.currentTimeMillis();
        if (now < this.lastPrint + this.minPeriod) {
            return "";
        }
        this.lastPrint = now;
        boolean bl = indeterminate = percent < 0;
        if (indeterminate) {
            int i2;
            NutsTextBuilder formattedLine = NutsTexts.of((NutsSession)this.session).builder();
            formattedLine.append((Object)this.getFormatter().getStart());
            int indeterminateSize = (int)(this.indeterminateSize * (float)this.size);
            boolean forward = true;
            if (indeterminateSize >= this.size) {
                indeterminateSize = this.size - 1;
            }
            if (indeterminateSize < 1) {
                indeterminateSize = 1;
            }
            int x = 0;
            if (indeterminateSize < this.size) {
                int p = this.size - indeterminateSize;
                int h = this.indeterminatePosition.evalIndeterminatePos(this, 2 * p);
                if (h < 0) {
                    h = -h;
                }
                if ((x = h % (2 * p)) >= p) {
                    forward = false;
                    x = 2 * p - x;
                }
            } else {
                x = 0;
            }
            if (x < 0) {
                x = 0;
            }
            StringBuilder sb2 = new StringBuilder();
            for (i2 = 0; i2 < x; ++i2) {
                sb2.append(this.getFormatter().getIndicator(0.0f, i2));
            }
            for (i2 = 0; i2 < indeterminateSize; ++i2) {
                sb2.append(this.getFormatter().getIntermediateIndicator(i2, indeterminateSize, x, forward));
            }
            formattedLine.append((Object)sb2.toString(), NutsTextStyle.primary1());
            int r = this.size - x - indeterminateSize;
            sb2.setLength(0);
            for (int i3 = 0; i3 < r; ++i3) {
                sb2.append(this.getFormatter().getIndicator(0.0f, x + indeterminateSize + i3));
            }
            formattedLine.append((Object)sb2.toString());
            formattedLine.append((Object)this.getFormatter().getEnd());
            return formattedLine.toString();
        }
        if (percent > 100) {
            percent = 100 - percent;
        }
        double d = (double)this.size / 100.0 * (double)percent;
        int x = (int)d;
        float rest = (float)(d - (double)x);
        NutsTextBuilder formattedLine = NutsTexts.of((NutsSession)this.session).builder();
        formattedLine.append((Object)this.getFormatter().getStart());
        if (x > 0) {
            sb = new StringBuilder();
            for (i = 0; i < x; ++i) {
                sb.append(this.getFormatter().getIndicator(1.0f, i));
            }
            formattedLine.append((Object)sb.toString(), NutsTextStyle.primary1());
        }
        sb = new StringBuilder();
        if (rest > 0.0f && this.size - x > 0) {
            sb.append(this.getFormatter().getIndicator(rest, x));
            for (i = 0; i < this.size - x - 1; ++i) {
                sb.append(this.getFormatter().getIndicator(0.0f, x + 1 + i));
            }
        } else {
            for (i = 0; i < this.size - x; ++i) {
                sb.append(this.getFormatter().getIndicator(0.0f, x + i));
            }
        }
        formattedLine.append((Object)sb.toString(), NutsTextStyle.primary1());
        formattedLine.append((Object)this.getFormatter().getEnd());
        return formattedLine.toString();
    }

    public String progressWithSessionNew(int percent) {
        int i;
        boolean indeterminate;
        long now = System.currentTimeMillis();
        if (now < this.lastPrint + this.minPeriod) {
            return "";
        }
        this.lastPrint = now;
        boolean bl = indeterminate = percent < 0;
        if (indeterminate) {
            int i2;
            NutsTextBuilder formattedLine = NutsTexts.of((NutsSession)this.session).builder();
            formattedLine.append((Object)this.getFormatter().getStart());
            int indeterminateSize = (int)(this.indeterminateSize * (float)this.size);
            boolean forward = true;
            if (indeterminateSize >= this.size) {
                indeterminateSize = this.size - 1;
            }
            if (indeterminateSize < 1) {
                indeterminateSize = 1;
            }
            int x = 0;
            if (indeterminateSize < this.size) {
                int p = this.size - indeterminateSize;
                int h = this.indeterminatePosition.evalIndeterminatePos(this, 2 * p);
                if (h < 0) {
                    h = -h;
                }
                if ((x = h % (2 * p)) >= p) {
                    forward = false;
                    x = 2 * p - x;
                }
            } else {
                x = 0;
            }
            if (x < 0) {
                x = 0;
            }
            StringBuilder sb = new StringBuilder();
            for (i2 = 0; i2 < x; ++i2) {
                sb.append(this.getFormatter().getIndicator(0.0f, i2));
            }
            for (i2 = 0; i2 < indeterminateSize; ++i2) {
                sb.append(this.getFormatter().getIntermediateIndicator(i2, indeterminateSize, x, forward));
            }
            formattedLine.append((Object)sb.toString(), NutsTextStyle.primary1());
            int r = this.size - x - indeterminateSize;
            sb.setLength(0);
            for (int i3 = 0; i3 < r; ++i3) {
                sb.append(this.getFormatter().getIndicator(0.0f, x + indeterminateSize + i3));
            }
            formattedLine.append((Object)sb.toString());
            formattedLine.append((Object)this.getFormatter().getEnd());
            return formattedLine.toString();
        }
        if (percent > 100) {
            percent = 100 - percent;
        }
        double d = (double)this.size / 100.0 * (double)percent;
        int x = (int)d;
        float rest = (float)(d - (double)x);
        NutsTextBuilder formattedLine = NutsTexts.of((NutsSession)this.session).builder();
        formattedLine.append((Object)this.getFormatter().getStart());
        StringBuilder sb = new StringBuilder();
        if (x > 0) {
            for (i = 0; i < x; ++i) {
                sb.append(this.getFormatter().getIndicator(1.0f, i));
            }
        }
        if (rest > 0.0f && this.size - x > 0) {
            sb.append(this.getFormatter().getIndicator(rest, x));
            for (i = 0; i < this.size - x - 1; ++i) {
                sb.append(this.getFormatter().getIndicator(0.0f, x + 1 + i));
            }
        } else {
            for (i = 0; i < this.size - x; ++i) {
                sb.append(this.getFormatter().getIndicator(0.0f, x + i));
            }
        }
        formattedLine.append((Object)sb.toString(), NutsTextStyle.primary1());
        formattedLine.append((Object)this.getFormatter().getEnd());
        return formattedLine.toString();
    }

    public void printProgress(int percent, String msg, NutsPrintStream out) {
        String p = this.progress(percent, msg);
        if (p == null || p.isEmpty()) {
            return;
        }
        out.print(p);
    }

    public String progress(int percent, String msg) {
        StringBuilder sb = new StringBuilder();
        if (this.maxMessage < this.columns) {
            this.maxMessage = this.columns;
        }
        int s2 = 0;
        if (this.formatted) {
            String p;
            if (msg == null) {
                msg = "";
            }
            NutsTexts txts = NutsTexts.of((NutsSession)this.session);
            int n = s2 = this.session == null ? msg.length() : txts.builder().append((Object)msg).textLength();
            if (this.isPrefixMoveLineStart()) {
                if (this.optionNewline) {
                    if (!this.isSuffixMoveLineStart()) {
                        sb.append("\n");
                    }
                } else {
                    sb.append(txts.ofCommand(NutsTerminalCommand.MOVE_LINE_START));
                }
            }
            if ((p = this.progress(percent)) == null || p.isEmpty()) {
                return "";
            }
            sb.append(p).append(" ");
            sb.append(msg);
            sb.append(CoreStringUtils.fillString(' ', this.maxMessage - s2));
            if (this.isSuffixMoveLineStart() && this.optionNewline) {
                sb.append("\n");
            }
        } else {
            s2 = msg.length();
            String p = this.progress(percent);
            if (p == null || p.isEmpty()) {
                return "";
            }
            sb.append(p).append(" ");
            sb.append(msg);
            sb.append(CoreStringUtils.fillString(' ', this.maxMessage - s2));
            sb.append(" ");
        }
        if (this.maxMessage < s2) {
            this.maxMessage = s2;
        }
        if (this.maxMessage > this.maxColumns) {
            this.maxMessage = this.maxColumns;
        }
        return sb.toString();
    }

    public float getIndeterminateSize() {
        return this.indeterminateSize;
    }

    public CProgressBar setIndeterminateSize(float indeterminateSize) {
        if (indeterminateSize <= 0.0f || indeterminateSize >= 1.0f) {
            indeterminateSize = 0.3f;
        }
        this.indeterminateSize = indeterminateSize;
        return this;
    }

    public static class DefaultIndeterminatePosition
    implements IndeterminatePosition {
        @Override
        public int evalIndeterminatePos(CProgressBar bar, int size) {
            int ss = 2 * Calendar.getInstance().get(13);
            int ms = Calendar.getInstance().get(14);
            if (ms > 500) {
                ++ss;
            }
            return ss;
        }
    }

    public static interface IndeterminatePosition {
        public int evalIndeterminatePos(CProgressBar var1, int var2);
    }

    public static interface Formatter {
        public String getIntermediateIndicator(int var1, int var2, int var3, boolean var4);

        public String getIndicator(float var1, int var2);

        public String getStart();

        public String getEnd();
    }

    public static class SimpleFormatter
    implements Formatter {
        private String style;
        private String intermediateForwardStyle;
        private String intermediateBackwardStyle;
        private String start;
        private String end;

        public SimpleFormatter(String style, String forward, String backward, String start, String end) {
            if (forward == null || forward.isEmpty()) {
                forward = style;
            }
            if (backward == null || backward.isEmpty()) {
                backward = forward;
            }
            this.style = style;
            this.intermediateForwardStyle = forward;
            this.intermediateBackwardStyle = backward;
            this.start = start == null ? "" : start;
            this.end = end == null ? "" : end;
        }

        @Override
        public String getIndicator(float itemDensity, int itemPosition) {
            return this.getIndicator(this.style, itemDensity, itemPosition);
        }

        public String getIndicator(String style, float itemDensity, int itemPosition) {
            int length = style.length();
            int p = (int)(itemDensity * (float)length);
            if (p < 0) {
                p = 0;
            } else if (p >= length) {
                p = length - 1;
            }
            return String.valueOf(style.charAt(p));
        }

        @Override
        public String getIntermediateIndicator(int intermediatePosition, int indeterminateSize, int intermediateStartPosition, boolean forward) {
            float density = (float)intermediatePosition * 1.0f / (float)indeterminateSize;
            if (forward) {
                int length = this.intermediateForwardStyle.length();
                int p = (int)(density * (float)length);
                if (p < 0) {
                    p = 0;
                } else if (p >= length) {
                    p = length - 1;
                }
                return String.valueOf(this.intermediateForwardStyle.charAt(p));
            }
            int length = this.intermediateBackwardStyle.length();
            int p = (int)(density * (float)length);
            if (p < 0) {
                p = 0;
            } else if (p >= length) {
                p = length - 1;
            }
            return String.valueOf(this.intermediateBackwardStyle.charAt(p));
        }

        @Override
        public String getStart() {
            return this.start;
        }

        @Override
        public String getEnd() {
            return this.end;
        }
    }
}

