/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.printstream;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import net.thevpc.nuts.NutsBootTerminal;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamFiltered;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamFormatted;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextStyled;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class NutsPrintStreamSystem
extends NutsPrintStreamBase {
    private final OutputStream out;
    private PrintStream base;

    public NutsPrintStreamSystem(OutputStream out, Boolean autoFlush, String encoding, Boolean ansi, NutsSession session, NutsSystemTerminalBase term) {
        this(out, autoFlush, encoding, ansi, session, new NutsPrintStreamBase.Bindings(), term);
    }

    protected NutsPrintStreamSystem(OutputStream out, PrintStream base, Boolean autoFlush, NutsTerminalMode mode, NutsSession session, NutsPrintStreamBase.Bindings bindings, NutsSystemTerminalBase term) {
        super(autoFlush == null || autoFlush != false, mode, session, bindings, term);
        this.setFormattedName((NutsString)new DefaultNutsTextStyled(session, new DefaultNutsTextPlain(session, "<system-stream>"), NutsTextStyles.of((NutsTextStyle)NutsTextStyle.path())));
        this.out = out;
        this.base = base;
    }

    public PrintStream getBase() {
        return this.base;
    }

    public NutsPrintStreamSystem(OutputStream out, Boolean autoFlush, String encoding, Boolean ansi, NutsSession session, NutsPrintStreamBase.Bindings bindings, NutsSystemTerminalBase term) {
        super(true, NutsPrintStreamSystem.resolveMode(out, ansi, session), session, bindings, term);
        this.setFormattedName((NutsString)new DefaultNutsTextStyled(session, new DefaultNutsTextPlain(session, "<system-stream>"), NutsTextStyles.of((NutsTextStyle)NutsTextStyle.path())));
        this.out = out;
        if (out instanceof PrintStream) {
            PrintStream ps = (PrintStream)out;
            if (autoFlush == null && encoding == null) {
                this.base = ps;
            }
        }
        if (this.base == null) {
            try {
                this.base = encoding == null ? new PrintStream(out, autoFlush != null && autoFlush != false) : new PrintStream(out, autoFlush != null && autoFlush != false, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        switch (this.mode()) {
            case ANSI: {
                if (bindings.ansi != null) {
                    throw new IllegalArgumentException("already bound ansi");
                }
                bindings.ansi = this;
                if (bindings.inherited != null) break;
                bindings.inherited = this;
                break;
            }
            case INHERITED: {
                if (bindings.inherited != null) {
                    throw new IllegalArgumentException("already bound ansi");
                }
                bindings.inherited = this;
            }
        }
    }

    private static NutsTerminalMode resolveMode(OutputStream out, Boolean ansi, NutsSession session) {
        if (ansi != null) {
            return ansi != false ? NutsTerminalMode.ANSI : NutsTerminalMode.INHERITED;
        }
        NutsBootTerminal b = session.boot().getBootTerminal();
        if (b.getFlags().contains("ansi")) {
            return NutsTerminalMode.ANSI;
        }
        return NutsTerminalMode.INHERITED;
    }

    public NutsPrintStream flush() {
        this.base.flush();
        return this;
    }

    public NutsPrintStream close() {
        if (this.mode() == NutsTerminalMode.ANSI) {
            this.write("\u001b[0m".getBytes());
            this.flush();
        }
        this.base.close();
        return this;
    }

    public NutsPrintStream write(int b) {
        this.base.write(b);
        return this;
    }

    public NutsPrintStream write(byte[] buf, int off, int len) {
        this.base.write(buf, off, len);
        return this;
    }

    public NutsPrintStream write(char[] buf, int off, int len) {
        if (buf == null) {
            this.base.print("null");
        } else {
            this.base.print(new String(buf, off, len));
        }
        return this;
    }

    public NutsPrintStream print(String s) {
        this.base.print(s);
        return this;
    }

    public NutsPrintStream setSession(NutsSession session) {
        if (session == null || session == this.session) {
            return this;
        }
        return new NutsPrintStreamSystem(this.out, this.base, this.autoFlash, this.mode(), session, new NutsPrintStreamBase.Bindings(), this.getTerminal());
    }

    @Override
    public NutsPrintStream print(char[] s) {
        this.base.print(s);
        return this;
    }

    @Override
    protected NutsPrintStream convertImpl(NutsTerminalMode other) {
        switch (other) {
            case FORMATTED: {
                return new NutsPrintStreamFormatted(this, this.getSession(), this.bindings);
            }
            case FILTERED: {
                return new NutsPrintStreamFiltered(this, this.getSession(), this.bindings);
            }
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported %s -> %s", (Object[])new Object[]{this.mode(), other}));
    }

    public NutsPrintStream run(NutsTerminalCommand command, NutsSession session) {
        switch (command.getName()) {
            default: 
        }
        return null;
    }
}

