/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.printstream;

import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamFiltered;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamHelper;
import net.thevpc.nuts.runtime.standalone.text.FormatOutputStreamSupport;

public abstract class NutsPrintStreamRendered
extends NutsPrintStreamBase {
    protected FormatOutputStreamSupport support;
    protected NutsPrintStreamBase base;

    public NutsPrintStreamRendered(NutsPrintStreamBase base, NutsSession session, NutsTerminalMode mode, NutsPrintStreamBase.Bindings bindings) {
        super(true, mode, session, bindings, base.getTerminal());
        this.base = base;
        this.support = new FormatOutputStreamSupport(new NutsPrintStreamHelper(base), session, base.getTerminal(), mode != NutsTerminalMode.ANSI && mode != NutsTerminalMode.FORMATTED);
    }

    public NutsPrintStreamBase getBase() {
        return this.base;
    }

    public NutsPrintStream flush() {
        this.support.flush();
        this.base.flush();
        return this;
    }

    public NutsPrintStream close() {
        this.flush();
        this.base.close();
        return this;
    }

    public NutsPrintStream write(int b) {
        this.support.processByte(b);
        return this;
    }

    public NutsPrintStream write(byte[] buf, int off, int len) {
        this.support.processBytes(buf, off, len);
        return this;
    }

    public NutsPrintStream write(char[] buf, int off, int len) {
        this.support.processChars(buf, 0, buf.length);
        return this;
    }

    public NutsPrintStream print(String s) {
        if (s == null) {
            this.write("null".toCharArray());
        } else {
            this.write(s.toCharArray());
        }
        return this;
    }

    @Override
    protected NutsPrintStream convertImpl(NutsTerminalMode other) {
        switch (other) {
            case FILTERED: {
                return new NutsPrintStreamFiltered(this.base, this.getSession(), this.bindings);
            }
        }
        throw new NutsIllegalArgumentException(this.base.getSession(), NutsMessage.cstyle((String)"unsupported %s -> %s", (Object[])new Object[]{this.mode(), other}));
    }
}

