/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.printstream;

import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamFiltered;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamRendered;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextPlain;
import net.thevpc.nuts.runtime.standalone.text.parser.DefaultNutsTextStyled;

public class NutsPrintStreamFormatted
extends NutsPrintStreamRendered {
    public NutsPrintStreamFormatted(NutsPrintStreamBase base, NutsSession session, NutsPrintStreamBase.Bindings bindings) {
        super(base, session, NutsTerminalMode.FORMATTED, bindings);
        if (bindings.formatted != null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"formatted already bound"));
        }
        this.setFormattedName((NutsString)new DefaultNutsTextStyled(session, new DefaultNutsTextPlain(session, "<formatted-stream>"), NutsTextStyles.of((NutsTextStyle)NutsTextStyle.path())));
        bindings.formatted = this;
    }

    public NutsPrintStream setSession(NutsSession session) {
        if (session == null || session == this.session) {
            return this;
        }
        return new NutsPrintStreamFormatted(this.base, session, new NutsPrintStreamBase.Bindings());
    }

    @Override
    protected NutsPrintStream convertImpl(NutsTerminalMode other) {
        switch (other) {
            case FILTERED: {
                return new NutsPrintStreamFiltered(this.base, this.getSession(), this.bindings);
            }
        }
        throw new NutsIllegalArgumentException(this.base.getSession(), NutsMessage.cstyle((String)"unsupported %s -> %s", (Object[])new Object[]{this.mode(), other}));
    }

    public NutsPrintStream run(NutsTerminalCommand command, NutsSession session) {
        this.flush();
        this.printf("%s", NutsTexts.of((NutsSession)this.session).ofCommand(command));
        this.flush();
        return this;
    }
}

