/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.printstream;

import java.io.OutputStream;
import java.io.Writer;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPrintStreamAdapter;
import net.thevpc.nuts.NutsPrintStreams;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSystemTerminal;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNutsBootManager;
import net.thevpc.nuts.runtime.standalone.boot.NutsBootModel;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsByteArrayPrintStream;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamRaw;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamRendered;
import net.thevpc.nuts.runtime.standalone.io.printstream.NutsPrintStreamSystem;
import net.thevpc.nuts.runtime.standalone.text.SimpleWriterOutputStream;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigModel;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class DefaultNutsPrintStreams
implements NutsPrintStreams {
    private final NutsSession session;

    public DefaultNutsPrintStreams(NutsSession session) {
        this.session = session;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    public NutsPrintStream createNull() {
        this.checkSession();
        return this.getBootModel().nullPrintStream();
    }

    public NutsMemoryPrintStream createInMemory() {
        this.checkSession();
        return new NutsByteArrayPrintStream(this.getSession());
    }

    public NutsPrintStream create(OutputStream out, NutsTerminalMode expectedMode, NutsSystemTerminalBase term) {
        if (out == null) {
            return null;
        }
        NutsWorkspaceOptions woptions = this.session.boot().setSession(this.session).getBootOptions();
        NutsTerminalMode expectedMode0 = woptions.getTerminalMode();
        if (expectedMode0 == null) {
            expectedMode0 = woptions.isBot() ? NutsTerminalMode.FILTERED : NutsTerminalMode.FORMATTED;
        }
        if (expectedMode == null) {
            expectedMode = expectedMode0;
        }
        if (expectedMode == NutsTerminalMode.FORMATTED && expectedMode0 == NutsTerminalMode.FILTERED) {
            expectedMode = NutsTerminalMode.FILTERED;
        }
        if (out instanceof NutsPrintStreamAdapter) {
            return ((NutsPrintStreamAdapter)out).getBasePrintStream().setMode(expectedMode);
        }
        return new NutsPrintStreamRaw(out, null, null, this.session, new NutsPrintStreamBase.Bindings(), term).setMode(expectedMode);
    }

    public NutsPrintStream create(OutputStream out) {
        this.checkSession();
        return new NutsPrintStreamRaw(out, null, null, this.session, new NutsPrintStreamBase.Bindings(), null);
    }

    public NutsPrintStream create(Writer out, NutsTerminalMode mode, NutsSystemTerminalBase terminal) {
        this.checkSession();
        if (mode == null) {
            mode = NutsTerminalMode.INHERITED;
        }
        if (out == null) {
            return null;
        }
        if (out instanceof NutsPrintStreamAdapter) {
            return ((NutsPrintStreamAdapter)out).getBasePrintStream().setMode(mode);
        }
        SimpleWriterOutputStream w = new SimpleWriterOutputStream(out, terminal, this.session);
        return this.create(w, mode, terminal);
    }

    public NutsPrintStream create(Writer out) {
        this.checkSession();
        return this.create(out, NutsTerminalMode.INHERITED, null);
    }

    public boolean isStdout(NutsPrintStream out) {
        if (out == null) {
            return false;
        }
        NutsSystemTerminal st = this.getBootModel().getSystemTerminal();
        if (out == st.out()) {
            return true;
        }
        if (out instanceof NutsPrintStreamRendered) {
            return this.isStdout(((NutsPrintStreamRendered)out).getBase());
        }
        return out instanceof NutsPrintStreamSystem;
    }

    public boolean isStderr(NutsPrintStream out) {
        if (out == null) {
            return false;
        }
        NutsSystemTerminal st = this.getBootModel().getSystemTerminal();
        if (out == st.err()) {
            return true;
        }
        if (out instanceof NutsPrintStreamRendered) {
            return this.isStderr(((NutsPrintStreamRendered)out).getBase());
        }
        return out instanceof NutsPrintStreamSystem;
    }

    public NutsPrintStream stdout() {
        return this.getBootModel().getSystemTerminal().out();
    }

    public NutsPrintStream stderr() {
        return this.getBootModel().getSystemTerminal().err();
    }

    public NutsSession getSession() {
        return this.session;
    }

    private void checkSession() {
    }

    private DefaultNutsWorkspaceConfigModel getConfigModel() {
        return ((DefaultNutsWorkspaceConfigManager)this.session.config()).getModel();
    }

    private NutsBootModel getBootModel() {
        return ((DefaultNutsBootManager)this.session.boot()).getModel();
    }
}

