/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupported;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.AbstractHtmlfsParser;
import net.thevpc.nuts.runtime.standalone.util.XmlEscaper;

public class TomcatWebServerHtmlfsParser
extends AbstractHtmlfsParser {
    @Override
    public NutsSupported<List<String>> parseHtmlTomcat(byte[] bytes, NutsSession session) {
        boolean expectTomcat = false;
        try (BufferedReader br2 = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));){
            String line = null;
            while ((line = br2.readLine()) != null) {
                if (!line.contains("<hr class=\"line\"><h3>Apache Tomcat")) continue;
                expectTomcat = true;
            }
        }
        catch (Exception br2) {
            // empty catch block
        }
        if (!expectTomcat) {
            return NutsSupported.invalid();
        }
        Pattern pattern = Pattern.compile("<a href=\"(?<href>[^\"]+)\"><tt>(?<title>[^<]+)</tt></a></td>");
        ArrayList<String> found = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));){
            String line = null;
            while ((line = br.readLine()) != null) {
                Matcher m = pattern.matcher(line = line.trim());
                if (!m.find()) continue;
                found.add(XmlEscaper.escapeToUnicode(m.group("title"), session));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.toSupported(5, found);
    }
}

